/*
 * linux/include/asm-arm/arch-ixp2000/irqs.h
 *
 * Original Author:	Naeem Afzal <naeem.m.afzal@intel.com>
 * Maintainer: Deepak Saxena <dsaxena@mvista.com>
 *
 * Copyright:	(C) 2002-2004 Intel Corp.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Changelog:
 *  05-Aug-2004: Andrzej Mialkowski <andrzej.mialkowski@intel.com>
 *     - Updated to support IXDP2801 spin3 boards
 */

#ifndef _IRQS_H
#define _IRQS_H

/*
 * Some interrupt numbers go unused b/c the IRQ mask/ummask/status
 * register has those bit reserved. We just mark those interrupts
 * as invalid and this allows us to do mask/unmask with a single
 * shit operation instead of having to map the IRQ number to
 * a HW IRQ number.
 */
#define	IRQ_IXP2000_SWI			0 /* soft interrupt */
#define	IRQ_IXP2000_ERRSUM		1 /* OR of all bits in ErrorStatus reg*/
#define	IRQ_IXP2000_UART		2
#define	IRQ_IXP2000_GPIO		3
#define	IRQ_IXP2000_TIMER1     		4
#define	IRQ_IXP2000_TIMER2     		5
#define	IRQ_IXP2000_TIMER3     		6
#define	IRQ_IXP2000_TIMER4     		7
#define	IRQ_IXP2000_PMU        		8               
#define	IRQ_IXP2000_SPF        		9  /* Slow port framer IRQ */
#define	IRQ_IXP2000_DMA1      		10
#define	IRQ_IXP2000_DMA2      		11
#define	IRQ_IXP2000_DMA3      		12
#define	IRQ_IXP2000_PCI_DOORBELL	13
#define	IRQ_IXP2000_ME_ATTN       	14 
#define	IRQ_IXP2000_PCI   		15 /* PCI INTA or INTB */
#define	IRQ_IXP2000_THDA0   		16 /* thread 0-31A */
#define	IRQ_IXP2000_THDA1  		17 /* thread 32-63A */
#define	IRQ_IXP2000_THDA2		18 /* thread 64-95A */
#define	IRQ_IXP2000_THDA3 		19 /* thread 96-127A */
#define	IRQ_IXP2000_THDB0  		24 /* thread 0-31 B */
#define	IRQ_IXP2000_THDB1  		25 /* thread 32-63B */
/* only 64 threads supported for IXP2400, rest or for IXP2800*/
#define	IRQ_IXP2000_THDB2  		26 /* thread 64-95B */
#define	IRQ_IXP2000_THDB3 		27 /* thread 96-127B */

/* define generic GPIOs */
#define IRQ_IXP2000_GPIO0               32
#define IRQ_IXP2000_GPIO1               33
#define IRQ_IXP2000_GPIO2               34
#define IRQ_IXP2000_GPIO3               35
#define IRQ_IXP2000_GPIO4               36
#define IRQ_IXP2000_GPIO5               37
#define IRQ_IXP2000_GPIO6               38
#define IRQ_IXP2000_GPIO7               39

/* split off the 2 PCI sources */
#define IRQ_IXP2000_PCIA                40
#define IRQ_IXP2000_PCIB                41

/* Int sources from IRQ_ERROR_STATUS */
#define IRQ_IXP2000_DRAM0_MIN_ERR       42
#define IRQ_IXP2000_DRAM0_MAJ_ERR       43
#define IRQ_IXP2000_DRAM1_MIN_ERR       44
#define IRQ_IXP2000_DRAM1_MAJ_ERR       45
#define IRQ_IXP2000_DRAM2_MIN_ERR       46
#define IRQ_IXP2000_DRAM2_MAJ_ERR       47
#define IRQ_IXP2000_SRAM0_ERR           58
#define IRQ_IXP2000_SRAM1_ERR           59
#define IRQ_IXP2000_SRAM2_ERR           60
#define IRQ_IXP2000_SRAM3_ERR           61
#define IRQ_IXP2000_MEDIA_ERR           66
#define IRQ_IXP2000_PCI_ERR             67
#define IRQ_IXP2000_SP_INT              68

#define NR_IXP2000_IRQS                 74
#if defined(CONFIG_ARCH_IXDP2400)

/* 
 * IXDP2400 specific IRQs
 */
#define	IRQ_IXDP2400(x)			(NR_IXP2000_IRQS + (x))

#define	IRQ_IXDP2400_INGRESS_NPU	IRQ_IXDP2400(0) /* Slave NPU irq */
#define	IRQ_IXDP2400_METHERNET		IRQ_IXDP2400(1) /* Master NPU NIC irq */
#define	IRQ_IXDP2400_MEDIA_PCI		IRQ_IXDP2400(2) /* Media on PCI irq */
#define	IRQ_IXDP2400_MEDIA_SP		IRQ_IXDP2400(3) /* Media on SlowPort */
#define	IRQ_IXDP2400_SF_PCI		IRQ_IXDP2400(4) /* Sw Fab. on PCI */
#define	IRQ_IXDP2400_SF_SP		IRQ_IXDP2400(5) /* Switch Fab on SP */
#define	IRQ_IXDP2400_PMC		IRQ_IXDP2400(6) /* PMC slot ineterrupt*/
#define	IRQ_IXDP2400_TVM		IRQ_IXDP2400(7) /* Temp & Voltage */

#define	NR_IXDP2400_IRQS   		((IRQ_IXDP2400_TVM)+1)  

#undef NR_IRQS
#define NR_IRQS 			NR_IXDP2400_IRQS

#elif defined(CONFIG_ARCH_IXDP2401)
/* 
 * IXDP2401 specific IRQs
 */
#define	IRQ_IXDP2401(x)			(NR_IXP2000_IRQS + (x))

#define IXDP2401_MAX_CPLD_INT		32 /* Bits in CPLD */

#define IRQ_IXDP2401_INTA_82546		IRQ_IXDP2401(0)
#define IRQ_IXDP2401_INTB_82546		IRQ_IXDP2401(1)
#define IRQ_IXDP2401_SPCI_DB_0		IRQ_IXDP2401(2)
#define IRQ_IXDP2401_SPCI_DB_1		IRQ_IXDP2401(3)
#define IRQ_IXDP2401_SPCI_PMC_INTA	IRQ_IXDP2401(4)
#define IRQ_IXDP2401_SPCI_PMC_INTB	IRQ_IXDP2401(5)
#define IRQ_IXDP2401_SPCI_PMC_INTC	IRQ_IXDP2401(6)
#define IRQ_IXDP2401_SPCI_PMC_INTD	IRQ_IXDP2401(7)
#define IRQ_IXDP2401_SPCI_FIC_INT	IRQ_IXDP2401(8)
#define IRQ_IXDP2401_IPMI_FROM		IRQ_IXDP2401(16)
#define IRQ_IXDP2401_125US		IRQ_IXDP2401(17)
#define IRQ_IXDP2401_DB_0_ADD		IRQ_IXDP2401(18)
#define IRQ_IXDP2401_DB_1_ADD		IRQ_IXDP2401(19)
#define IRQ_IXDP2401_PMC_ADD		IRQ_IXDP2401(20)
#define IRQ_IXDP2401_ADD_UART		IRQ_IXDP2401(21)
#define IRQ_IXDP2401_SAUS_UART		IRQ_IXDP2401(22)
#define IRQ_IXDP2401_FIC_ADD_INT	IRQ_IXDP2401(24)
#define IRQ_IXDP2401_DEBUG_CRYST	IRQ_IXDP2401(25)
#define IRQ_IXDP2401_BBSRAM		IRQ_IXDP2401(26)

#define IXDP2401_IRQ_CPLD_MASK(irq) (1 << (irq - NR_IXP2000_IRQS))

#define IXDP2401_VALID_IRQ_CPLD_MASK ( \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_INTA_82546)	| \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_INTB_82546)	| \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_SPCI_DB_0) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_SPCI_DB_1) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_SPCI_PMC_INTA) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_SPCI_PMC_INTB) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_SPCI_PMC_INTC) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_SPCI_PMC_INTD) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_SPCI_FIC_INT) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_IPMI_FROM)	| \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_125US) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_DB_0_ADD) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_DB_1_ADD) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_PMC_ADD) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_ADD_UART) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_SAUS_UART) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_FIC_ADD_INT) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_DEBUG_CRYST) | \
	IXDP2401_IRQ_CPLD_MASK(IRQ_IXDP2401_BBSRAM))

#define IRQ_IXP2000_INTERRUPT	(IRQ_IXDP2401(IXDP2401_MAX_CPLD_INT))
#define NR_IXDP2401_IRQS	(IRQ_IXP2000_INTERRUPT)
#undef	NR_IRQS
#define	NR_IRQS (NR_IXDP2401_IRQS)

#elif defined(CONFIG_ARCH_IXDP2800)

/* IXDP2800 specific IRQs */
#define IRQ_IXDP2800(x)                 (NR_IXP2000_IRQS + (x))
#define IRQ_IXDP2800_EGRESS_NIC         IRQ_IXDP2800(0)
#define IRQ_IXDP2800_INGRESS_NPU        IRQ_IXDP2800(1)
#define IRQ_IXDP2800_PMC_PCI            IRQ_IXDP2800(2)
#define IRQ_IXDP2800_FABRIC_PCI         IRQ_IXDP2800(3)
#define IRQ_IXDP2800_FABRIC             IRQ_IXDP2800(4)
#define IRQ_IXDP2800_MEDIA              IRQ_IXDP2800(5)

#define IRQ_IXP2000_INTERRUPT   	(IRQ_IXDP2800_FABRIC)
#define NR_IXDP2800_IRQS        	(IRQ_IXDP2800_MEDIA+1)

#undef NR_IRQS
#define NR_IRQS				NR_IXDP2800_IRQS
#elif defined(CONFIG_ARCH_IXDP2801)
/* 
 * IXDP2801 specific IRQs
 */
#define	IRQ_IXDP2801(x)			(NR_IXP2000_IRQS + (x))

#define IXDP2801_MAX_CPLD_INT		32 /* Bits in CPLD */

#define IRQ_IXDP2801_RIV_INT		IRQ_IXDP2801(0)
#define IRQ_IXDP2801_SPCI_DB_0		IRQ_IXDP2801(2)
#define IRQ_IXDP2801_SPCI_DB_1		IRQ_IXDP2801(3)
#define IRQ_IXDP2801_SPCI_PMC_INTA	IRQ_IXDP2801(4)
#define IRQ_IXDP2801_SPCI_PMC_INTB	IRQ_IXDP2801(5)
#define IRQ_IXDP2801_SPCI_PMC_INTC	IRQ_IXDP2801(6)
#define IRQ_IXDP2801_SPCI_PMC_INTD	IRQ_IXDP2801(7)
#define IRQ_IXDP2801_SPCI_FIC_INT	IRQ_IXDP2801(8)
#define IRQ_IXDP2801_GBE_PHY_1_INT	IRQ_IXDP2801(9)  /* spin 3 only */
#define IRQ_IXDP2801_GBE_PHY_2_INT	IRQ_IXDP2801(10) /* spin 3 only */
#define IRQ_IXDP2801_GBE_PHY_3_INT	IRQ_IXDP2801(11) /* spin 3 only */
#define IRQ_IXDP2801_GBE_PHY_4_INT	IRQ_IXDP2801(12) /* spin 3 only */
#define IRQ_IXDP2801_INTA_82546		IRQ_IXDP2801(13) /* spin 3 only */
#define IRQ_IXDP2801_INTB_82546		IRQ_IXDP2801(14) /* spin 3 only */
#define IRQ_IXDP2801_IPMI_FROM		IRQ_IXDP2801(16)
#define IRQ_IXDP2801_125US		IRQ_IXDP2801(17) /* N/A on spin 3*/
#define IRQ_IXDP2801_DB_0_ADD		IRQ_IXDP2801(18)
#define IRQ_IXDP2801_DB_1_ADD		IRQ_IXDP2801(19)
#define IRQ_IXDP2801_ADD_UART		IRQ_IXDP2801(21)
#define IRQ_IXDP2801_SAUS_UART		IRQ_IXDP2801(22)
#define IRQ_IXDP2801_THERM_AL_INT	IRQ_IXDP2801(23) /* spin 3 only */
#define IRQ_IXDP2801_FIC_ADD_INT	IRQ_IXDP2801(24)
#define IRQ_IXDP2801_DEBUG_CRYST	IRQ_IXDP2801(25)
#define IRQ_IXDP2801_BBSRAM		IRQ_IXDP2801(26)
#define IRQ_IXDP2801_CNFG_MEDIA_INT	IRQ_IXDP2801(27) /* N/A on spin 3*/
#define IRQ_IXDP2801_CLOCK_REF_INT	IRQ_IXDP2801(28)

#define IXDP2801_IRQ_CPLD_MASK(irq) (1 << (irq - NR_IXP2000_IRQS))

#define IXDP2801_VALID_IRQ_CPLD_MASK ( \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_RIV_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_SPCI_DB_0) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_SPCI_DB_1) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_SPCI_PMC_INTA) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_SPCI_PMC_INTB) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_SPCI_PMC_INTC) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_SPCI_PMC_INTD) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_SPCI_FIC_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_GBE_PHY_1_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_GBE_PHY_2_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_GBE_PHY_3_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_GBE_PHY_4_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_INTA_82546) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_INTB_82546) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_IPMI_FROM) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_125US) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_DB_0_ADD) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_DB_1_ADD) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_ADD_UART) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_SAUS_UART) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_THERM_AL_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_FIC_ADD_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_DEBUG_CRYST) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_BBSRAM) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_CNFG_MEDIA_INT) | \
	IXDP2801_IRQ_CPLD_MASK(IRQ_IXDP2801_CLOCK_REF_INT))

#define IRQ_IXP2000_INTERRUPT	(IRQ_IXDP2801(IXDP2801_MAX_CPLD_INT))
#define NR_IXDP2801_IRQS	(IRQ_IXP2000_INTERRUPT)
#undef	NR_IRQS
#define	NR_IRQS (NR_IXDP2801_IRQS)

#endif /* CONFIG_ARCH_XXX */

#define	XSCALE_PMU_IRQ	IRQ_IXP2000_PMU

#endif /*_IRQS_H*/
