/*
 * linux/include/asm-arm/arch-ixdp2000/io.h
 *
 * Author: Naeem M Afzal <naeem.m.afzal@intel.com>
 *
 * Copyright (C) 2002  Intel Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ASM_ARM_ARCH_IO_H
#define __ASM_ARM_ARCH_IO_H

/*
 * Pick up VMALLOC_END
 */
#include <linux/vmalloc.h>

#define IO_SPACE_LIMIT 0xffffffff

#define __io_pci(a)		(PCIO_BASE + (a))
#define __mem_isa(a)		((unsigned long)(a))

/*
 * We don't need this for now. If we get to the point where
 * we need to have > 64K I/O access, we need to fix this so
 * that it saves/restores the previous I/O window setting.
 */
#if 0
static inline unsigned __ixp_io(unsigned long p)
{
	unsigned long ext = *IXP2000_PCI_ADDR_EXT & 0xffff;

	ext |= p & 0xffff0000;

	*IXP2000_PCI_ADDR_EXT = ext;

	return __io_pci(p);
}
#endif

/*
 * Generic virtual read/write
 */

extern __inline__ unsigned int __arch_getw(unsigned long a)
{
	unsigned int value;
	__asm__ __volatile__("ldr%?h	%0, [%1, #0]	@ getw"
		: "=&r" (value)
		: "r" (a));
	return value;
}

extern __inline__ void __arch_putw(unsigned int value, unsigned long a)
{
	__asm__ __volatile__("str%?h	%0, [%1, #0]	@ putw"
		: : "r" (value), "r" (a));
}

/*
 * IXP2000 currently does not do bytelane or data swapping on
 * PCI I/O cycles, so we need to override the default functions.
 *
 * Will retest once we have "working" silicon.
 */
#define alignb(addr) ((addr & ~3) + (3 - (addr & 3)))
#define alignw(addr) ((addr & ~2) + (2 - (addr & 2)))

#define outb(v,p)			__raw_writeb(v,alignb(__io_pci(p)))
#define outw(v,p)			__raw_writew((v),alignw(__io_pci(p)))
#define outl(v,p)			__raw_writel((v),__io_pci(p))

#define inb(p)		({ unsigned int __v = __raw_readb(alignb(__io_pci(p))); __v; })
#define inw(p)		\
	({ unsigned int __v = (__raw_readw(alignw(__io_pci(p)))); __v; })
#define inl(p)		\
	({ unsigned int __v = (__raw_readl(__io_pci(p))); __v; })

#define outsb(p,d,l)			__raw_writesb(alignb(__io_pci(p)),d,l)
#define outsw(p,d,l)			__raw_writesw(alignw(__io_pci(p)),d,l)
#define outsl(p,d,l)			__raw_writesl(__io_pci(p),d,l)

#define insb(p,d,l)			__raw_readsb(alignb(__io_pci(p)),d,l)
#define insw(p,d,l)			__raw_readsw(alignw(__io_pci(p)),d,l)
#define insl(p,d,l)			__raw_readsl(__io_pci(p),d,l)

/*
 * We need to override readl and writel b/c the serial driver uses them and
 * we don't want to do swapping.  We REALLY need ioremap_resource...
 */
#define readb(addr) \
	({ unsigned int __v = __raw_readb(addr); __v; })
#define readw(addr) \
	({ unsigned int __v = __le16_to_cpu(__raw_readw(addr)); \
	 __v; })

static inline unsigned int ixp_readl(void *addr)
{
	unsigned int __v;
	
	__v = __raw_readl(addr); 

	/*
	 * Are we a staticlly-mapped or dynamiclly mapped address?
	 */
	if((unsigned long)addr > VMALLOC_END)
		return __v;
	else
		return le32_to_cpu(__v);
}

#define	readl(v)	ixp_readl(v)
	

#define writeb(val,addr)		__raw_writeb(val,addr)
#define writew(val,addr)	\
	__raw_writew(__cpu_to_le16(val),addr)

static inline void ixp_writel(unsigned int v, void *addr)
{
	if((unsigned int)addr < VMALLOC_END)
		v = cpu_to_le32(v);

	__raw_writel(v, addr);
}

#define	writel(v, a)	ixp_writel(v, a)

#define memset_io(a,b,c)		_memset_io((a),(b),(c))
#define memcpy_fromio(a,b,c)		_memcpy_fromio((a),(b),(c))
#define memcpy_toio(a,b,c)		_memcpy_toio((a),(b),(c))

#define eth_io_copy_and_sum(a,b,c,d) \
				eth_copy_and_sum((a),(b),(c),(d))

#define check_signature(io,sig,len)	(0)

#define __arch_ioremap	__ioremap
#define __arch_iounmap	__iounmap

#endif
