/*
 * linux/include/asm-arm/arch-iop3xx/iop321-dma.h
 *
 *  Copyright (C) 2002 Intel Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _IOP321_DMA_H_
#define _IOP321_DMA_H_

/* 2 DMA on primary PCI and 1 on secondary for 80310 */
#define MAX_IOP321_DMA_CHANNEL   2
#define MAX_DMA_DESC        	64	/*128 */

/*
 * Make the generic DMA bits go away since we don't use it
 */
#define MAX_DMA_CHANNELS	0

#define MAX_DMA_ADDRESS		0xffffffff

#define DMA_POLL         0x0
#define DMA_INTERRUPT    0x1

#define DMA_DCR_MTM     0x00000040  /* memory to memory transfer */
#define DMA_DCR_DAC		0x00000020	/* Dual Addr Cycle Enab */
#define DMA_DCR_IE		0x00000010	/* Interrupt Enable */
#define DMA_DCR_PCI_IOR		0x00000002	/* I/O Read */
#define DMA_DCR_PCI_IOW		0x00000003	/* I/O Write */
#define DMA_DCR_PCI_MR		0x00000006	/* Memory Read */
#define DMA_DCR_PCI_MW		0x00000007	/* Memory Write */
#define DMA_DCR_PCI_CR		0x0000000A	/* Configuration Read */
#define DMA_DCR_PCI_CW		0x0000000B	/* Configuration Write */
#define DMA_DCR_PCI_MRM		0x0000000C	/* Memory Read Multiple */
#define DMA_DCR_PCI_MRL		0x0000000E	/* Memory Read Line */
#define DMA_DCR_PCI_MWI		0x0000000F	/* Mem Write and Inval */

extern iop321_dma_t dma_chan[2];

/* function prototypes */
void* dma_memcpy(void* to, const void* from, __kernel_size_t n);
unsigned long dma_copy_to_user(void* to, const void* from, unsigned long n);
unsigned long dma_copy_from_user(void* to, const void* from, unsigned long n);

#endif /* _ASM_ARCH_DMA_H */
