/*
 * include/asm-arm/arch-epxa/preem_latency.h
 *
 * Support for preemptible kernel latency measurement times
 *
 * 2003 (c) MontaVista Software, Inc.  This file is licensed under
 * the terms of the GNU General Public License version 2.  This program
 * is licensed "as is" without any warranty of any kind, whether
 * express or implied.
 *
 * Note: 
 * The readclock() macro must return the contents of a monotonic incremental
 * counter.
 *
 */

#include <linux/config.h>
#include <linux/types.h>
#include <asm/hardware.h>
#include <asm/arch/timer00.h>

#define TIMER00_TYPE (volatile unsigned int*)

/* enable timer in free-running mode*/

#define readclock_init()	do {					\
  *TIMER1_LIMIT(IO_ADDRESS(EXC_TIMER00_BASE))=0xFFFFFFFF; \
  *TIMER1_CR(IO_ADDRESS(EXC_TIMER00_BASE))= TIMER1_CR_S_MSK ; \
  } while (0)

//#define readclock(x) (do {x = *TIMER1_READ(IO_ADDRESS(EXC_TIMER00_BASE)) } while (0))
#define readclock(x) do { x = *TIMER1_READ(IO_ADDRESS(EXC_TIMER00_BASE)); } while (0)

#define clock_to_usecs(x) ((x) / 100)	/* Assumes 100 Mhz clk */

#define TICKS_PER_USEC          100
