/*
 * linux/drivers/video/versatile-clcd/clcd.h -- Versatile LCD panel.
 *
 * David A Rusling - Philippe Robin
 *
 * Copyright (C) 2002,2003 ARM Limited
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive
 * for more details.
 */

// VERSATILE_SYS_CLCD register
#define VERSATILE_SYS_CLCD_MODE   0x03    // Mode mask
#define VERSATILE_SYS_CLCD_555    0x01    // Mode is 5-5-5 mux
#define VERSATILE_SYS_CLCD_24     0x00    // Mode is 24bit
#define VERSATILE_SYS_CLCD_EN     0x14    // Enable CLCD and VGA

#define VERSATILE_3x8_PANEL	0
#define VERSATILE_8x4_PANEL	1
#define VERSATILE_2x2_PANEL	2

#define BITS_PER_PIXEL	16
#define LTM10C209    1
#define PROSPECTOR   2
#define SVGA         3
#define VGA          4

#define PANEL PROSPECTOR

#define CM_OSC_25MHz	0x00012C11

#define IMPD1_CTRL 0x18
#define IMPD1_USE_VGA         1
#define IMPD1_USE_LCD1        2
#define IMPD1_ENABLE_DISPLAY  4

// CLCD Controller Internal Register addresses
#define CLCD_REGS       (VERSATILE_CLCD_BASE)
#define CLCD_TIM0	0x00000000
#define CLCD_TIM1 	0x00000004
#define CLCD_TIM2 	0x00000008
#define CLCD_TIM3 	0x0000000c
#define CLCD_UBAS 	0x00000010
#define CLCD_LBAS 	0x00000014
#define CLCD_IENB 	0x0000001c	/* was 0x18 */
#define CLCD_CNTL 	0x00000018	/* was 0x1C */
#define CLCD_STAT 	0x00000020
#define CLCD_INTR 	0x00000024
#define CLCD_UCUR 	0x00000028
#define CLCD_LCUR 	0x0000002C
#define CLCD_PALL 	0x00000200
#define CLCD_PALETTE	0x00000200

#define PANEL_NAME "VGA"

// Timing Reg 0 
#define HSW 		((WORD)63) 
#define HFP 		((WORD)31) 
#define HBP 		((WORD)63) 

// Timing Reg 1 
#define VSW 		((WORD)24) 
#define VFP 		((WORD)11) 
#define VBP 		((WORD)9) 

// Timing Reg 2
#define PCD 		((WORD)0)
#define CLKSEL		((WORD)0)
#define ACB 		((WORD)0)
#define IVS 		((WORD)1)
#define IHS 		((WORD)1)
#define IPC 		((WORD)0)
#define IOE 		((WORD)0)
#define CPL 		((WORD)(640-1))
#define BCD 		((WORD)1)

// Timing 3
#define CLCD_LED	0
#define CLCD_LEE	0

#define PIXEL_CLOCK_MHZ 25

// Control Register
#define LCDEN		((WORD)1)
#if BITS_PER_PIXEL==24
#	define LCDBPP 	((WORD)5)
#else
#if BITS_PER_PIXEL==16
#	define LCDBPP 	((WORD)4)
#else
#if BITS_PER_PIXEL==8
#	define LCDBPP 	((WORD)3)
#else
#error Unknown bits per pixel (BITS_PER_PIXEL is not 8 or 16)
#endif
#endif
#endif

#define LCDBW		((WORD)0)
#define LCDTFT		((WORD)1)
#define LCDMONO8 	((WORD)0)
#define LCDDUAL 	((WORD)0)
#define BGR 		((WORD)0)
#define BEBO 		((WORD)0)
#define BEPO 		((WORD)0)
#define LCDPWR		((WORD)1)
#define LCDVCOMP 	((WORD)1)
#define LDMAFIFOTME 	((WORD)0)
#define WATERMARK 	((WORD)0)

// Interrupt enable register
#define FUFINTRENB          0x02
#define LNBUINTRENB         0x04
#define VCOMPINTRENB        0x08
#define MBERRINTRENB        0x10

// Macros for 16-bpp mode only
#if BITS_PER_PIXEL == 16 
#	define RGB(r,g,b)	{ (r & 0x1f) | ((g & 0x1f)<<5) | ((b & 0x1f)<<10) | (1<<15) }
#	define RGB_RED         	(rgb(255,0,0))
#	define RGB_GREEN       	(rgb(0,255,0))
#	define RGB_BLUE        	(rgb(0,0,255))
#	define RGB_YELLOW      	(rgb(255,255,0))
#	define RGB_CYAN        	(rgb(0,255,255))
#	define RGB_MAGENTA     	(rgb(255,0,255))
#	define RGB_BLACK       	(rgb(0,0,0))
#	define RGB_WHITE       	(rgb(255,255,255))
#endif

#define PALETTE_WORDS   	128	/* number of words in palette */

// Bitmap file parameters
#define BITMAP_PATH 		"c:\\clcd"	/* path to bitmap files */
#define MAX_BITMAPS		7	/* number of files scanned */



