/*
 * linux/drivers/usb/usb-ohci-lite5200.c
 *
 * USB OHCI Support for lite5200
 *
 * Author: MontaVista Software, Inc. <source@mvista.com>
 *	Copyright (c) 2004 MontaVista Software, Inc.
 *
 * The outline of this code was taken from Brad Parkers <brad@heeltoe.com>
 * original OHCI driver modifications, and reworked into a cleaner form
 * by Russell King <rmk@arm.linux.org.uk>.
 */
/*
 * Changes:
 *
 */
#include <linux/module.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/ioport.h>
#include <linux/interrupt.h>
#include <linux/slab.h>
#include <linux/pci.h>		/* for pci_pool_* prototypes */
#include <linux/usb.h>

#include <asm/irq.h>
#include <asm/io.h>
#include <asm/mpc5xxx.h>

#include "usb-ohci.h"

extern int
__devinit hc_add_ohci(struct pci_dev *dev, int irq, void *membase,
		      unsigned long flags, ohci_t ** ohci,
		      const char *name, const char *slot_name);
extern void hc_remove_ohci(ohci_t * ohci);

static ohci_t *lite5200_ohci;

/* bogus pci_dev structure */
static struct pci_dev bogus_pcidev;

static int __devinit lite5200_ohci_configure(void);
static void lite5200_ohci_release(void);

static int __devinit
lite5200_ohci_configure(void)
{
	int ret;
	volatile unsigned long data;

	data = 0x00015555;	
	out_be32((u32*)(MPC5xxx_MBAR + 0x0210), data);

	data = in_be32((u32*)(MPC5xxx_MBAR + 0x0b00));
	data |= 0<<(31-8) | 1<<(31-19) | 0<<(31-17);  // internal clock, USB1, not SE mode
	out_be32((u32*)(MPC5xxx_MBAR + 0x0b00), data);

	/*
	 * Fill in some fields of the bogus pci_dev.
	 */
	memset(&bogus_pcidev, 0, sizeof (struct pci_dev));
	strcpy(bogus_pcidev.name, "LITE5200 OHCI");
	strcpy(bogus_pcidev.slot_name, "builtin");
	bogus_pcidev.resource[0].name = "OHCI Operational Registers";
	bogus_pcidev.resource[0].start = MPC5xxx_USB_OHCI;
	bogus_pcidev.resource[0].end = MPC5xxx_USB_OHCI + 0x200;	/* REVISIT */
	bogus_pcidev.resource[0].flags = 0;
	bogus_pcidev.irq = MPC5xxx_USB_IRQ;

	/*
	 * Initialise the generic OHCI driver.
	 */
	ret = hc_add_ohci(&bogus_pcidev, bogus_pcidev.irq,
			  (void *) bogus_pcidev.resource[0].start, 0,
			  &lite5200_ohci, "usb-ohci", "lite5200");

	return ret;
}

static void
lite5200_ohci_release(void)
{
	hc_remove_ohci(lite5200_ohci);
}

static int __init
lite5200_ohci_init(void)
{
	int ret;

	lite5200_ohci_configure();
	return ret;
}

static void __exit
lite5200_ohci_exit(void)
{
	lite5200_ohci_release();
}

module_init(lite5200_ohci_init);
module_exit(lite5200_ohci_exit);

MODULE_LICENSE("GPL");
