/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright (C) 2002 Motorola Semiconductors HK Ltd
 * Copyright (c) 2003 MontaVista Software Inc. <source@mvista.com>
 *
 */

#ifndef INC_MX1
#define INC_MX1

typedef unsigned char U8;
typedef unsigned short U16;
typedef unsigned long U32;
typedef U8 *P_U8;
typedef U16 *P_U16;
typedef U32 *P_U32;

// Clock control module registers
#define CCM_BASE				IO_ADDRESS(PLL_BASE)
#define _reg_CCM_CSCR				(*((volatile U32 *)(CCM_BASE+0x00)))
#define _reg_CCM_MPCTL0				(*((volatile U32 *)(CCM_BASE+0x04)))

// USBD registers
#define USBD_BASE				IO_ADDRESS(MX1ADS_USBD_BASE)
#define _reg_USBD_STAT				(*((volatile U32 *)(USBD_BASE+0x008)))
#define _reg_USBD_CTRL				(*((volatile U32 *)(USBD_BASE+0x00C)))
#define _reg_USBD_CFGBSY			(*((volatile U32 *)(USBD_BASE+0x010)))
#define _reg_USBD_EPBUF				(*((volatile U32 *)(USBD_BASE+0x014)))
#define _reg_USBD_INTR_STAT		(*((volatile U32 *)(USBD_BASE+0x018)))
#define _reg_USBD_INTR_MASK		(*((volatile U32 *)(USBD_BASE+0x01C)))
#define _reg_USBD_ENABLE			(*((volatile U32 *)(USBD_BASE+0x024)))

#define MDEVREQ_MASK					0x00000008
#define EOT_MASK						0x00000004
#define DEVREQ_MASK					0x00000002
#define MDEVREQ_MASK					 0x00000008
#define EOF_MASK						0x00000001
#define WFR_MASK						0x20000000
#define CMD_OVER_MASK				0x00000040
#define CMD_ERROR_MASK				0x00000020
#define SOF_MASK						0x00000040
#define RST_STOP_MASK				0x00000020
#define RST_START_MASK				0x00000010
#define CFG_CHG_MASK					0x00000001
#define ZLPS_MASK						0x00000004
#define FORCE_STALL_MASK			0x00000001
#define FIFO_FULL_MASK			      0x100
#define FIFO_EMPTY_MASK			      0x080
#define FIFO_ERROR_MASK			      0x040
#define FIFO_HIGHT_MASK			      0x020
#define FLUSH_MASK			  0x00000002
#define FIFO_LOW_MASK		            0x010
// PLAM
#define USB_DIV_MASK				0x1C000000
// end PLAM

#endif

typedef struct {
	U32 STAT;
	U32 INTR_STAT;		//0x04
	U32 MASK;		//0x08
	U32 FDAT;		//0x0c
	U32 FSTAT;		//0x10
	U32 FCTRL;		//0x14
	U32 LRFP;		//0x18
	U32 LWFP;		//0x1c
	U32 FALRM;		//0x20
	U32 FRDP;		//0x24
	U32 FWRP;		//0x28

} EP_REGS;

typedef union {
	U32 FDAT_32;
	U8 FDAT_8[4];
} _FDAT;

typedef struct {
	U32 STAT;
	U32 INTR_STAT;		//0x04
	U32 INTR_MASK;		//0x08
	_FDAT FDAT;
	U32 FSTAT;		//0x10
	U32 FCTRL;		//0x14
	U32 LRFP;		//0x18
	U32 LWFP;		//0x1c
	U32 FALRM;		//0x20
	U32 FRDP;		//0x24
	U32 FWRP;		//0x28

} EP_REGS_CH;

#define EP0_OFFSET					       0x30
#define EP1_OFFSET					       0x60
#define EP2_OFFSET					       0x90
#define EP3_OFFSET					       0xC0
#define EP4_OFFSET					       0xF0
#define EP5_OFFSET					       0x120

#define FRAMEBITMASK                                0x0f000000
#define BYTECOUNTMASK                               0x007f0000

/* ep0 states */
#define WAIT_FOR_SETUP          0
#define DATA_STATE_XMIT         1
#define DATA_STATE_NEED_ZLP     2
#define WAIT_FOR_OUT_STATUS     3

#define EP0_PACKETSIZE  0x8

#define UDC_MAX_ENDPOINTS       6

#define UDC_NAME        "MX1 dragonball USBD"

#define STORAGE_BLOCK_SIZE	512

#define	TRUE							1
#define	FALSE							0
