/* **************************************************************************
 * linux/drivers/usb/device/bi/musbhsfc-opb.c --
 * Inventra Musbhsfc-opb USB bus interface driver.
 *
 * This was derived from the gen.c file.
 *
 * Copyright (c) 2000, 2001, 2002 Lineo
 *
 * By:
 *      Stuart Lynne <sl@lineo.com>,
 *      Tom Rushworth <tbr@lineo.com>,
 *      Bruce Balden <balden@lineo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *
 * (C) Copyright IBM Corp. 2004 Christophe Lombard <christophe_lombard@fr.ibm.com>
 *
 *
 * **************************************************************************/


/*
 * Basic stuff
 */
#define USBBI_UDC_NAME   "MUSBHSFC-OPB USBD"     /* Name of this UDC */
#define USBBI_UDC_IRQ                    55      /* (IBM4xx_IRQ_POL_LOW | IBM4xx_IRQ_SNS_EDG),  55: USB1.1 USB2.0 Device Interrupt */
#define USBBI_UDC_MAX_LOGICAL_ENDPOINTS   7      /* Number of logical endpoints on this UDC ( endpoint 0(tx/rx) + 3endpoint tx + 3endpoints rx )*/
#define USBBI_UDC_MAX_PHYSICAL_ENDPOINTS  4      /* Number of physical endpoints on this UDC ( endpoint 0 + 3endpoints )*/

/* Basic stuff for DMA (only for USB 2.0 Device */
#define USBBI_UDC_DMA_NAME                   "DMA2P40"     /* Name of this DMA to PLB4 */
#define USBBI_UDC_DMA_ENDPOINT1_IN_IRQ       48      /* (IBM4xx_IRQ_POL_HGH | IBM4xx_IRQ_SNS_EDG),  48: UDMA Interrupt 0 (Enpoint1 IN)  */
#define USBBI_UDC_DMA_ENDPOINT2_IN_IRQ       49      /* (IBM4xx_IRQ_POL_HGH | IBM4xx_IRQ_SNS_EDG),  48: UDMA Interrupt 0 (Enpoint2 IN)  */
#define USBBI_UDC_DMA_ENDPOINT1_OUT_IRQ      53      /* (IBM4xx_IRQ_POL_HGH | IBM4xx_IRQ_SNS_EDG),  48: UDMA Interrupt 0 (Enpoint1 OUT) */
#define USBBI_UDC_DMA_ENDPOINT2_OUT_IRQ      54      /* (IBM4xx_IRQ_POL_HGH | IBM4xx_IRQ_SNS_EDG),  48: UDMA Interrupt 0 (Enpoint2 OUT) */


/*
 * IBMUSB20DEVICE registers Register Map
 */

#define USBBI_COMMON_REGISTERS  0x0000000050000100      /* USB2.0 Device Common Registers (PLB Address)*/
#define USBBI_PCIL0_SIZE        0x7F                    /* Size of USB2.0 Device Common Registers */

/* USB Function Module Registers (endpoint) */
#define USBBI_INTRIN_ADDR       0x00    /* Interrupt register for Ep0 plus IN Ep 1 to 15 (16 bits reg) */
#define USBBI_POWER_ADDR        0x02    /* Power Management Register */
#define USBBI_FADDR_ADDR        0x03    /* Function Address Register */
#define USBBI_INTRINE_ADDR      0x04    /* Interrupt enable register for IntrIn */
#define USBBI_INTROUT_ADDR      0x06    /* Interrupt register for OUT Ep 1 to 15  (16 bits reg) */
#define USBBI_INTRUSBE_ADDR     0x08    /* Interrupt enable register for IntrUSB */
#define USBBI_INTRUSB_ADDR      0x09    /* Interrupt Register for common USB interrupts */
#define USBBI_INTROUTE_ADDR     0x0A    /* Interrupt enable register for IntrOut */
#define USBBI_TESTMODE_ADDR     0x0C    /* Enables the USB 2.0 test modes */
#define USBBI_INDEX_ADDR        0x0D    /* Index register for selecting the endpoint status/control registers */
#define USBBI_FRAME_ADDR        0x0E    /* Frame number */
#define USBBI_CSR0_ADDR         0x11    /* Control Status register for Endpoint 0. (Index register set to select Endpoint 0) */
#define USBBI_INCSRH_ADDR       0x10    /* Control Status register for IN endpoint. (Index register set to select Endpoints 1-15) */
#define USBBI_INCSR_ADDR        0x11    /* Control Status register for IN endpoint. (Index register set to select Endpoints 1-15)  */
#define USBBI_INMAXP_ADDR       0x12    /* Maximum packet size for IN endpoint. (Index register set to select Endpoints 1-15 only) */
#define USBBI_OUTCSRH_ADDR      0x14    /* Control Status register for OUT endpoint (Index register set to select Endpoints 1-15 only) */
#define USBBI_OUTCSR_ADDR       0x15    /* Control Status register for OUT endpoint (Index register set to select Endpoints 1-15 only) */
#define USBBI_OUTMAXP_ADDR      0x16    /* Maximum packet size for OUT endpoint. (Index register set to select Endpoints 1-15 only) */
#define USBBI_OUTCOUNT_ADDR     0x1A    /* Number of received bytes in Endpoint 0 FIFO. (Index register set to select Endpoint 0)
                                           Number of bytes in OUT endpoint FIFO. (Index register set to select Endpoints 1-15) */
#define USBBI_FIFO_EP0_ADDR     0x20    /* FIFOs for Endpoints 0 next FIFO is at + 4bytes */


/* Interrupt IN register bit masks */
#define USBBI_INTRIN_EP0                0x01

/* Power register bit masks */
#define USBBI_POWER_ISO_UPDATE          0x80
#define USBBI_POWER_FS_PHY_ENAB         0x40
#define USBBI_POWER_HS_ENAB             0x20
#define USBBI_POWER_HS_MODE             0x10
#define USBBI_POWER_RESET               0x08
#define USBBI_POWER_RESUME              0x04
#define USBBI_POWER_SUSPEND_MODE        0x02
#define USBBI_POWER_ENABLE_SUSPEND      0x01

/* FADDR bits definitions */
#define USBBI_FADDR_ADDR_MASK           0x7f  /* address */
#define USBBI_FADDR_UPDATE              0x80  /* update */

/* Interrupt USB register bit masks */
#define USBBI_INTRUSB_SOF               0x08
#define USBBI_INTRUSB_RESET             0x04
#define USBBI_INTRUSB_RESUME            0x02
#define USBBI_INTRUSB_SUSPEND           0x01

/* Interrupt USB Enable register bit masks */
#define USBBI_INTRUSBE_SOF              0x08
#define USBBI_INTRUSBE_RESET            0x04
#define USBBI_INTRUSBE_RESUME           0x02
#define USBBI_INTRUSBE_SUSPEND          0x01

/* Testmode register bits */
#define USBBI_TEST_SE0NAK               0x01
#define USBBI_TEST_J                    0x02
#define USBBI_TEST_K                    0x04
#define USBBI_TEST_PACKET               0x08

/* CSR0 bit masks */
#define USBBI_CSR0_SVDSETUPEND          0x80
#define USBBI_CSR0_SVDOUTPKTRDY         0x40
#define USBBI_CSR0_SENDSTALL            0x20
#define USBBI_CSR0_SETUPEND             0x10
#define USBBI_CSR0_DATAEND              0x08
#define USBBI_CSR0_SENTSTALL            0x04
#define USBBI_CSR0_INPKTRDY             0x02
#define USBBI_CSR0_OUTPKTRDY            0x01

/* Endpoint CSR register bits */
/* IN CSR */
#define USBBI_INCSRH_AUTOSET            0x80
#define USBBI_INCSRH_ISO                0x40
#define USBBI_INCSRH_MODE               0x20
#define USBBI_INCSRH_DMAENA             0x10
#define USBBI_INCSRH_FRCDATATOG         0x08
#define USBBI_INCSR_INCOMPTX            0x80
#define USBBI_INCSR_CLRDATATOG          0x40
#define USBBI_INCSR_SENTSTALL           0x20
#define USBBI_INCSR_SENDSTALL           0x10
#define USBBI_INCSR_FLUSHFIFO           0x08
#define USBBI_INCSR_UNDERRUN            0x04
#define USBBI_INCSR_FIFONEMPTY          0x02
#define USBBI_INCSR_INPKTRDY            0x01
/* OUT CSR */
#define USBBI_OUTCSRH_AUTOCLR           0x80
#define USBBI_OUTCSRH_ISO               0x40
#define USBBI_OUTCSRH_DMAENA            0x20
#define USBBI_OUTCSRH_DISNYET           0x10
#define USBBI_OUTCSRH_DMAMODE           0x08
#define USBBI_OUTCSRH_INCOMPRX          0x01
#define USBBI_OUTCSR_CLRDATATOG         0x80
#define USBBI_OUTCSR_SENTSTALL          0x40
#define USBBI_OUTCSR_SENDSTALL          0x20
#define USBBI_OUTCSR_FLUSHFIFO          0x10
#define USBBI_OUTCSR_DATA_ERROR         0x08
#define USBBI_OUTCSR_OVERRUN            0x04
#define USBBI_OUTCSR_FIFOFULL           0x02
#define USBBI_OUTCSR_OUTPKTRDY          0x01

/* Default Configuration mode */
#define USBBI_EP_CONF_NOT_USED          0xFF
#define USBBI_EP_CONF_IN_DEFAULT        USBBI_INCSRH_FRCDATATOG  /* DMA off */
#define USBBI_EP_CONF_OUT_DEFAULT       0x00                     /* DMA off */

/* Endpoint Attributes */
#define USBBI_EP_ATTRIB_IN              0
#define USBBI_EP_ATTRIB_OUT             1
#define USBBI_EP_ATTRIB_CONTROL         2

/* max endpoint packet
 * for ep0 or other endpoints.
 */
#define USBBI_MAX_PKT_CONTROL           64
#define USBBI_MAX_PKT_ENDPOINT          1024

/* Buffer size */
#define USBBI_MAX_BUFFER_SIZE           4096


