/*
* <LIC_AMD_STD>
* Copyright (c) 2004 Advanced Micro Devices, Inc.
* 
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
* 
* The full GNU General Public License is included in this distribution in the
* file called COPYING
* </LIC_AMD_STD>
* <CTL_AMD_STD>
* </CTL_AMD_STD>
* <DOC_AMD_STD>
* </DOC_AMD_STD>
*/

#include "duraudio.h"
#include "os_inc.h"
#include "build_num.h"

#define DRIVER_VERSION "2.0." GEODEOSS_BUILD_NUM

#define PCI_VENDOR_CYRIX                0x1078
#define PCI_VENDOR_NSC                  0x100B
#define PCI_DEVICE_ID_NSC_GX1           0x0103	/* GX1 */
#define PCI_DEVICE_ID_NSC_SCXX00        0x0503	/* SCXX00 */
#define PCI_DEVICE_ID_NSC_GX2           0x002E	/* GX2 */

#define NSC_CHAN_HARD       0x100

#define NSC_FMT_STEREO      0x01
#define NSC_FMT_16BIT       0x02
#define NSC_FMT_MASK        0x03
#define NSC_DAC_SHIFT       0
#define NSC_ADC_SHIFT       4

#define DAC_RUNNING         1
#define ADC_RUNNING         2

#define MAX_DSP_ORDER       2
#define MAX_DSPS            (1<<MAX_DSP_ORDER)
#define NR_IDRS             32

#define NR_APUS             64
#define NR_APU_REGS         16

#define  BM0_IRQ            0x04
#define  BM1_IRQ            0x08

typedef struct {
	struct list_head head;
	unsigned long size;
	unsigned char c;
} buff_list_t;

#define TRUE  1
#define FALSE 0

/* a structure to store all information we need
   forthe DMA thread */
typedef struct dma_thread_struct {
	struct task_struct *thread;
	struct tq_struct tq;
	void (*function) (struct dma_thread_struct * dma_thread);
	struct semaphore startstop_sem;
	struct amd_state *pAmdState;
	int terminate;
	int bRunning;
	void *arg;
	struct completion thr_exited;
	pid_t thr_pid;
} dma_thread_t;

/* define the meaning for the zero_flags field*/
#define ZF_TRANSFER_PENDING    1
#define ZF_TRANSFER_SINCE_ZERO 2
#define ZF_PARTIAL_ZERO        3
#define ZF_ZERO_SKIPPED        4

/*The threshhold for zeroing the buffer is a the interrupt interval + 1ms*/
/*Worst case 1ms is 48KHz 16 bit stereo i.e. 48 samples of 4 bytes each*/
#define Z_1MS_OF_BYTES ( 48 * 4 )

#define START_DAC_DEFAULT   0x0
#define START_DAC_START_ANY 0x1

#define WRITEABLE_MAP   0xEFFFFF
#define READABLE_MAP    0x64003F

/*OSS interface to the ac97s.. */
#define AC97_STEREO_MASK (SOUND_MASK_VOLUME|\
    SOUND_MASK_PCM|SOUND_MASK_LINE|SOUND_MASK_CD|\
    SOUND_MASK_VIDEO|SOUND_MASK_LINE1|SOUND_MASK_IGAIN)

#define AC97_SUPPORTED_MASK (AC97_STEREO_MASK | \
    SOUND_MASK_BASS|SOUND_MASK_TREBLE|SOUND_MASK_MIC|\
    SOUND_MASK_SPEAKER)

#define AC97_RECORD_MASK (SOUND_MASK_MIC|\
    SOUND_MASK_CD| SOUND_MASK_VIDEO| SOUND_MASK_LINE1| SOUND_MASK_LINE|\
    SOUND_MASK_PHONEIN)

#define supported_mixer(CARD,VAL) ( CARD->mix.supported_mixers & (1<<VAL) )

/*this table has default mixer values for all OSS mixers.*/
/*be sure to fill it in if you add oss mixers            */
/*to anyone's supported mixer defines                    */

#define PACKED_U8(HI,LO) ( ( (HI & 0xFF) << 8 ) | ( LO & 0xFF ) )
#define VOL_DEFAULT PACKED_U8(50,50)
