/* $Id: xgemac_l.h,v 1.1.4.1 2004/07/12 11:29:20 kurtsman Exp $ */
/******************************************************************************
*
*       XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS"
*       AS A COURTESY TO YOU, SOLELY FOR USE IN DEVELOPING PROGRAMS AND
*       SOLUTIONS FOR XILINX DEVICES.  BY PROVIDING THIS DESIGN, CODE,
*       OR INFORMATION AS ONE POSSIBLE IMPLEMENTATION OF THIS FEATURE,
*       APPLICATION OR STANDARD, XILINX IS MAKING NO REPRESENTATION
*       THAT THIS IMPLEMENTATION IS FREE FROM ANY CLAIMS OF INFRINGEMENT,
*       AND YOU ARE RESPONSIBLE FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE
*       FOR YOUR IMPLEMENTATION.  XILINX EXPRESSLY DISCLAIMS ANY
*       WARRANTY WHATSOEVER WITH RESPECT TO THE ADEQUACY OF THE
*       IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR
*       REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE FROM CLAIMS OF
*       INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*       FOR A PARTICULAR PURPOSE.
*
*       (c) Copyright 2002 Xilinx Inc.
*       All rights reserved.
*
******************************************************************************/
/*****************************************************************************/
/**
*
* @file xgemac_l.h
*
* This header file contains identifiers and low-level driver functions (or
* macros) that can be used to access the device.  High-level driver functions
* are defined in xgemac.h.
*
* <pre>
* MODIFICATION HISTORY:
*
* Who  Date     Changes
* ---- -------- -----------------------------------------------
* ecm  01/13/03 First release
* ecm  03/25/03 Revision update
* rmm  05/28/03 Removed tabs characters in file, added auto negotiate
*               bit to ECR constants.
* rmm  09/15/03 Moved XGE_MAX_IFG definition here from xgemac_options.c
*               and changed its value to 255. Added XMIT jumbo frame
*               bitmask to ECR register bitmasks. Removed unused and added
*               new XGE_EIR bitmasks. Removed XGE_TEDC_OFFSET and XGE_
*               SLEC_OFFSET register definitions. Added XGE_RSR_OFFSET
*               register definition.
* </pre>
*
******************************************************************************/

#ifndef XGEMAC_L_H	/* prevent circular inclusions */
#define XGEMAC_L_H	/* by using protection macros */

/***************************** Include Files *********************************/

#include "xbasic_types.h"
#include "xio.h"

/************************** Constant Definitions *****************************/

/* Offset of the core registers from the IPIF base address */
#define XGE_REG_OFFSET		0x1000UL

/** @name GEMAC Core Register Offsets
 * Each register is 32 bits wide
 * @{
 */

#define XGE_EMIR_OFFSET			(XGE_REG_OFFSET + 0x0)		/**< GEMAC Module ID */
#define XGE_ECR_OFFSET			(XGE_REG_OFFSET + 0x4)		/**< MAC Control */
#define XGE_IFGP_OFFSET			(XGE_REG_OFFSET + 0x8)		/**< Interframe Gap */
#define XGE_SAH_OFFSET			(XGE_REG_OFFSET + 0xC)		/**< Station addr, high */
#define XGE_SAL_OFFSET			(XGE_REG_OFFSET + 0x10)		/**< Station addr, low */
#define XGE_MGTCR_OFFSET		(XGE_REG_OFFSET + 0x14)		/**< MII mgmt control */
#define XGE_MGTDR_OFFSET		(XGE_REG_OFFSET + 0x18)		/**< MII mgmt data */
#define XGE_RPLR_OFFSET			(XGE_REG_OFFSET + 0x1C)		/**< Rx packet length */
#define XGE_TPLR_OFFSET			(XGE_REG_OFFSET + 0x20)		/**< Tx packet length */
#define XGE_TSR_OFFSET			(XGE_REG_OFFSET + 0x24)		/**< Tx status */
#define XGE_TPPR_OFFSET			(XGE_REG_OFFSET + 0x28)		/**< Tx Pause Pkt */
#define XGE_CEAH_OFFSET			(XGE_REG_OFFSET + 0x2C)		/**< CAM Entry Address High */
#define XGE_CEAL_OFFSET			(XGE_REG_OFFSET + 0x30)		/**< CAM Entry Address Low */
#define XGE_RSR_OFFSET			(XGE_REG_OFFSET + 0x34)		/**< Receive status */
/*@}*/

/** @name GEMAC IPIF Register Offsets
 * Each register is 32 bits wide
 * @{
 */
#define XGE_ISR_OFFSET			0x20UL				/**< Interrupt status */

#define XGE_DMA_OFFSET			0x2300UL			/**< DMA base offset */
#define XGE_DMA_SEND_OFFSET		(XGE_DMA_OFFSET + 0x0)		/**< DMA send channel */
#define XGE_DMA_RECV_OFFSET		(XGE_DMA_OFFSET + 0x40)		/**< DMA recv channel */

#define XGE_PFIFO_OFFSET		0x2000UL			/**< FIFO base offset */
#define XGE_PFIFO_TXREG_OFFSET		(XGE_PFIFO_OFFSET + 0x0)	/**< Tx registers */
#define XGE_PFIFO_RXREG_OFFSET		(XGE_PFIFO_OFFSET + 0x10)	/**< Rx registers */
#define XGE_PFIFO_TXDATA_OFFSET		(XGE_PFIFO_OFFSET + 0x100)	/**< Tx keyhole */
#define XGE_PFIFO_RXDATA_OFFSET		(XGE_PFIFO_OFFSET + 0x200)		/**< Rx keyhole */
/*@}*/


/** @name GEMAC Counter Register Offsets
 * Each register is 64 bits wide
 * @{
 */

/** Offset of the MAC Statistics registers from the IPIF base address */
#define XGE_STAT_REG_OFFSET		0x1100UL

/** Frames RX'd ok */
#define XGE_STAT_RXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x00)

/** RX FCS error */
#define XGE_STAT_FCSERR_OFFSET		(XGE_STAT_REG_OFFSET + 0x08)

/** Broadcast Frames RX'd ok */
#define XGE_STAT_BFRXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x10) 
 
/** Multicast Frames RX'd ok */
#define XGE_STAT_MCRXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x18)

/** 64 byte frames RX'd ok */
#define XGE_STAT_64RXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x20)

/** 65-127 byte frames RX'd ok */
#define XGE_STAT_127RXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x28)

/** 128-255 byte frames RX'd ok */
#define XGE_STAT_255RXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x30)

/** 256-511 byte frames RX'd ok */
#define XGE_STAT_511RXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x38)

/** 512-1023 byte frames RX'd ok */
#define XGE_STAT_1023RXOK_OFFSET	(XGE_STAT_REG_OFFSET + 0x40)

/** 1024-max byte frames RX'd ok */
#define XGE_STAT_MAXRXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x48)

/** Control Frames RX'd ok */
#define XGE_STAT_CFRXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x50)

/** length/type out of range */
#define XGE_STAT_LTERROR_OFFSET		(XGE_STAT_REG_OFFSET + 0x58)

/** VLAN Frames RX'd ok */
#define XGE_STAT_VLANRXOK_OFFSET	(XGE_STAT_REG_OFFSET + 0x60)

/** Pause Frames RX'd ok */
#define XGE_STAT_PFRXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x68)

/** Control Frames with unsupported opcode RX's */
#define XGE_STAT_CFUNSUP_OFFSET		(XGE_STAT_REG_OFFSET + 0x70)

/** Oversize Frames RX'd ok */
#define XGE_STAT_OFRXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x78)

/** Undersize Frames RX'd */
#define XGE_STAT_UFRX_OFFSET		(XGE_STAT_REG_OFFSET + 0x80)

/** Fragment Frames RX'd */
#define XGE_STAT_FRAGRX_OFFSET		(XGE_STAT_REG_OFFSET + 0x88)

/** RX Byte Count */
#define XGE_STAT_RXBYTES_OFFSET		(XGE_STAT_REG_OFFSET + 0x90)

/** TX Byte Count */
#define XGE_STAT_TXBYTES_OFFSET		(XGE_STAT_REG_OFFSET + 0x98)

/** Frames TX'd ok */
#define XGE_STAT_TXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xA0)

/** Broadcast Frames TX'd ok */
#define XGE_STAT_BFTXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xA8)

/** Multicast Frames TX'd ok */
#define XGE_STAT_MFTXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xB0)

/** TX Underrun error */
#define XGE_STAT_TXURUNERR_OFFSET	(XGE_STAT_REG_OFFSET + 0xB8)

/** Control Frames TX'd ok */
#define XGE_STAT_CFTXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xC0)

/** 64 byte frames TX'd ok*/
#define XGE_STAT_64TXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xC8)

/** 65-127 byte frames TX'd ok*/
#define XGE_STAT_127TXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xD0)

/** 128-255 byte frames TX'd ok*/
#define XGE_STAT_255TXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xD8)

/** 256-511 byte frames TX'd ok*/
#define XGE_STAT_511TXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xE0)

/** 512-1023 byte frames TX'd ok */
#define XGE_STAT_1023TXOK_OFFSET	(XGE_STAT_REG_OFFSET + 0xE8)

/** 1024-Max byte frames TX'd ok */
#define XGE_STAT_MAXTXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0xF0)

/** VLAN Frames TX'd ok */
#define XGE_STAT_VLANTXOK_OFFSET	(XGE_STAT_REG_OFFSET + 0xF8)

/** Pause Frames TX'd ok */
#define XGE_STAT_PFTXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x100)

/** Oversize Frames TX'd ok */
#define XGE_STAT_OFTXOK_OFFSET		(XGE_STAT_REG_OFFSET + 0x108)

/** Single Collision Frames */
#define XGE_STAT_SCOLL_OFFSET		(XGE_STAT_REG_OFFSET + 0x110)

/** Multiple Collision Frames */
#define XGE_STAT_MCOLL_OFFSET		(XGE_STAT_REG_OFFSET + 0x118)

/** Deferred Frames */
#define XGE_STAT_DEFERRED_OFFSET	(XGE_STAT_REG_OFFSET + 0x120)

/** Late Collision Frames */
#define XGE_STAT_LATECOLL_OFFSET	(XGE_STAT_REG_OFFSET + 0x128)

/** Frames aborted due to excess collisions */
#define XGE_STAT_TXABORTED_OFFSET	(XGE_STAT_REG_OFFSET + 0x130)

/** Carrier sense errors */
#define XGE_STAT_CARRIERERR_OFFSET	(XGE_STAT_REG_OFFSET + 0x138)

/** Excess Deferral error */
#define XGE_STAT_EXCESSDEF_OFFSET	(XGE_STAT_REG_OFFSET + 0x140)
/*@}*/


/*
 * Module ID Register (EMIR)
 */
#define XGE_EMIR_VERSION_MASK		0xFFFF0000UL			/* Device version */
#define XGE_EMIR_TYPE_MASK		0x0000FF00UL			/* Device type */

/*
 * Control Register (CR)
 */
#define XGE_ECR_FULL_DUPLEX_MASK	0x80000000UL			/* Full duplex mode */
#define XGE_ECR_XMIT_RESET_MASK		0x40000000UL			/* Reset transmitter */
#define XGE_ECR_XMIT_ENABLE_MASK	0x20000000UL			/* Enable transmitter */
#define XGE_ECR_RECV_RESET_MASK		0x10000000UL			/* Reset receiver */
#define XGE_ECR_RECV_ENABLE_MASK	0x08000000UL			/* Enable receiver */
#define XGE_ECR_PHY_ENABLE_MASK		0x04000000UL			/* Enable PHY */
#define XGE_ECR_XMIT_PAD_ENABLE_MASK	0x02000000UL			/* Enable xmit pad insert */
#define XGE_ECR_XMIT_FCS_ENABLE_MASK	0x01000000UL			/* Enable xmit FCS insert */
#define XGE_ECR_XMIT_ADDR_INSERT_MASK	0x00800000UL			/* Enable xmit source addr
										insertion */
#define XGE_ECR_XMIT_ERROR_INSERT_MASK	0x00400000UL			/* Insert xmit error */
#define XGE_ECR_XMIT_ADDR_OVWRT_MASK	0x00200000UL			/* Enable xmit source addr
										overwrite */
#define XGE_ECR_LOOPBACK_MASK		0x00100000UL			/* Enable internal loopback */
#define XGE_ECR_RECV_STRIP_ENABLE_MASK	0x00080000UL			/* Enable recv pad/fcs strip */
#define XGE_ECR_XMIT_JUMBO_ENABLE_MASK	0x00040000UL			/* Enable Tx of Jumbo Frames */
#define XGE_ECR_UNICAST_ENABLE_MASK	0x00020000UL			/* Enable unicast addr */
#define XGE_ECR_MULTI_ENABLE_MASK	0x00010000UL			/* Enable multicast addr */
#define XGE_ECR_BROAD_ENABLE_MASK	0x00008000UL			/* Enable broadcast addr */
#define XGE_ECR_PROMISC_ENABLE_MASK	0x00004000UL			/* Enable promiscuous mode */

#define XGE_ECR_REO_ENABLE_MASK		0x00002000UL			/* Enable Receive Error
										Override */
#define XGE_ECR_RECV_JUMBO_ENABLE_MASK	0x00001000UL			/* Enable RX of Jumbo Frames */
#define XGE_ECR_XMIT_PAUSE_ENABLE_MASK	0x00000800UL			/* Enable TX of Pause Pkts */
#define XGE_ECR_RECV_PAUSE_ENABLE_MASK	0x00000400UL			/* Enable RX of Pause Pkts */
#define XGE_ECR_XMIT_VLAN_ENABLE_MASK	0x00000200UL			/* Enable TX of VLAN Pkts */
#define XGE_ECR_RECV_VLAN_ENABLE_MASK	0x00000100UL			/* Enable RX of VLAN Pkts */
#define XGE_ECR_AUTONEG_ENABLE_MASK	0x00000080UL			/* Enable PCS/PMA autonegotiate */

#define XGE_ECR_ADD_HASH_ADDR_MASK	0x00000FFFUL			/* TBD */
#define XGE_ECR_CLEAR_HASH_MASK		0x00000000UL			/* TBD */

/*
 * Interframe Gap Register (IFGR)
 */
#define XGE_IFGP_MASK			0xFF000000UL			/* Interframe Gap Mask */
#define XGE_IFGP_SHIFT			24				/* Shift value */
#define XGE_MAX_IFG			255				/* Max IFG value */

/*
 * Station Address High Register (SAH)
 */
#define XGE_SAH_ADDR_MASK		0x0000FFFFUL			/* Station address high bytes */

/*
 * Station Address Low Register (SAL)
 */
#define XGE_SAL_ADDR_MASK		0xFFFFFFFFUL			/* Station address low bytes */

/*
 * MII Management Control Register (MGTCR)
 */
#define XGE_MGTCR_START_MASK		0x80000000UL			/* Start/Busy */
#define XGE_MGTCR_RW_NOT_MASK		0x40000000UL			/* Read from PHY */
#define XGE_MGTCR_WRITE_MASK		0x00000000UL			/* Write to PHY */
#define XGE_MGTCR_PHY_ADDR_MASK		0x3E000000UL			/* PHY address */
#define XGE_MGTCR_PHY_ADDR_SHIFT	25				/* PHY address shift left bits */
#define XGE_MGTCR_REG_ADDR_MASK		0x01F00000UL			/* Register address */
#define XGE_MGTCR_REG_ADDR_SHIFT	20				/* Register addr shift left bits */
#define XGE_MGTCR_MII_ENABLE_MASK	0x00080000UL			/* Enable MII from GEMAC */
#define XGE_MGTCR_RD_ERROR_MASK		0x00040000UL			/* MII mgmt read error */

/*
 * MII Management Data Register (MGTDR)
 */
#define XGE_MGTDR_DATA_MASK		0x0000FFFFUL			/* MII data */

/*
 * Receive Packet Length Register (RPLR)
 */
#define XGE_RPLR_LENGTH_MASK		0x0000FFFFUL			/* Receive packet length */

/*
 * Transmit Packet Length Register (TPLR)
 */
#define XGE_TPLR_LENGTH_MASK		0x0000FFFFUL			/* Transmit packet length */

/*
 * Transmit Status Register (TSR)
 */
#define XGE_TSR_EXCESS_DEFERRAL_MASK	0x80000000UL			/* Transmit excess deferral */
#define XGE_TSR_FIFO_UNDERRUN_MASK	0x40000000UL			/* Packet FIFO underrun */
#define XGE_TSR_ATTEMPTS_MASK		0x3E000000UL			/* Transmission attempts */
#define XGE_TSR_LATE_COLLISION_MASK	0x01000000UL			/* Transmit late collision */

/*
 * Transmit Pause Packet Register (TPPR)
 */
#define XGE_TPPR_DATA_MASK		0x0000FFFFUL

/*
 * CAM Entry Address High Register (CEAH)
 */
#define XGE_CEAH_CLOC_MASK		0x000F0000UL
#define XGE_CEAH_CLOC_SHIFT_LEFT	16
#define XGE_CEAH_DATA_MASK		0x0000FFFFUL
#define XGE_CAM_MAX_ADDRESSES		16

/*
 * Transmit Excess Deferral Count (TEDC)
 */
#define XGE_TEDC_DATA_MASK		0x0000FFFFUL

/*
 * GEMAC Interrupt Registers (Status and Enable) masks. These registers are
 * part of the IPIF IP Interrupt registers
 */
#define XGE_EIR_XMIT_DONE_MASK		0x00000001UL			/* Xmit complete */
#define XGE_EIR_RECV_DONE_MASK		0x00000002UL			/* Recv complete */
#define XGE_EIR_RECV_ERROR_MASK		0x00000008UL			/* Recv error */
#define XGE_EIR_XMIT_SFIFO_EMPTY_MASK	0x00000010UL			/* Xmit status fifo empty */
#define XGE_EIR_RECV_LFIFO_EMPTY_MASK	0x00000020UL			/* Recv length fifo empty */
#define XGE_EIR_XMIT_LFIFO_FULL_MASK	0x00000040UL			/* Xmit length fifo full */
#define XGE_EIR_RECV_LFIFO_OVER_MASK	0x00000080UL			/* Recv length fifo
									 * overrun */
#define XGE_EIR_RECV_LFIFO_UNDER_MASK	0x00000100UL			/* Recv length fifo
									 * underrun */
#define XGE_EIR_XMIT_SFIFO_OVER_MASK	0x00000200UL			/* Xmit status fifo
									 * overrun */
#define XGE_EIR_XMIT_SFIFO_UNDER_MASK	0x00000400UL			/* Transmit status fifo
									 * underrun */
#define XGE_EIR_XMIT_LFIFO_OVER_MASK	0x00000800UL			/* Transmit length fifo
									 * overrun */
#define XGE_EIR_XMIT_LFIFO_UNDER_MASK	0x00001000UL			/* Transmit length fifo
									 * underrun */
#define XGE_EIR_RECV_LONG_ERROR_MASK	0x00020000UL			/* Max recv length
									 * exceeded */
#define XGE_EIR_RECV_LEN_ERROR_MASK	0x00040000UL			/* Recv length field
									 * error */
#define XGE_EIR_RECV_FCS_ERROR_MASK	0x00080000UL			/* Recv FCS error */

#define XGE_EIR_RECV_SLOT_LENGTH_ERROR_MASK 0x00100000UL		/* Recv slot length
									 * error */
#define XGE_EIR_RECV_CRC_ENGINE_ERROR_MASK 0x00200000UL			/* Recv CRC engine
									 * error */

/**************************** Type Definitions *******************************/

/***************** Macros (Inline Functions) Definitions *********************/

/*****************************************************************************
*
* Low-level driver macros and functions. The list below provides signatures
* to help the user use the macros.
*
* u32 XGemac_mReadReg(u32 BaseAddress, int RegOffset)
* void XGemac_mWriteReg(u32 BaseAddress, int RegOffset, u32 Mask)
*
* void XGemac_mSetControlReg(u32 BaseAddress, u32 Mask)
* void XGemac_mSetMacAddress(u32 BaseAddress, u8 *AddressPtr)
*
* void XGemac_mEnable(u32 BaseAddress)
* void XGemac_mDisable(u32 BaseAddress)
*
* u32 XGemac_mIsTxDone(u32 BaseAddress)
* u32 XGemac_mIsRxEmpty(u32 BaseAddress)
*
* void XGemac_SendFrame(u32 BaseAddress, u8 *FramePtr, int Size)
* int XGemac_RecvFrame(u32 BaseAddress, u8 *FramePtr)
*
*****************************************************************************/

/** @name Macro functions
 * @{
 */

/****************************************************************************/
/**
*
* Read the given register.
*
* @param    BaseAddress is the base address of the device
* @param    RegOffset is the register offset to be read
*
* @return   The 32-bit value of the register
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mReadReg(BaseAddress, RegOffset) \
                    XIo_In32((BaseAddress) + (RegOffset))

/****************************************************************************/
/**
*
* Write the given register.
*
* @param    BaseAddress is the base address of the device
* @param    RegOffset is the register offset to be written
* @param    Data is the 32-bit value to write to the register
*
* @return   None.
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mWriteReg(BaseAddress, RegOffset, Data) \
                    XIo_Out32((BaseAddress) + (RegOffset), (Data))

/****************************************************************************/
/**
*
* Set the contents of the control register. Use the XGE_ECR_* constants
* defined above to create the bit-mask to be written to the register.
*
* @param    BaseAddress is the base address of the device
* @param    Mask is the 16-bit value to write to the control register
*
* @return   None.
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mSetControlReg(BaseAddress, Mask) \
                    XIo_Out32((BaseAddress) + XGE_ECR_OFFSET, (Mask))

/****************************************************************************/
/**
*
* Set the station address of the GEMAC device.
*
* @param    BaseAddress is the base address of the device
* @param    AddressPtr is a pointer to a 6-byte MAC address
*
* @return   None.
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mSetMacAddress(BaseAddress, AddressPtr)               \
{                                                                   \
    u32 MacAddr;                                                \
                                                                    \
    MacAddr = ((AddressPtr)[0] << 8) | (AddressPtr)[1];             \
    XIo_Out32((BaseAddress) + XGE_SAH_OFFSET, MacAddr);             \
                                                                    \
    MacAddr = ((AddressPtr)[2] << 24) | ((AddressPtr)[3] << 16) |   \
              ((AddressPtr)[4] << 8) | (AddressPtr)[5];             \
                                                                    \
    XIo_Out32((BaseAddress) + XGE_SAL_OFFSET, MacAddr);             \
}

/****************************************************************************/
/**
*
* Enable the transmitter and receiver. Preserve the contents of the control
* register.
*
* @param    BaseAddress is the base address of the device
*
* @return   None.
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mEnable(BaseAddress) \
{ \
    u32 Control; \
    Control = XIo_In32((BaseAddress) + XGE_ECR_OFFSET); \
    Control &= ~(XGE_ECR_XMIT_RESET_MASK | XGE_ECR_RECV_RESET_MASK); \
    Control |= (XGE_ECR_XMIT_ENABLE_MASK | XGE_ECR_RECV_ENABLE_MASK); \
    XIo_Out32((BaseAddress) + XGE_ECR_OFFSET, Control); \
}

/****************************************************************************/
/**
*
* Disable the transmitter and receiver. Preserve the contents of the control
* register.
*
* @param    BaseAddress is the base address of the device
*
* @return   None.
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mDisable(BaseAddress) \
                XIo_Out32((BaseAddress) + XGE_ECR_OFFSET, \
                    XIo_In32((BaseAddress) + XGE_ECR_OFFSET) & \
                    ~(XGE_ECR_XMIT_ENABLE_MASK | XGE_ECR_RECV_ENABLE_MASK))

/****************************************************************************/
/**
*
* Check to see if the transmission is complete.
*
* @param    BaseAddress is the base address of the device
*
* @return   TRUE if it is done, or FALSE if it is not.
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mIsTxDone(BaseAddress) \
             (XIo_In32((BaseAddress) + XGE_ISR_OFFSET) & XGE_EIR_XMIT_DONE_MASK)

/****************************************************************************/
/**
*
* Check to see if the receive FIFO is empty.
*
* @param    BaseAddress is the base address of the device
*
* @return   TRUE if it is empty, or FALSE if it is not.
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mIsRxEmpty(BaseAddress) \
          (!(XIo_In32((BaseAddress) + XGE_ISR_OFFSET) & XGE_EIR_RECV_DONE_MASK))

/****************************************************************************/
/**
*
* Reset MII compliant PHY
*
* @param    BaseAddress is the base address of the device
*
* @return   None.
*
* @note     None.
*
*****************************************************************************/
#define XGemac_mPhyReset(BaseAddress) \
{ \
    u32 Control;                                    \
    Control = XIo_In32((BaseAddress) + XGE_ECR_OFFSET); \
    Control &= ~XGE_ECR_PHY_ENABLE_MASK;                \
    XIo_Out32((BaseAddress) + XGE_ECR_OFFSET, Control); \
    Control |= XGE_ECR_PHY_ENABLE_MASK;                 \
    XIo_Out32((BaseAddress) + XGE_ECR_OFFSET, Control); \
}
/*@}*/

/************************** Function Prototypes ******************************/


#endif				/* end of protection macro */
