/* $Id: xgemac_i.h,v 1.1.4.1 2004/07/12 11:29:20 kurtsman Exp $ */
/******************************************************************************
*
*       XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS"
*       AS A COURTESY TO YOU, SOLELY FOR USE IN DEVELOPING PROGRAMS AND
*       SOLUTIONS FOR XILINX DEVICES.  BY PROVIDING THIS DESIGN, CODE,
*       OR INFORMATION AS ONE POSSIBLE IMPLEMENTATION OF THIS FEATURE,
*       APPLICATION OR STANDARD, XILINX IS MAKING NO REPRESENTATION
*       THAT THIS IMPLEMENTATION IS FREE FROM ANY CLAIMS OF INFRINGEMENT,
*       AND YOU ARE RESPONSIBLE FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE
*       FOR YOUR IMPLEMENTATION.  XILINX EXPRESSLY DISCLAIMS ANY
*       WARRANTY WHATSOEVER WITH RESPECT TO THE ADEQUACY OF THE
*       IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR
*       REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE FROM CLAIMS OF
*       INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*       FOR A PARTICULAR PURPOSE.
*
*       (c) Copyright 2002 Xilinx Inc.
*       All rights reserved.
*
******************************************************************************/
/*****************************************************************************/
/**
*
* @file xgemac_i.h
*
* This header file contains internal identifiers, which are those shared
* between XGemac components.  The identifiers in this file are not intended for
* use external to the driver.
*
* <pre>
* MODIFICATION HISTORY:
*
* Who  Date     Changes
* ---- -------- -----------------------------------------------
* ecm  01/13/03 First release
* ecm  03/25/03 Revision update
* rmm  05/28/03 Revision update
* rmm  09/23/03 Removed use of XGE_EIR_RECV_DFIFO_OVER_MASK, XGE_EIR
*               _RECV_MISSED_FRAME_MASK, XGE_EIR_RECV_COLLISION_MASK,
*               XGE_EIR_RECV_SHORT_ERROR_MASK, XGE_EIR_XMIT_ERROR_MASK.
*               Redefined default interrupt masks.
* </pre>
*
******************************************************************************/

#ifndef XGEMAC_I_H		/* prevent circular inclusions */
#define XGEMAC_I_H		/* by using protection macros */

/***************************** Include Files *********************************/

#include "xgemac.h"
#include "xgemac_l.h"

/************************** Constant Definitions *****************************/

/*
 * Default buffer descriptor control word masks. The default send BD control
 * is set for incrementing the source address by one for each byte transferred,
 * and specify that the destination address (FIFO) is local to the device. The
 * default receive BD control is set for incrementing the destination address
 * by one for each byte transferred, and specify that the source address is
 * local to the device.
 */
#define XGE_DFT_SEND_BD_MASK (XDC_DMACR_SOURCE_INCR_MASK | \
					XDC_DMACR_DEST_LOCAL_MASK)
#define XGE_DFT_RECV_BD_MASK (XDC_DMACR_DEST_INCR_MASK | \
					XDC_DMACR_SOURCE_LOCAL_MASK)

/*
 * Masks for the IPIF Device Interrupt enable and status registers.
 */
#define XGE_IPIF_EMAC_MASK		0x00000004UL	/* MAC interrupt */
#define XGE_IPIF_SEND_DMA_MASK		0x00000008UL	/* Send DMA interrupt */
#define XGE_IPIF_RECV_DMA_MASK		0x00000010UL	/* Receive DMA interrupt */
#define XGE_IPIF_RECV_FIFO_MASK		0x00000020UL	/* Receive FIFO interrupt */
#define XGE_IPIF_SEND_FIFO_MASK		0x00000040UL	/* Send FIFO interrupt */

/*
 * Default IPIF Device Interrupt mask when configured for DMA
 */
#define XGE_IPIF_DMA_DFT_MASK	(XGE_IPIF_SEND_DMA_MASK |		\
					XGE_IPIF_RECV_DMA_MASK |	\
					XGE_IPIF_EMAC_MASK |		\
					XGE_IPIF_SEND_FIFO_MASK |	\
					XGE_IPIF_RECV_FIFO_MASK)

/*
 * Default IPIF Device Interrupt mask when configured without DMA
 */
#define XGE_IPIF_FIFO_DFT_MASK		(XGE_IPIF_EMAC_MASK |			\
						XGE_IPIF_SEND_FIFO_MASK |	\
						XGE_IPIF_RECV_FIFO_MASK)

#define XGE_IPIF_DMA_DEV_INTR_COUNT	7	/* Number of interrupt sources */
#define XGE_IPIF_FIFO_DEV_INTR_COUNT	5	/* Number of interrupt sources */
#define XGE_IPIF_DEVICE_INTR_COUNT	7	/* Number of interrupt sources */
#define XGE_IPIF_IP_INTR_COUNT		22	/* Number of MAC interrupts */

/* a mask for all transmit interrupts, used in polled mode */
#define XGE_EIR_XMIT_ALL_MASK		(XGE_EIR_XMIT_DONE_MASK |		\
					XGE_EIR_XMIT_SFIFO_EMPTY_MASK |		\
					XGE_EIR_XMIT_LFIFO_FULL_MASK |		\
					XGE_EIR_XMIT_SFIFO_OVER_MASK |		\
					XGE_EIR_XMIT_SFIFO_UNDER_MASK |		\
					XGE_EIR_XMIT_LFIFO_OVER_MASK |		\
					XGE_EIR_XMIT_LFIFO_UNDER_MASK)

/* a mask for all receive interrupts, used in polled mode */
#define XGE_EIR_RECV_ALL_MASK	(XGE_EIR_RECV_DONE_MASK |		\
				XGE_EIR_RECV_ERROR_MASK |		\
				XGE_EIR_RECV_LFIFO_EMPTY_MASK |		\
				XGE_EIR_RECV_LFIFO_OVER_MASK |		\
				XGE_EIR_RECV_LFIFO_UNDER_MASK |		\
				XGE_EIR_RECV_LONG_ERROR_MASK |		\
				XGE_EIR_RECV_LEN_ERROR_MASK |		\
				XGE_EIR_RECV_FCS_ERROR_MASK |		\
				XGE_EIR_RECV_SLOT_LENGTH_ERROR_MASK |	\
				XGE_EIR_RECV_CRC_ENGINE_ERROR_MASK)

/* a default interrupt mask for scatter-gather DMA operation */
#define XGE_EIR_DFT_SG_MASK	(XGE_EIR_RECV_ERROR_MASK |		\
				XGE_EIR_RECV_LFIFO_OVER_MASK |		\
				XGE_EIR_RECV_LFIFO_UNDER_MASK |		\
				XGE_EIR_RECV_LONG_ERROR_MASK |		\
				XGE_EIR_RECV_LEN_ERROR_MASK |		\
				XGE_EIR_RECV_FCS_ERROR_MASK |		\
				XGE_EIR_RECV_SLOT_LENGTH_ERROR_MASK |	\
				XGE_EIR_RECV_CRC_ENGINE_ERROR_MASK |	\
				XGE_EIR_XMIT_SFIFO_OVER_MASK |		\
				XGE_EIR_XMIT_SFIFO_UNDER_MASK |		\
				XGE_EIR_XMIT_LFIFO_OVER_MASK |		\
				XGE_EIR_XMIT_LFIFO_UNDER_MASK)

/* a default interrupt mask for non-DMA operation (direct FIFOs) */
#define XGE_EIR_DFT_FIFO_MASK	(XGE_EIR_XMIT_DONE_MASK |		\
				XGE_EIR_RECV_DONE_MASK |		\
				XGE_EIR_DFT_SG_MASK)

/*
 * Mask for the DMA interrupt enable and status registers.
 */
#define XGE_DMA_SG_INTR_MASK	(XDC_IXR_DMA_ERROR_MASK |	\
				XDC_IXR_PKT_THRESHOLD_MASK |	\
				XDC_IXR_PKT_WAIT_BOUND_MASK |	\
				XDC_IXR_SG_END_MASK)

/**************************** Type Definitions *******************************/

/***************** Macros (Inline Functions) Definitions *********************/

/*****************************************************************************/
/*
*
* Clears a structure of given size, in bytes, by setting each byte to 0.
*
* @param StructPtr is a pointer to the structure to be cleared.
* @param NumBytes is the number of bytes in the structure.
*
* @return
*
* None.
*
* @note
*
* Signature: void XGemac_mClearStruct(u8 *StructPtr, unsigned int NumBytes)
*
******************************************************************************/
#define XGemac_mClearStruct(StructPtr, NumBytes)	\
							\
	int i;						\
	u8 *BytePtr = (u8 *)(StructPtr);		\
	for (i=0; i < (unsigned int)(NumBytes); i++)	\
	{						\
		*BytePtr++ = 0;				\
	}						\
}

/************************** Variable Definitions *****************************/

extern XGemac_Config XGemac_ConfigTable[];

/************************** Function Prototypes ******************************/

void XGemac_CheckEmacError(XGemac * InstancePtr, u32 IntrStatus);
void XGemac_CheckFifoRecvError(XGemac * InstancePtr);
void XGemac_CheckFifoSendError(XGemac * InstancePtr);

#endif  /* end of protection macro */
