/*
 * drivers/net/mb86977/camelot_ipfnat.h
 *
 * Fujitsu MB86977 IPF/NAT functions
 *
 * Author: <source@mvista.com>
 *
 * Copyright (c) 2004 by Fujitsu LSI Solution Ltd..  All Rights Reserved.
 *
 * 2004 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */

/* overload upper 8 bits of conntrack->status with chip index */
#define CM_IPFNAT_IDX_MASK 0xFF000000
#define CM_IPFNAT_IDX_SHIFT 24
#define CM_IPFNAT_IDX_VALID_BIT (0x80 << CM_IPFNAT_IDX_SHIFT)
#define CM_IPFNAT_IDX_IS_VALID(status) (status & CM_IPFNAT_IDX_VALID_BIT)
/* turn off all IDX bits */
#define CM_IPFNAT_IDX_SET_INVALID(status) (status &=  ~CM_IPFNAT_IDX_MASK)
/* get the index bits--mask off valid bit */
#define CM_IPFNAT_IDX_GET(status) (((status & CM_IPFNAT_IDX_MASK) \
                                    & ~CM_IPFNAT_IDX_VALID_BIT) \
                                   >> CM_IPFNAT_IDX_SHIFT)
/* set the index bits and make index valid */
#define CM_IPFNAT_IDX_SET(status, val) \
  do { \
	status |= (((val << CM_IPFNAT_IDX_SHIFT) | CM_IPFNAT_IDX_VALID_BIT) \
                   & CM_IPFNAT_IDX_MASK); \
  } while(0)

/*
 * overload second highest byte of conntrack->status with number of
 * periods conntrack has been inactive (used for timing out chip
 * entries)
 */
#define CM_IPFNAT_INACTIVITY_MASK 0x00FF0000
#define CM_IPFNAT_INACTIVITY_SHIFT 16
#define CM_IPFNAT_INACTIVITY_VALID_BIT (0x80 << CM_IPFNAT_INACTIVITY_SHIFT)
#define CM_IPFNAT_INACTIVITY_IS_VALID(status) \
  (status & CM_IPFNAT_INACTIVITY_VALID_BIT)
/* turn off all INACTIVITY bits */
#define CM_IPFNAT_INACTIVITY_SET_INVALID(status) \
  (status &= ~CM_IPFNAT_INACTIVITY_MASK)
/* get the inactivity bits--mask off valid bit */
#define CM_IPFNAT_INACTIVITY_GET(status) \
  (((status & CM_IPFNAT_INACTIVITY_MASK) & ~CM_IPFNAT_INACTIVITY_VALID_BIT) \
   >> CM_IPFNAT_INACTIVITY_SHIFT)
/* clear, then set the inactivity bits and mark as valid */
#define CM_IPFNAT_INACTIVITY_SET(status, val) \
  do { \
       status &= ~CM_IPFNAT_INACTIVITY_MASK; \
       status |= (((val << CM_IPFNAT_INACTIVITY_SHIFT) | \
                   CM_IPFNAT_INACTIVITY_VALID_BIT) \
		  & CM_IPFNAT_INACTIVITY_MASK); \
  } while(0)
/* increment the inactivity count */
#define CM_IPFNAT_INACTIVITY_INCR(status) \
  do { \
       if((status & CM_IPFNAT_INACTIVITY_MASK) == CM_IPFNAT_INACTIVITY_MASK){ \
          status &= ~CM_IPFNAT_INACTIVITY_MASK; \
          CM_IPFNAT_INACTIVITY_SET(status, 1); \
       } else { \
	  status += (1 << CM_IPFNAT_INACTIVITY_SHIFT); \
       } \
  } while(0)

/*   QOS Table  */

/* +++: can possibly use QOS_TBL_ENTRY and eliminate duplication */
struct qos_entry_s {
    int id;          /* 1-based id for this entry */
    /* number of conntracks referencing chip entry; 0 if entry is not
       added to chip table; >0 if entry is added to chip table; entry
       is deleted from chip table once refcount reaches 0 again */
    int refcount;
    int ipv6;
    unsigned long wan_ip[4];
    unsigned long dmz_ip[4];
    unsigned short wan_port;
    unsigned short dmz_port;
    unsigned short tos;
    unsigned long flowlabel;
};

typedef struct {
	struct qos_entry_s qos_entry[8];
	int num_entries;
} QOS_TBL ;

#if 0
/* +++ is this necessary? */
extern int cm_ipfnat_mode;

static inline void set_ipfnat_mode(int val)
{
	cm_ipfnat_mode = val;
}

static inline int get_ipfnat_mode(void)
{
	return cm_ipfnat_mode;
}
#endif
