/*
 * drivers/net/mb86977/camelot_ioctl.h
 *
 * Fujitsu MB86977 ioctl definitions
 *
 * Author: <source@mvista.com>
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */

#if 0
#define CM_SET_IPF       _IO('i', 130)
#define CM_DEL_IPF       _IO('i', 131)
#define CM_SET_NAT       _IO('i', 132)
#define CM_DEL_NAT       _IO('i', 133)
#define CM_SET_FLT_IN    _IO('i', 134)
#define CM_DEL_FLT_IN    _IO('i', 135)
#define CM_SET_FLT_OUT   _IO('i', 136)
#define CM_DEL_FLT_OUT   _IO('i', 137)
#define CM_DEL_UNMATCH   _IO('i', 138)
#define CM_PPPOE	 _IO('i', 139)
#define CM_TUNNEL	 _IO('i', 140)

#define CM_FLUSH_FLT	 _IO('i', 150)
#define CM_FLUSH_IPF	 _IO('i', 151)
#define CM_FLUSH_NAT	 _IO('i', 152)
#define CM_FLUSH_PPPOE	 _IO('i', 153)
#define CM_FLUSH_TUNNEL	 _IO('i', 154)
#else
#define CM_IPFNAT        SIOCDEVPRIVATE+0
enum {
	CM_SET_IPF = 1,
	CM_DEL_IPF,
	CM_SET_NAT,
	CM_DEL_NAT,
	CM_SET_IPFNAT,
	CM_SET_CT_TIMEOUTS,
	CM_SET_IPADDR,
	CM_SET_PPPOEADDR
};

#define CM_FLT           SIOCDEVPRIVATE+1
enum {
	CM_SET_FLT_IN = 1,
	CM_DEL_FLT_IN,
	CM_SET_FLT_OUT, 
	CM_DEL_FLT_OUT,
	CM_SET_FLT_MODE,
	CM_SET_FLT_MASK
};

#define CM_DEL_UNMATCH   SIOCDEVPRIVATE+2
#define CM_PPPOE	 SIOCDEVPRIVATE+3
enum {
	CM_PPPOE_SET = 1,
	CM_PPPOE_DEL
};
#define CM_TUNNEL	 SIOCDEVPRIVATE+4
#define CM_FLUSH	 SIOCDEVPRIVATE+5
#define CM_MATCH	 SIOCDEVPRIVATE+6
enum {
	CM_GET_MATCH = 1,
	CM_CLEAR_MATCH,
	CM_GET_MATCH_RT
};
#define CM_DEBUG_READ	 SIOCDEVPRIVATE+7
#define CM_SET_DMZ	 SIOCDEVPRIVATE+8
#define CM_DAT           SIOCDEVPRIVATE+9
enum {
	CM_SET_DAT = 1,
	CM_DEL_DAT,
	CM_CLEAR_DAT
};

#define CM_QOS           SIOCDEVPRIVATE+10
enum {
	CM_SET_QOS = 1,
	CM_DEL_QOS,
	CM_CLEAR_QOS,
	CM_SET_QOSTABLE
};

#define CM_L2            SIOCDEVPRIVATE+11
enum {
	CM_SET_L2_ENTRY = 1,
	CM_DEL_L2_ENTRY,
	CM_GET_L2_INTF
};

/* ifru_ivalue values for CM_FLUSH */
#define FLUSH_FLT	1
#define FLUSH_IPF	2
#define FLUSH_NAT	3
#define FLUSH_PPPOE	4
#define FLUSH_TUNNEL	5
#define FLUSH_DAT	6
#define FLUSH_QOS	7
#define FLUSH_L2_ALL	8
#define FLUSH_L2_DYN	9
#define FLUSH_FLT_COUNTS  10

struct camelot_ioctl_cmd {
	int what;
	void *data;
};

struct camelot_debug_read {
	int	what;
	int	index;
	void	*data;
};

enum {
	DEBUG_FILTER = 1,
	DEBUG_FILTER_COUNT,
	DEBUG_FILTER_LOG,
	DEBUG_FILTER_MODEMASK,
	DEBUG_IPFNAT,
	DEBUG_PPPOE,
	DEBUG_TUNNEL,
	DEBUG_DAT,
	DEBUG_QOS,
	DEBUG_L2TBL
};

#ifdef __KERNEL__
int camelot_ioctl(struct net_device *dev, struct ifreq *rq, int cmd);
#endif

#endif
