/*
 * drivers/net/mb86977/camelot_func.h
 *
 * Fujitsu MB86977 driver functions
 *
 * Author: <source@mvista.com>
 *
 * Copyright (c) 2002-2003 by Fujitsu LSI Solution Ltd..  All Rights Reserved.
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */

void init_camelot(struct camelot_softc *);
void initial_SMI(struct camelot_softc *);
void initial_FLCNT_SUBNM(struct camelot_softc *);
void initial_L3_4(struct camelot_softc *);
void initial_PRTTB(struct camelot_softc *);
void initial_PPPoE(struct camelot_softc *);
void initial_V4HEADER(struct camelot_softc *);
void initial_NATIPFTBL(struct camelot_softc *);
void initial_DATBL(struct camelot_softc *);
void initial_QOSTBL(struct camelot_softc *);
void initial_FLCNTL(struct camelot_softc *);
void initial_MAC(struct camelot_softc *);

void set_L2(struct camelot_softc *);
void set_l2_entry(struct camelot_softc *, int, unsigned long, unsigned long);
int delete_l2_entry(struct camelot_softc *, unsigned long, unsigned long);
void clear_l2_entry(struct camelot_softc *, int);
int lookup_l2_intf(struct camelot_softc *, unsigned long, unsigned long, int *);
void clear_dynamic_l2_entries(struct camelot_softc *);
void clear_all_l2_entries(struct camelot_softc *);

void set_inten(struct camelot_softc *);
int set_NATIPFTBL(struct camelot_softc *, int, NAT_IPF_TBL *);
int set_empty_NATIPFTBL(struct camelot_softc *, int);
void setnat_root(struct camelot_softc *, int, int, int);
int dat_get_index(struct camelot_softc *sc);
int set_DATBL(struct camelot_softc *sc, int id, DA_TBL *dt);
void setl2_root(struct camelot_softc *, int, unsigned char *, int);
void set_phy(struct camelot_softc *, int, int, int);
void setflt_root(struct camelot_softc *, int, int, int, int);
void set_L3_4(struct camelot_softc *, int, int, FLT_TBL *);
void reset_filter_match_counts(struct camelot_softc *);
void set_PRTTB(struct camelot_softc *, int, int);
void set_QOSTBL(struct camelot_softc *, int, int, QOS_TBL_ENTRY *);
void setqos_root(struct camelot_softc *, int, int, int);
int set_FLCNT(struct camelot_softc *sc, unsigned long data);
int set_SUBNM(struct camelot_softc *sc, unsigned long data);

int read_NATIPFTBL(struct camelot_softc *, int, int);
void read_dump_NTIPFTBL_entry(struct camelot_softc *sc, int index);
int read_DATBL_entry(struct camelot_softc *sc, int index, DA_TBL *dt);
void read_dump_DATBL_entry(struct camelot_softc *sc, int i);
void read_dump_NTALL(struct camelot_softc *);
void read_dump_NT(struct camelot_softc *, int);
void read_dump_L2ALL(struct camelot_softc *);
int read_phy(struct camelot_softc *, int, int);
int read_SMIST(struct camelot_softc *);
int read_MACST(struct camelot_softc *, int);
int read_L3_4_filter(struct camelot_softc *, int, int, int);
int read_PRTTB(struct camelot_softc *, int, int);
int read_FLCNTST(struct camelot_softc *, int, int);
int read_FLCNTV(struct camelot_softc *, int, int);
void incr_FLCNTV(struct camelot_softc *, int, int);
void read_dump_FLTALL(struct camelot_softc *, int);
void read_dump_FLT(struct camelot_softc *, int, int);
void read_TTL0LOG(struct camelot_softc *, u_int32_t *);
void read_FLTLOG(struct camelot_softc *, u_int32_t [][16], u_int32_t [][16],
		 int *pstatus);
void read_NMTLOG(struct camelot_softc *, u_int32_t *);
void read_RFLOG(struct camelot_softc *, u_int32_t *);
int read_QOSTBL(struct camelot_softc *, int, int, int);
int read_QOSTBL_entry(struct camelot_softc *sc, int wan_port, int entry,
		      QOS_TBL_ENTRY *qos);
void read_dump_QOSTBL_entry(struct camelot_softc *sc, int port, int idx);
void read_dump_QTALL(struct camelot_softc *, int);
