/*
 * drivers/net/mb86977/camelot_bits.h
 *
 * Fujitsu MB86977 bit definitions
 *
 * Author: <source@mvista.com>
 *
 * 2003 (c) MontaVista Software, Inc. This file is licensed under
 * the terms of the GNU General Public License version 2. This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 *
 */

#ifndef _CAMELOT_BITS_H_
#define _CAMELOT_BITS_H_

/*
 * filter table control bits
 */

/* control_10 */
#define L4PTYPESEL_SHIFT		20
#define L4PTYPESEL_MASK		(0x7 << L4PTYPESEL_SHIFT)
#define L4PTYPESEL_VAL(v) \
		(((v) & L4PTYPESEL_MASK) >> L4PTYPESEL_SHIFT)
#define L4PTYPESEL_ICMP		(4 << L4PTYPESEL_SHIFT)
#define L4PTYPESEL_TCP_OR_UDP	(3 << L4PTYPESEL_SHIFT)
#define L4PTYPESEL_UDP		(2 << L4PTYPESEL_SHIFT)
#define L4PTYPESEL_TCP		(1 << L4PTYPESEL_SHIFT)
#define L4PTYPESEL_DONT_CARE	(0 << L4PTYPESEL_SHIFT)

/* M_Range */
#define L4_dst_range		(1 << 19)	/* [3] */
#define L4_src_range		(1 << 18)	/* [2] */
#define L4_dont_care_dst	(1 << 17)	/* [1] */
#define L4_dont_care_src	(1 << 16)	/* [0] */
#define v6_dont_care_dst_TLA	(1 << 15)	/* [7] */
#define v6_dont_care_dst_NLA	(1 << 14)	/* [6] */
#define v6_dont_cast_dst_SLA	(1 << 13)	/* [5] */
#define v6_dont_cast_dst_host	(1 << 12)	/* [4] */
#define v6_dont_care_src_TLA	(1 << 11)	/* [11] */
#define v6_dont_care_src_NLA	(1 << 10)	/* [10] */
#define v6_dont_cast_src_SLA	(1 << 9)	/* [9] */
#define v6_dont_cast_src_host	(1 << 8)	/* [8] */
#define v4_mask_use_dst		(1 << 7)	/* [15] */
#define v4_mask_use_src		(1 << 6)	/* [14] */
#define v4_dont_care_dst	(1 << 5)	/* [13] */
#define v4_dont_care_src	(1 << 4)	/* [12] */
#define icmp_dont_care		(1 << 2)	/* [16] */

#define ip_choice_ipv4		(1 << 1)
#define entry_valid		(1 << 0)

/* control_11 */
#define do_log	        (1 << 9)	
#define pass_drop	(1 << 8)
#define ack_fg_en_1	(1 << 5)
#define ack_fg_en_0	(1 << 4)

#define filt_intf_wan_dmz_lan 0x0;
#define filt_intf_wan         0x1;
#define filt_intf_dmz         0x2;
#define filt_intf_wan_dmz     0x3;
#define filt_intf_lan         0x4;

/* control_12 */
#define p_log 		(1 << 25)
#define p_pass_drop	(1 << 24)
#define p_entry_valid	(1 << 0)

/*
 * NAT/IP Forward table
 */

/* item 19 & 20 */
#define dest_intf_wan_hp	(1 << 5)
#define dest_intf_wan_np	(1 << 4)
#define dest_intf_dmz_hp	(1 << 3)
#define dest_intf_dmz_np	(1 << 2)
#define dest_intf_lan1		(1 << 1)
#define dest_intf_lan0		(1 << 0)

/* item 22 */
#define tos_shift		24
#define tos_value(tos)		((tos) << tos_shift)
#define cntrlbit_1_nat		(1 << 21)
#define cntrlbit_0_valid	(1 << 20)
#define cntrlbit_3_ipv6		(1 << 17)
#define cntrlbit_2_ipv4		(1 << 16)

#define cntrlbit_5_udp		(1 << 13)
#define cntrlbit_4_tcp		(1 << 12)
#define v6_over_v4_tun_hdr_select(t)	((t)<<8)
#define pppoe_hdr_select(t)	((t)<<4)
#define replace_tos		(1 << 2) 
#define add_v6_over_v4_tun_hdr	(1 << 1)
#define add_pppoe_hdr		(1 << 0)


/*
 * filter control bits
 */
#define fc_tunnel_valid_output		(1 << 19)
#define fc_fragment_packet_output	(1 << 18)
#define fc_no_match_l34_table_output	(1 << 17)
#define fc_no_match_p_table_output	(1 << 16)
#define fc_pppoe_disc_output		(1 << 15)
#define fc_pppoe_sess_ipv4_drop_output	(1 << 14)
#define fc_pppoe_sess_ipv4_pass_output	(1 << 13)
#define fc_pppoe_sess_ipv6_drop_output	(1 << 12)
#define fc_pppoe_sess_ipv6_pass_output	(1 << 11)
#define fc_pppoe_sess_noip_output	(1 << 10)
#define fc_ipv4_tun_valid_input		(1 << 9)
#define fc_frag_pkt_input		(1 << 8)
#define fc_no_match_l34_table_input	(1 << 7)
#define fc_no_match_p_table_input	(1 << 6)
#define fc_pppoe_disc_input		(1 << 5)
#define fc_pppoe_sess_ipv4_drop_input	(1 << 4)
#define fc_pppoe_sess_ipv4_pass_input	(1 << 3)
#define fc_pppoe_sess_ipv6_drop_input	(1 << 2)
#define fc_pppoe_sess_ipv6_pass_input	(1 << 1)
#define fc_pppoe_sess_noip_input	(1 << 0)

#define fc_filter_bits	(fc_tunnel_valid_output | \
			 fc_fragment_packet_output | \
			 fc_no_match_l34_table_output | \
			 fc_no_match_p_table_output | \
			 fc_ipv4_tun_valid_input | \
			 fc_frag_pkt_input | \
			 fc_no_match_l34_table_input | \
			 fc_no_match_p_table_input)

#define fc_pppoe_bits	(fc_pppoe_disc_output | \
			 fc_pppoe_sess_ipv4_drop_output | \
			 fc_pppoe_sess_ipv4_pass_output | \
			 fc_pppoe_sess_ipv6_drop_output | \
			 fc_pppoe_sess_ipv6_pass_output | \
			 fc_pppoe_sess_noip_output | \
			 fc_pppoe_disc_input | \
			 fc_pppoe_sess_ipv4_drop_input | \
			 fc_pppoe_sess_ipv4_pass_input | \
			 fc_pppoe_sess_ipv6_drop_input | \
			 fc_pppoe_sess_ipv6_pass_input | \
			 fc_pppoe_sess_noip_input)


#endif /* _CAMELOT_BITS_H_ */

