/*
 *
 * BRIEF MODULE DESCRIPTION
 *      Helpfile for korina.c
 *
 * Copyright 2002 MontaVista Software Inc.
 * Author: MontaVista Software, Inc.
 *         	stevel@mvista.com or source@mvista.com
 *
 * Heavily modified from original version by:
 *
 * (C) 2001, IDT Inc.
 *
 * ########################################################################
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * ########################################################################
 */

#ifndef KORINA_H
#define KORINA_H

#include <linux/config.h>
#include  <asm/rc32434/dma_v.h>
#include  <asm/rc32434/eth_v.h>

#ifdef DEBUG
#define ASSERT(boolExp) do{if(!(boolExp))pr_debug("ASSERT %s(%d): %s\n",__FILE__, __LINE__, #boolExp);}while(0)
#else
#define ASSERT(x) do {} while (0)
#endif

/* INFO */
#define INFO(format, arg...) printk(KERN_INFO "%s: " format, dev->name , ## arg)

#define ETH_DMA_RX_IRQ   	GROUP1_IRQ_BASE + 0
#define ETH_DMA_TX_IRQ   	GROUP1_IRQ_BASE + 1
#define ETH_RX_OVR_IRQ   	GROUP3_IRQ_BASE + 9
#define ETH_TX_UND_IRQ   	GROUP3_IRQ_BASE + 10

extern unsigned int idt_cpu_freq;

/* Index to functions, as function prototypes. */
static int korina_open(struct net_device *dev);
static int korina_send_packet(struct sk_buff *skb, struct net_device *dev);
static void korina_und_interrupt(int irq, void *dev_id, struct pt_regs *regs);
static void korina_rx_dma_interrupt(int irq, void *dev_id,
				    struct pt_regs *regs);
static void korina_tx_dma_interrupt(int irq, void *dev_id,
				    struct pt_regs *regs);
static int korina_close(struct net_device *dev);
static struct net_device_stats *korina_get_stats(struct net_device *dev);
static void korina_multicast_list(struct net_device *dev);
static void korina_tx_timeout(struct net_device *dev);
static void korina_tx_tasklet(unsigned long tx_data_dev);
static void korina_rx_tasklet(unsigned long rx_data_dev);
static void korina_cleanup_module(void);
static int korina_probe(int port_num);
static int korina_init(struct net_device *dev);
int korina_init_module(void);

/* cgg - the following must be powers of two */
#define KORINA_NUM_RDS    128	/* number of receive descriptors */
#define KORINA_NUM_TDS    128	/* number of transmit descriptors */

#define KORINA_RBSIZE     1536	/* size of one resource buffer = Ether MTU */
#define KORINA_RDS_MASK   (KORINA_NUM_RDS-1)
#define KORINA_TDS_MASK   (KORINA_NUM_TDS-1)
#define RD_RING_SIZE (KORINA_NUM_RDS * sizeof(struct DMAD_s))
#define TD_RING_SIZE (KORINA_NUM_TDS * sizeof(struct DMAD_s))

#define KORINA_TX_TIMEOUT HZ/4

#define rc32434_eth_regs ((ETH_t)(ETH_VirtualAddress);

enum status { filled, empty };
#define IS_DMA_FINISHED(X)   (((X) & (DMAD_f_m)) != 0)
#define IS_DMA_DONE(X)   (((X) & (DMAD_d_m)) != 0)

/* Information that need to be kept for each board. */
struct korina_local {
	ETH_t eth_regs;
	DMA_Chan_t rx_dma_regs;
	DMA_Chan_t tx_dma_regs;
	volatile DMAD_t td_ring;	/* transmit descriptor ring */
	volatile DMAD_t rd_ring;	/* receive descriptor ring  */

	struct sk_buff *tx_skb[KORINA_NUM_TDS];	/* skbuffs for pkt to trans */
	struct sk_buff *rx_skb[KORINA_NUM_RDS];	/* skbuffs for pkt to trans */

	struct tasklet_struct *rx_tasklet;
	struct tasklet_struct *tx_tasklet;

	int rx_next_done;
	int rx_chain_head;
	int rx_chain_tail;
	enum status rx_chain_status;

	int tx_next_done;
	int tx_chain_head;
	int tx_chain_tail;
	enum status tx_chain_status;
	int tx_count;		/* current # of pkts waiting to be sent */
	int tx_full;

	struct timer_list mii_phy_timer;
	unsigned long duplex_mode;

	int rx_irq;
	int tx_irq;
	int ovr_irq;
	int und_irq;

	struct net_device_stats stats;
	spinlock_t lock;	/* Serialise access to device */

	/* debug /proc entry */
	struct proc_dir_entry *ps;
	int dma_halt_cnt;
	u32 halt_tx_count;
	int dma_collide_cnt;
	u32 collide_tx_count;
	int dma_run_cnt;
	u32 run_tx_count;
	int dma_race_cnt;
	u32 race_tx_count;
};

static inline void
rc32434_abort_dma(struct net_device *dev, DMA_Chan_t ch)
{

	if (local_readl(&ch->dmac) & DMAC_run_m) {
		local_writel(0x10, &ch->dmac);
		while (!(local_readl(&ch->dmas) & DMAS_h_m))
			dev->trans_start = jiffies;
		local_writel(0, &ch->dmas);
	}

	local_writel(0, &ch->dmadptr);
	local_writel(0, &ch->dmandptr);

}

#endif				/* KORINA_H */
