/*
 * ocp_rgmii.h
 *
 * Defines for the IBM RGMII bridge
 *
 * Copyright 2003 MontaVista Softare Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#ifndef _OCP_RGMII_H_
#define _OCP_RGMII_H_

#include <linux/config.h>

#ifdef CONFIG_440GX
extern int rgmii_init(int mode, struct net_device *dev);
extern void rgmii_enable_port(struct net_device *dev);
extern void rgmii_set_port_speed(int speed, struct net_device *dev);
#else
#define rgmii_init(x, y)
#define rgmii_enable_port(x)
#define rgmii_set_port_speed(x, y)
#endif

/* RGMII bridge */
typedef struct rgmii_regs {
	u32 fer;                /* Function enable register */
	u32 ssr;                /* Speed select register */
} rgmii_t;

/* Fuctional Enable Reg */

#define RGMII_RTBI2	0x00000004
#define RGMII_RGMII2	0x00000005
#define RGMII_TBI2  	0x00000006
#define RGMII_GMII2 	0x00000007
#define RGMII_RTBI3	0x00000040
#define RGMII_RGMII3	0x00000050
#define RGMII_TBI3  	0x00000060
#define RGMII_GMII3 	0x00000070

/* Speed Selection reg */

#define RGMII_SP2_100	0x00000002
#define RGMII_SP2_1000	0x00000004
#define RGMII_SP3_100	0x00000200
#define RGMII_SP3_1000	0x00000400

#define RGMII_MII2_SPDMASK	 0x00000007
#define RGMII_MII3_SPDMASK	 0x00000700

#define RGMII_MII2_100MB	 RGMII_SP2_100 & ~RGMII_SP2_1000
#define RGMII_MII2_1000MB 	 RGMII_SP2_1000 & ~RGMII_SP2_100
#define RGMII_MII2_10MB		 ~(RGMII_SP2_100 | RGMII_SP2_1000)  
#define RGMII_MII3_100MB	 RGMII_SP3_100 & ~RGMII_SP3_1000
#define RGMII_MII3_1000MB 	 RGMII_SP3_1000 & ~RGMII_SP3_100
#define RGMII_MII3_10MB		 ~(RGMII_SP3_100 | RGMII_SP3_1000)  

#define RGMII		0
#define TBI		1
#define GMII		2
#define RTBI		3
/* MDI through ZMII bridge */
#define RGMII_AUTO	5

#endif				/* _OCP_RGMII_H_ */
