/******************************************************************************

    mx2ads-cam.h
    driver for Motorola MX2ADS on-board CMOS Image Sensor

    Author: MontaVista Software, Inc. <source@mvista.com>
    Copyright (c) 2004 MontaVista Software, Inc.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

********************************************************************************/
#ifndef MX2ADS_CAM_H
#define MX2ADS_CAM_H

#define CSI_REG_READ(_reg, _var) \
     do {                                 \
	     (_var) = CSI_ ##_reg ;  \
     } while (0)

#define CSI_REG_WRITE(_reg, _var) \
     do {                                 \
	     CSI_ ##_reg = (_var);   \
     } while (0)


/*
 * Special MDS register (controls CNTL and LEDs)
 */
#define  CSI_EXP_IO (*((volatile uint16_t *)(MX2ADS_PER_IOBASE + 0x800000)))

#define  EXP_IO_CSI_CTL2    0x0010
#define  EXP_IO_CSI_CTL1    0x0020
#define  EXP_IO_CSI_CTL0    0x0040


/*
 * Micron CMOS camera registers:
 */

#define MISOC0343_R1     0x01

/* Micron has 2 areas - Image core and Image flow processor */
#define MISOC0343_IFP    0x01   /* set R1 to choose Image Flow Processor (IFP) */
#define MISOC0343_IC     0x04   /* set R1 to choose Image Core (IC) */

/* IFP registers */
#define MISOC0343_IFP_RESET       0x07
#define MISOC0343_IFP_FORMAT      0x08
#define MISOC0343_IFP_SHWIDTH     0x37
#define MISOC0343_IFP_DECIMATION  0x46
#define MISOC0343_IFP_VERSION     0x49


/* IFP registers bit values */
#define MISOC0343_SHWIDTH_DEFAULT  0x0100 /* Default value for Shutter Width */

#define MISOC0343_FORMAT_565RGB    0x1000 /* Enable sensor output in RGB565 */

#define MISOC0343_DECIMATION_VGA    0x0000 /* VGA (640 x 480) */
#define MISOC0343_DECIMATION_QVGA   0x0001 /* QVGA (320 x 240) */
#define MISOC0343_DECIMATION_CIF    0x0002 /* CIF (352 x 288) */
#define MISOC0343_DECIMATION_QCIF   0x0003 /* QCIF (176 x 144) */
#define MISOC0343_DECIMATION_QQVGA  0x0004 /* QQVGA (160 x 120) */

#define MISOC0343_IMAGE_VERSION     0x07D3 /* IFP Core version */

/* IC registers */
#define MISOC0343_IC_RESET    0x0D
#define MISOC0343_IC_RDMODE   0x20 /* Read Mode register */
#define MISOC0343_IC_VERSION  0x36 /* Image Core Version */


#define MISOC0343_RDMODE_UPSDOWN    0x8080 /* Read Mode: readout from bottom to top
					      (it's recommended to set readout starting 1 row later) */
#define MISOC0343_RDMODE_MIRRORED   0x4020 /* Read Mode: readout from left to right
					      (it's recommended to set readout starting 1 column later) */
#define MISOC0343_RDMODE_BOOSTRST   0x1000 /* Read Mode: Enabled boosted reset */
#define MISOC0343_RDMODE_ALLFRAMES  0x0001 /* Read Mode: output all frames (including bad) */

#define MISOC0343_CORE_VERSION      0xE342 /* Imager Core Version */

/* CSI */

#define CSI_IRQ_ALL  (CSICR1_SOF_INTEN |  \
		      CSICR1_STATFF_INTEN | CSICR1_RXFF_INTEN | \
		      CSICR1_RXFFOR_INTEN | CSICR1_STATFFOR_INTEN |  \
		      CSICR1_COF_INTEN | CSICR1_EOF_INTEN)

#define CSI_IRQ_SOF  (CSICR1_SOF_INTEN)


#include <linux/videodev.h>

struct capture_device;

#define MAX_OPENS 3

struct device_open {
	int isopen;
	int noncapturing;
	struct capture_device *dev;
};

struct capture_device {
	struct v4l2_device v;

	int is_registered;
	int mem_region_reserved;

	int                 open_count;          /* General open count */
	struct device_open  open_data[MAX_OPENS];
	int                 capturing_opens;     /* Number of opens with capturing capability */

	 /*      Capture state   */
	int ready_to_capture;
	int capture_started;
	int capture_completed;

	int       capture_bypp;
	int       capture_size;
	uint8_t  *capture_buffer;   /* vmalloc() */
	int       capture_buffer_size;
	unsigned long time_acquired;    /* millisecond time stamp */

	wait_queue_head_t new_video_frame;

	struct v4l2_pix_format   clientfmt;
	struct v4l2_captureparm  capture;
	struct v4l2_performance  perf;
};


#define MIN_WIDTH               160 /* pixels */
#define MIN_HEIGHT              120
#define MAX_WIDTH               640
#define MAX_HEIGHT              480
#define DEFAULT_WIDTH           320
#define DEFAULT_HEIGHT          240

#define DEFAULT_DEPTH           16      /* 16bbp */

#define MAX_FRAME_AGE           200     /* ms */


#endif /* MX2ADS_CAM_H */
