#ifndef SIIMAGE_H
#define SIIMAGE_H

#include <linux/config.h>
#include <linux/pci.h>
#include <linux/ide.h>

#include <asm/io.h>

#define DISPLAY_SIIMAGE_TIMINGS

#undef SIIMAGE_VIRTUAL_DMAPIO
#undef SIIMAGE_BUFFERED_TASKFILE
#undef SIIMAGE_LARGE_DMA

#define SII_DEBUG 0

#if SII_DEBUG
#define siiprintk(x...)	printk(x)
#else
#define siiprintk(x...)
#endif


#if defined(DISPLAY_SIIMAGE_TIMINGS) && defined(CONFIG_PROC_FS)
#include <linux/stat.h>
#include <linux/proc_fs.h>

static char * print_siimage_get_info(char *, struct pci_dev *, int);
static int siimage_get_info(char *, char **, off_t, int);

byte siimage_proc;

#endif /* DISPLAY_SIIMAGE_TIMINGS && CONFIG_PROC_FS */	
#define SIIMAGE_ULTRA_MASK  0x7f
#define SIIMAGE_MWDMA_MASK  0x07
#define SIIMAGE_SWDMA_MASK  0x07

unsigned int init_chipset_siimage(struct pci_dev *, const char *);
void init_iops_siimage(ide_hwif_t *);
void init_hwif_siimage(ide_hwif_t *);
void init_dma_siimage(ide_hwif_t *, unsigned long);

#endif /* SIIMAGE_H */
