/*
   
   -------------------------------------------------------------------------
   i2c-mv64360.h TWSI (i2c) adapter driver for MV64360 Two Wire Serial 
   Interface adapter
   -------------------------------------------------------------------------
   
   Copyright 2003 Artesyn Communication Products, LLC
   
   Author:  Tim Montgomery <timm@artesyncp.com>
   
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   ----------------------------------------------------------------------------

*/  
	
#ifndef I2C_MV64360_H
#define I2C_MV64360_H
	
/* TWSI register offsets */ 

#define I2C_HW_MV64360 0x00
#define I2C_LOCAL_SLAVE_ADDR          0x90
#define I2C_LOCAL_SLAVE_ADDR_MODE     0x91
#define I2C_LOCAL_SLAVE_ENABLE        0x92
#define MV64360_TWSI_SLAVE_ADDR                           0xC000
#define MV64360_TWSI_EXT_SLAVE_ADDR                       0xC010
#define MV64360_TWSI_DATA                                 0xC004
#define MV64360_TWSI_CONTROL                              0xC008
	/* 0xC00C is status when read */ 
#define MV64360_TWSI_STATUS                               0xC00C
	/* 0xC00C is baud rate when written */ 
#define MV64360_TWSI_BAUD_RATE                            0xC00C
#define MV64360_TWSI_SOFT_RESET                           0xC01C
/* TWSI bit definitions */
	
#define MV64360_TWSI_SLAVE_ADDR_GCE                       0x00000001
#define MV64360_TWSI_SLAVE_ADDR_SADDR_MASK                0x000000FE
#define MV64360_TWSI_SLAVE_ADDR_SADDR_SHIFT               1
#define MV64360_TWSI_EXT_SLAVE_ADDR_MASK                  0x000000FF
#define MV64360_TWSI_DATA_MASK                            0x000000FF
#define MV64360_TWSI_CONTROL_ACK                          0x00000004
#define MV64360_TWSI_CONTROL_INT_FLAG                     0x00000008
#define MV64360_TWSI_CONTROL_STOP                         0x00000010
#define MV64360_TWSI_CONTROL_START                        0x00000020
#define MV64360_TWSI_CONTROL_TWSI_EN                      0x00000040
#define MV64360_TWSI_CONTROL_INT_EN                       0x00000080
#define MV64360_TWSI_STATUS_MASK                          0x000000FF
#define MV64360_TWSI_STATUS_BUS_ERROR                     0x00000000
#define MV64360_TWSI_STATUS_START_COND_TX_OK              0x00000008
#define MV64360_TWSI_STATUS_RPT_START_COND_TX_OK          0x00000010
#define MV64360_TWSI_STATUS_ADDR_WR_TX_OK_ACK             0x00000018
#define MV64360_TWSI_STATUS_ADDR_WR_TX_OK_NOACK           0x00000020
#define MV64360_TWSI_STATUS_MASTER_TX_DATA_ACK            0x00000028
#define MV64360_TWSI_STATUS_MASTER_TX_DATA_NOACK          0x00000030
#define MV64360_TWSI_STATUS_MASTER_LOST_ARB               0x00000038
#define MV64360_TWSI_STATUS_ADDR_RD_TX_OK_ACK             0x00000040
#define MV64360_TWSI_STATUS_ADDR_RD_TX_OK_NOACK           0x00000048
#define MV64360_TWSI_STATUS_MASTER_RX_DATA_ACK            0x00000050
#define MV64360_TWSI_STATUS_MASTER_RX_DATA_NOACK          0x00000058
#define MV64360_TWSI_STATUS_SLAVE_RX_ADDR_ACK             0x00000060
#define MV64360_TWSI_STATUS_MASTER_LOST_ARB_ACK           0x00000068
#define MV64360_TWSI_STATUS_GENERAL_CALL_ACK_TX           0x00000070
#define MV64360_TWSI_STATUS_MSTR_LOST_ARB_GEN_CALL_RX     0x00000078
#define MV64360_TWSI_STATUS_SLV_RX_WR_SLV_ADRS_ACK_TX     0x00000080
#define MV64360_TWSI_STATUS_SLV_RX_WR_SLV_ADRS_NO_ACK     0x00000088
#define MV64360_TWSI_STATUS_SLV_RX_WR_GEN_CALL_ACK_TX     0x00000090
#define MV64360_TWSI_STATUS_SLV_RX_WR_GEN_CALL_NO_ACK     0x00000098
#define MV64360_TWSI_STATUS_SLV_RX_STOP_RPT_START         0x000000A0
#define MV64360_TWSI_STATUS_SLV_RX_ADRS_RD_BIT_ACK_TX     0x000000A8
#define MV64360_TWSI_STATUS_MSTR_LOST_ARB_SLV_RD          0x000000B0
#define MV64360_TWSI_STATUS_SLV_TX_RD_ACK_RCVD            0x000000B8
#define MV64360_TWSI_STATUS_SLV_TX_RD_NO_ACK              0x000000C0
#define MV64360_TWSI_STATUS_2ND_ADDR_WR_BIT_ACK           0x000000D0
#define MV64360_TWSI_STATUS_2ND_ADDR_WR_BIT_TX_NO_ACK     0x000000D8
#define MV64360_TWSI_STATUS_2ND_ADDR_RD_BIT_ACK           0x000000E0
#define MV64360_TWSI_STATUS_2ND_ADDR_RD_BIT_NO_ACK        0x000000E8
#define MV64360_TWSI_STATUS_NO_STATUS                     0x000000F8
#define MV64360_TWSI_BAUD_RATE_N_MASK                     0x00000007
#define MV64360_TWSI_BAUD_RATE_N_SHIFT                    0
#define MV64360_TWSI_BAUD_RATE_M_MASK                     0x00000031
#define MV64360_TWSI_BAUD_RATE_M_SHIFT                    1

typedef struct _mv64360_i2c_device {
	u32 base_addr;		/* base address of this controller */
	int sysclk_freq;	/* system clock speed */
	int i2c_bus_freq;	/* i2c bus speed */

	int initialized;	/* are we init'd? */
	int interrupt_mode;	/* interrupt mode (vs. polled) ? */
	int status;		/* status flag */
	int prev_state;		/* previous state flag */
	int bus_error;		/* controller indicated i2c bus error */

	struct i2c_msg *msg;	/* pointer to the current i2c message */
	int last_msg;		/* flag to indicate we're on the last message */

	int bytes_to_txfr;	/* number of bytes to transfer (master) */
	int bytes_txfrd;	/* number of bytes transferred */
	int poll_finished;	/* completion flag for polled mode txfr */

	int slave_enabled;	/* slave mode enabled ? */
	int slave_addr;		/* our slave address */
	int slave_addr_mode;	/* our slave address mode (7 vs. 10 bit) */
	int slave_byte_num;	/* byte index number for current slave transaction */
	struct semaphore master_sem;	/* master transfer complete synchronization */
} MV64360_TWSI_DEVICE;

#endif	/* I2C_MV64360_H */
