/*
 * i2c-mpc.h 
 * non-CPM I2C driver for the Motorola MPC85xx, MPC824x, and MPC107
 * Derived from Wolfgang Denk's MPC8240 I2C driver, and IBM 4xx I2C driver
 * 
 * (C) Copyright 2002,2003, 2004 Motorola Inc
 * Authors: Xianghua Xiao, Andy Fleming
 *
 * Maintainer: Kumar Gala (galak@motorola.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __MPC_I2C_H
#define __MPC_I2C_H

#include <linux/version.h>
#include <linux/i2c.h>

#include <linux/tqueue.h>

/* Timeout for waiting for the bus (seconds) */
#define MPC_TIMEOUT 50

/* retries value for the adapter. */
#define MPC_RETRIES 3

/* Number of seconds to wait for an interrupt */
#define MPC_INT_TIMEOUT 5

/* Mask for writing the entire register in I2C */
#define MPC_I2C_FULLREG 0xff

/* Default Clock Speed */
#define MPC_I2C_CLKSPD 0x3f

/* Default DFSR value */
#define MPC_I2C_DFSR 0x10

/* Masks of which bits get set when writing
 * to the register (ADR or FDR) */
#define MPC_I2CADR_MASK     0xFE
#define MPC_I2CFDR_MASK     0x3F

/* Bits for the CR */
#define MPC_I2CCR_MEN       0x80 /* Enable */
#define MPC_I2CCR_MIEN      0x40 /* Interrupt Enable */
#define MPC_I2CCR_MSTA      0x20 /* Start Bit */
#define MPC_I2CCR_MTX       0x10 /* Transmit bit */
#define MPC_I2CCR_TXAK      0x08 /* TX Acknowledge */
#define MPC_I2CCR_RSTA      0x04 /* Restart bit */
#define MPC_I2CCR_BCST      0x01 /* Broadcast */

/* Bits for the SR */
#define MPC_I2CSR_MCF       0x80 /* Transfer Pending */
#define MPC_I2CSR_MAAS      0x40 /* Master/Slave */
#define MPC_I2CSR_MBB       0x20 /* Bus Busy */
#define MPC_I2CSR_MAL       0x10 /* Arbitration Lost */
#define MPC_I2CSR_BCSTM     0x08 /* Broadcast */
#define MPC_I2CSR_SRW       0x04 /* */
#define MPC_I2CSR_MIF       0x02 /* Interrupt */
#define MPC_I2CSR_RXAK      0x01 /* RX Acknowledged */

/* Data Register Mask */
#define MPC_I2CDR_DATA      0xFF

/* DFSRR default value */
#define MPC_I2CDFSRR        0x3F 

/* Linux I2C values */
#define I2C_ALGO_MPC        0x140000          /* Algorithm */
#define I2C_HW_MPC          0x00              /* Adapter */

/* I2C address when addressed as a slave */
#define I2C_MPC_ADDR	    0xfe

/* Init value for the CR */
#define MPC_I2CCR_INIT 	(MPC_I2CCR_MEN | \
		MPC_I2CCR_MSTA| \
		MPC_I2CCR_MTX | \
		MPC_I2CCR_RSTA)

/* I2C Registers */
struct mpc_i2c {
	u8  i2cadr;         /* 0x000 - I2C Address Register */
	u8    res1[3];
	u8  i2cfdr;         /* 0x004 - I2C Frequency Divider Register */
	u8    res2[3];
	u8  i2ccr;          /* 0x008 - I2C Control Register */
	u8    res3[3];
	u8  i2csr;          /* 0x00c - I2C Status Register */
	u8    res4[3];
	u8  i2cdr;          /* 0x010 - I2C Data Register */
	u8    res5[3];
	u8  i2cdfsrr;       /* 0x014 - I2C Digital Filtering Sampling Rate Register */
	u8    res6[3];
};

struct mpc_i2c_private {
	struct i2c_adapter adap;
	volatile struct mpc_i2c *regs;
	wait_queue_head_t i2c_waitq;
	int index;	/* device number */
	int irq;	/* IRQ number */
	int poll;	/* polling mode if == 0 */
	int pending;	/* Interrupt occurred */
	u32 flags;	/* features this device supports */

	/* Write and read function pointers for writing
	 * device registers */
	void (*write)(volatile u8 *addr, u8 value, u8 mask);
	u8 (*read)(volatile u8 *addr);
};


#endif
