/* (C) Copyright Koninklijke Philips Electronics NV 2004. All rights reserved.
 *
 * You can redistribute and/or modify this software under the terms of
 * version 2 of the GNU General Public License as published by the Free
 * Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _VHTYPES_H_
#define _VHTYPES_H_

/* --------------------------------------------------------------------------
*  General defines
*  -------------------------------------------------------------------------- */

/* Undefined Pointer value */
#ifndef NULL
#define NULL            0
#endif

#ifndef FALSE
#define FALSE           0
#endif

#ifndef TRUE
#define TRUE            1
#endif

/* --------------------------------------------------------------------------
*  Types Definitions
*  -------------------------------------------------------------------------- */
#ifndef ASM_INCLUDE

#ifndef _TMNXTYPES_H_
#define _TMNXTYPES_H_

/* vHAL Standard Types   Type   Pointer
*                       ------  ------- */
typedef signed   char   Int8,   *pInt8;     /*  8 bit   signed integer */
typedef signed   short  Int16,  *pInt16;    /* 16 bit   signed integer */
typedef signed   long   Int32,  *pInt32;    /* 32 bit   signed integer */
typedef unsigned char   UInt8,  *pUInt8;    /*  8 bit unsigned integer */
typedef unsigned short  UInt16, *pUInt16;   /* 16 bit unsigned integer */
typedef unsigned long   UInt32, *pUInt32;   /* 32 bit unsigned integer */
typedef void            Void,   *pVoid;     /* Void (typeless) */
typedef float           Float,  *pFloat;    /* 32 bit floating point */
typedef double          Double, *pDouble;   /* 32/64 bit floating point */
typedef unsigned int    Bool,   *pBool;     /* Boolean (True/False) */
typedef char            Char,   *pChar;     /* character, character array ptr */
typedef char           *String, **pString;  /* Null terminated 8 bit char str, */
                                            /* Null term 8 bit char str ptr */
typedef char const     *ConstString;

#endif // _TMNXTYPES_H_

#undef __inline__
#define __inline__ inline


// Compile code for the ARM host.

typedef volatile       UInt32  vhRegRW32;
typedef volatile       UInt32  vhRegWO32;
typedef volatile const UInt32  vhRegRO32;
typedef volatile       UInt32  vhRegRW16;
typedef volatile       UInt32  vhRegWO16;
typedef volatile const UInt32  vhRegRO16;
typedef volatile       UInt32  vhRegRW8;
typedef volatile       UInt32  vhRegWO8;
typedef volatile const UInt32  vhRegRO8;
typedef volatile       UInt32  *pVPBvoid;

#endif /* ASM_INCLUDE */

#endif /* _VHTYPES_H_ */
