/*
 * drivers/char/mv64360_mpsc.h
 *
 * Author: Mark A. Greer <mgreer@mvista.com>
 *
 * 2004 (c) MontaVista, Software, Inc.  This file is licensed under
 * the terms of the GNU General Public License version 2.  This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#ifndef	__MV64360_MPSC_H
#define	__MV64360_MPSC_H

#include <asm/mv64360.h>

/* Tx/Rx descriptor cmd/status field bits */
#define	SDMA_PE			(1<<0)
#define	SDMA_CDL		(1<<1)
#define	SDMA_CTSL		(1<<1)
#define	SDMA_FR			(1<<3)
#define	SDMA_OR			(1<<6)
#define	SDMA_BR			(1<<9)
#define	SDMA_MI			(1<<10)
#define	SDMA_A			(1<<11)
#define	SDMA_AM			(1<<12)
#define	SDMA_CT			(1<<13)
#define	SDMA_C			(1<<14)
#define	SDMA_ES			(1<<15)
#define	SDMA_L			(1<<16)
#define	SDMA_F			(1<<17)
#define	SDMA_P			(1<<18)
#define	SDMA_TA			(1<<19)
#define	SDMA_NS			(1<<20)
#define	SDMA_EI			(1<<23)
#define	SDMA_AUTO		(1<<30)
#define	SDMA_O			(1<<31)

/* SDCMx Reg bits */
#define	SDCM_ERD		(1<<7)
#define	SDCM_AR			(1<<15)
#define	SDCM_STD		(1<<16)
#define	SDCM_TXD		(1<<23)
#define	SDCM_AT			(1<<31)

#define	MPCR_CL_5		0x00
#define	MPCR_CL_6		0x01
#define	MPCR_CL_7		0x02
#define	MPCR_CL_8		0x03

#define	MPCR_SBL_0		0x00
#define	MPCR_SBL_1		0x01

#define MPSC_CONNECT		0x1
#define MPSC_DISCONNECT         0x0

#define	CHR2_PAR_ODD		0x00
#define	CHR2_PAR_SPACE		0x01
#define	CHR2_PAR_EVEN		0x02
#define	CHR2_PAR_MARK		0x03
#define CHR2_PAR_NONE		-1


#endif	/* __MV64360_MPSC_H */
