/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2002, 2003 Motorola, Inc. All Rights Reserved.
 *
 */

/*MMA_MAC device driver*/
#include <linux/version.h>
#include <linux/module.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/miscdevice.h>
#include <linux/interrupt.h>
#include <linux/tty.h>
#include <linux/tty_flip.h>
#include <linux/config.h>
#include <linux/major.h>
#include <linux/slab.h>
#include <linux/string.h>
#include <linux/fcntl.h>
#include <linux/mm.h>
#include <linux/kernel.h>
#include <linux/console.h>
#include <linux/reboot.h>
#include <linux/keyboard.h>
#include <linux/init.h>

#include <linux/spinlock.h>
#include <asm/hardirq.h>

#include <asm/io.h>
#include <asm/irq.h>
#include <asm/system.h>
#include <asm/segment.h>
#include <asm/bitops.h>
#include <asm/delay.h>
#include <asm/uaccess.h>
#include <asm/dma.h>
#include "Mac.h"

#define MAC_PM
#ifdef MAC_PM
#include <linux/pm.h>
#define PM_OPT " [pm]"
static struct pm_dev *pm;
#endif				// MAC_PM

#define TRUE			1
#define FALSE 			0

#define KAREN_TEST

UINT32 gIntrData;

#if (LINUX_VERSION_CODE < 0x020301)
static struct wait_queue *gMmaMacWaitQueue = NULL;
#else
static wait_queue_head_t gMmaMacWaitQueue;
#endif

/*******************************************************
*MAC macros
* 	
********************************************************/
#define Enable_Mac_Irq(x) (MMA_MAC_INTR_MASK &= (~(x)))
#define Disable_Mac_Irq(x) (MMA_MAC_INTR_MASK |= (x))

#define FUNC_START			printk("\n[%s]:start!\n", __FUNCTION__)
#define FUNC_END			printk("\n[%s]:end!\n", __FUNCTION__)

//here MacDestAddr is global address of MAC driver, x is equal to
//MAC driver buffer, y is the count of bytes read.
#define MAC_READ(x,y,z) copy_to_user((x), (y), (z))

//here x is the kernel device address, y is the user space addr,
//z is the count of data to be transferred
#define MAC_WRITE(x,y,z) 	copy_from_user((void *)(x),(void *)(y),(z))
/**********Macros for X matrix**********/
#define MAC_SET_XBASE(x) 	MMA_MAC_XBASE = (x)
#define MAC_SET_XINDEX(x) 	MMA_MAC_XINDEX = (x)
#define MAC_SET_XLENGTH(x)	MMA_MAC_XLENGTH |= (x)*4
#define MAC_SET_XCOLUMN(x)	MMA_MAC_XLENGTH |= ((x)*4)<<16
#define MAC_SET_XMODIFY(x)	MMA_MAC_XMODIFY = (x)*4
//Here the x is incr value, y is the count value
#define MAC_ENABLE_XRELOAD(x,y)	{MMA_MAC_CTRL |= 0x30000000;MMA_MAC_XINCR = (x)*4;MMA_MAC_XCOUNT = (y)-1}
//here if x=1, means x matrix is signed, else x Matrix should be unsigned value;
//if it is unsigned,then y is its initsign value, 1 means negative,0 means positive;
//z means signalt value, 1 means alternate sign, 0 means not alternate sign.
//Here y&z are valid only when x == 0
#define MAC_SET_XSIGN(x,y,z)	{if(x == 1){MMA_MAC_CTRL |= 0x01000000}else{MMA_MAC_CTRL |= (y<<25)|(z<<26)}}
//if x==1, then bit[23:8] in the 32 bits are valid, else bit[23:0]is valid
//Note here, if the cache is enables, the data select should be set to 0
#define MAC_SET_XSEL(x)		MMA_MAC_CTRL |= (x)<<27

/**********Macros for Y matrix************/
#define MAC_SET_YBASE(x) 	MMA_MAC_YBASE = (x)
#define MAC_SET_YINDEX(x) 	MMA_MAC_YINDEX = (x)
#define MAC_SET_YLENGTH(x)	MMA_MAC_YLENGTH |= (x)*4
#define MAC_SET_YCOLUMN(x)	MMA_MAC_YLENGTH |= ((x)*4)<<16
#define MAC_SET_YMODIFY(x)	MMA_MAC_YMODIFY = (x)*4
//Here the x is incr value, y is the count value
#define MAC_ENABLE_YRELOAD(x,y)	{MMA_MAC_CTRL |= 0x00300000;MMA_MAC_YINCR = (x)*4;MMA_MAC_YCOUNT = (y)-1}
//here if x=1, means y matrix is signed, else y Matrix should be unsigned value;
//if it is unsigned,then y is its initsign value, 1 means negative,0 means positive;
//z means signalt value, 1 means alternate sign, 0 means not alternate sign.
//Here y&z are valid only when x == 0
#define MAC_SET_YSIGN(x,y,z)	{if(x == 1){MMA_MAC_CTRL |= 0x00010000}else{MMA_MAC_CTRL |= (y<<17)|(z<<18)}}

//if x==1, then bit[23:8] in the 32 bits are valid, else bit[23:0]is valid
//Note here, if the cache is enables, the data select should be set to 0
#define MAC_SET_YSEL(x)		MMA_MAC_CTRL |= (x)<<19

unsigned int xphyaddr, yphyaddr, resultphyaddr;
/***********Macros for MAC op**************************/
//0 means bit[31:0] valid,1 means bit[35:4] valid, 2 means bit[39:8] valid, 3 means bit[43:12]valid,
//4 means bit[47:16]valid, 5 means bit[51:20] valid,6 means bit[55:24] valid
#define MAC_SET_BITSEL(x)	MMA_MAC_BIT_SEL = (x)
#define MAC_SET_MULT(x)		MMA_MAC_MULT = (x)
#define MAC_SET_ACCU(x)		MMA_MAC_ACCU = (x)
#define MAC_ENABLE_CACHE	MMA_MAC_CTRL |=  MAC_EN_CACHE
#define MAC_START			MMA_MAC_CTRL |= MAC_EN_OP
#define MAC_SET_DEST_ADDR(x)	gMacDestAddr = (x)

typedef void (*callback_t) (void);
typedef void (*err_callback_t) (int error_type);
void mx1ads_request_dma_intr(dmach_t channel, callback_t dma_callback,
			     err_callback_t dma_err_callback);

/***********Table for MP3 dct64*************************************/
int gMmaMacBufs[512] =
    { 33554432, 33554432, 33554432, 33554432, 33554432, 33554432, 33554432,
33554432, 33554432, 33554432, 33554432, 33554432, 33554432,
	33554432, 33554432, 33554432, 33514014, 33191255, 32548847, 31592976,
	    30332847, 28780596, 26951172, 24862194, 22533779, 19988351,
	    17250425, 14346368, 11304147,
	8153061, 4923457, 1646437, 33392858, 32109589, 29592367, 25937926,
	    21286706, 15817449, 9740337, 3288909, -3288909, -9740337, -15817449,
	    -21286706,
	-25937926, -29592367, -32109589, -33392858, 33191255, 30332847,
	    24862194, 17250425, 8153061, -1646437, -11304147, -19988351,
	    -26951172, -31592976, -33514014, -32548847, -28780596, -22533779,
	    -14346368, -4923457, 32909692, 27899490,
	18641843, 6546144, -6546144, -18641843, -27899490, -32909692, -32909692,
	    -27899490, -18641843, -6546144, 6546144, 18641843, 27899490,
	    32909692, 32548847, 24862194, 11304147, -4923457, -19988351,
	    -30332847, -33514014, -28780596,
	-17250425, -1646437, 14346368, 26951172, 33191255, 31592976, 22533779,
	    8153061, 32109589, 21286706, 3288909, -15817449, -29592367,
	    -33392858, -25937926, -9740337, 9740337, 25937926, 33392858,
	    29592367, 15817449, -3288909,
	-21286706, -32109589, 31592976, 17250425, -4923457, -24862194,
	    -33514014, -26951172, -8153061, 14346368, 30332847, 32548847,
	    19988351, -1646437, -22533779, -33191255, -28780596, -11304147,
	    31000252, 12840725, -12840725, -31000252,
	-31000252, -12840725, 12840725, 31000252, 31000252, 12840725, -12840725,
	    -31000252, -31000252, -12840725, 12840725, 31000252, 30332847,
	    8153061, -19988351, -33514014, -22533779, 4923457, 28780596,
	    31592976, 11304147, -17250425,
	-33191255, -24862194, 1646437, 26951172, 32548847, 14346368, 29592367,
	    3288909, -25937926, -32109589, -9740337, 21286706, 33392858,
	    15817449, -15817449, -33392858, -21286706, 9740337, 32109589,
	    25937926, -3288909, -29592367,
	28780596, -1646437, -30332847, -26951172, 4923457, 31592976, 24862194,
	    -8153061, -32548847, -22533779, 11304147, 33191255, 19988351,
	    -14346368, -33514014, -17250425, 27899490, -6546144, -32909692,
	    -18641843, 18641843, 32909692,
	6546144, -27899490, -27899490, 6546144, 32909692, 18641843, -18641843,
	    -32909692, -6546144, 27899490, 26951172, -11304147, -33514014,
	    -8153061, 28780596, 24862194, -14346368, -33191255, -4923457,
	    30332847, 22533779, -17250425,
	-32548847, -1646437, 31592976, 19988351, 25937926, -15817449, -32109589,
	    3288909, 33392858, 9740337, -29592367, -21286706, 21286706,
	    29592367, -9740337, -33392858, -3288909, 32109589, 15817449,
	    -25937926, 24862194, -19988351,
	-28780596, 14346368, 31592976, -8153061, -33191255, 1646437, 33514014,
	    4923457, -32548847, -11304147, 30332847, 17250425, -26951172,
	    -22533779, 23726566, -23726566, -23726566, 23726566, 23726566,
	    -23726566, -23726566, 23726566,
	23726566, -23726566, -23726566, 23726566, 23726566, -23726566,
	    -23726566, 23726566, 22533779, -26951172, -17250425, 30332847,
	    11304147, -32548847, -4923457, 33514014, -1646437, -33191255,
	    8153061, 31592976, -14346368, -28780596, 19988351, 24862194,
	    21286706,
	-29592367, -9740337, 33392858, -3288909, -32109589, 15817449, 25937926,
	    -25937926, -15817449, 32109589, 3288909, -33392858, 9740337,
	    29592367, -21286706, 19988351, -31592976, -1646437, 32548847,
	    -17250425, -22533779, 30332847, 4923457,
	-33191255, 14346368, 24862194, -28780596, -8153061, 33514014, -11304147,
	    -26951172, 18641843, -32909692, 6546144, 27899490, -27899490,
	    -6546144, 32909692, -18641843, -18641843, 32909692, -6546144,
	    -27899490, 27899490, 6546144, -32909692,
	18641843, 17250425, -33514014, 14346368, 19988351, -33191255, 11304147,
	    22533779, -32548847, 8153061, 24862194, -31592976, 4923457,
	    26951172, -30332847, 1646437, 28780596, 15817449, -33392858,
	    21286706, 9740337, -32109589, 25937926,
	3288909, -29592367, 29592367, -3288909, -25937926, 32109589, -9740337,
	    -21286706, 33392858, -15817449, 14346368, -32548847, 26951172,
	    -1646437, -24862194, 33191255, -17250425, -11304147, 31592976,
	    -28780596, 4923457, 22533779, -33514014,
	19988351, 8153061, -30332847, 12840725, -31000252, 31000252, -12840725,
	    -12840725, 31000252, -31000252, 12840725, 12840725, -31000252,
	    31000252, -12840725, -12840725, 31000252, -31000252, 12840725,
	    11304147, -28780596, 33191255, -22533779,
	1646437, 19988351, -32548847, 30332847, -14346368, -8153061, 26951172,
	    -33514014, 24862194, -4923457, -17250425, 31592976, 9740337,
	    -25937926, 33392858, -29592367, 15817449, 3288909, -21286706,
	    32109589, -32109589, 21286706, -3288909,
	-15817449, 29592367, -33392858, 25937926, -9740337, 8153061, -22533779,
	    31592976, -33191255, 26951172, -14346368, -1646437, 17250425,
	    -28780596, 33514014, -30332847, 19988351, -4923457, -11304147,
	    24862194, -32548847, 6546144, -18641843, 27899490,
	-32909692, 32909692, -27899490, 18641843, -6546144, -6546144, 18641843,
	    -27899490, 32909692, -32909692, 27899490, -18641843, 6546144,
	    4923457, -14346368, 22533779, -28780596, 32548847, -33514014,
	    31592976, -26951172, 19988351, -11304147, 1646437,
	8153061, -17250425, 24862194, -30332847, 33191255, 3288909, -9740337,
	    15817449, -21286706,
	25937926, -29592367, 32109589, -33392858, 33392858, -32109589, 29592367,
	    -25937926, 21286706, -15817449, 9740337, -3288909, 1646437,
	    -4923457,
	8153061, -11304147, 14346368, -17250425, 19988351, -22533779, 24862194,
	    -26951172, 28780596, -30332847, 31592976, -32548847, 33191255,
	    -33514014
};

/***************Variable for MP3 dct64******************************/
unsigned int *dct_x_operand_base_ptr;

SINT32 *gMmaMacDctXBaseAddr;
SINT32 *gMmaMacDctTable;
SINT32 *gMmaMacDctYbase;
#define BUG_FIX
/*******************************************************
*MAC open routine
* return : 0 -- success
*		  - 1 -- fail
********************************************************/
static int
mac_open(struct inode *inode, struct file *file)
{
	int retval;
	int i;
	int *tempaddr;
	if (!gMacAvail)
		return -1;
	gMacAvail = FALSE;
	MOD_INC_USE_COUNT;
	//first reset the MAC module
	MMA_MAC_MOD = 0x80000001;
	memset(&gMmaMacXMatrix, 0, sizeof (struct Matrix));
	memset(&gMmaMacYMatrix, 0, sizeof (struct Matrix));
	memset(&gMmaMacResult, 0, sizeof (struct Matrix));
	for (gMmaMacDmaChannum = 1; gMmaMacDmaChannum < 11; gMmaMacDmaChannum++) {
		if ((retval = request_dma(gMmaMacDmaChannum, "MAC")) == 0) {
			gMacTransMode = MAC_TRANS_DMA;
			gMmaMacDmaFlag = TRUE;
			break;
		} else if (gMmaMacDmaChannum >= 10) {
			gMmaMacDmaFlag = FALSE;
			gMacTransMode = MAC_TRANS_INTR;
		}
	}
	/********For MP3 dct64***********/
	gMmaMacDctTable = 0;

	gMmaMacDctTable = kmalloc(2048, GFP_DMA | GFP_KERNEL);	//allocate memory for dcttable
	if (gMmaMacDctTable == NULL) {
		printk("\nMAC_OPEN:can't malloc memeory");
		return -1;
	} else {
		tempaddr = (int *) gMmaMacDctTable;
		for (i = 0; i < 512; i++) {
			*tempaddr++ = gMmaMacBufs[i];
		}
	}
	gMmaMacDctYbase = 0;
	gMmaMacDctYbase = kmalloc(128, GFP_DMA | GFP_KERNEL);
	if (gMmaMacDctYbase == NULL) {
		printk("\nMAC_OPEN:can't malloc memeory");
		return -1;
	}

	return 0;
}

/*******************************************************
*MAC close routine
* return : 0 -- success
*		  - 1 -- fail
********************************************************/
static int
mac_release(struct inode *inode, struct file *filp)
{
	if (gMacAvail)
		return -1;

	if (gMmaMacDmaFlag) {
		free_dma(gMmaMacDmaChannum);
		gMmaMacDmaFlag = FALSE;
	}

	/********For MP3 dct64********************/
	if (gMmaMacDctTable != NULL) {
		kfree(gMmaMacDctTable);
		gMmaMacDctTable = NULL;
	}
	if (gMmaMacDctYbase != NULL) {
		kfree(gMmaMacDctYbase);
		gMmaMacDctYbase = NULL;
	}
	MMA_MAC_MOD = 0x0;	//disable the module
	MOD_DEC_USE_COUNT;
	gMacAvail = TRUE;
	return 0;
}

/*******************************************************
*MAC const*2D routine
* using interrupt of OP end
* z=x++*y++;z++
********************************************************/
void
mac_dma()
{
	gMmaMacEndFlag = 1;
	disable_dma(gMmaMacDmaChannum);
}

void
mac_const_2D()
{
	unsigned int *tempaddr;
	unsigned int *xAddr;
	unsigned int *yAddr;
	unsigned int *zAddr;
	unsigned int *testaddr;
	int timeout;
	int count, testcount;
	int i;
	gMmaMacEndFlag = 0;
	count = (gMmaMacResult.row) * (gMmaMacResult.col);
	timeout = 0;
	//testcount is used for test infor
	testcount = (gMmaMacResult.row) * (gMmaMacResult.col);
	testaddr = (int *) gMmaMacResult.baseaddr;

	//map the virtual address to physical address
#ifdef BUG_FIX
	xAddr = (int *) xphyaddr;
	yAddr = (int *) yphyaddr;
	zAddr = (int *) resultphyaddr;
#endif
#ifndef BUG_FIX
	xAddr = (int *) virt_to_bus(gMmaMacXMatrix.baseaddr);
	yAddr = (int *) virt_to_bus(gMmaMacYMatrix.baseaddr);
	zAddr = (int *) virt_to_bus(gMmaMacResult.baseaddr);
#endif
	MMA_MAC_XBASE = (UINT32) xAddr;
	MMA_MAC_XINDEX = 0;
	MMA_MAC_XLENGTH = 4;
	MMA_MAC_XMODIFY = 4;
	MMA_MAC_XINCR = 0;
	MMA_MAC_XCOUNT = 0;

	/*Set Y matrix information */
	MMA_MAC_YBASE = (UINT32) yAddr;
	MMA_MAC_YINDEX = gMmaMacYMatrix.index;
	MMA_MAC_YLENGTH = gMmaMacYMatrix.length;
	MMA_MAC_YMODIFY = 4;
	MMA_MAC_YINCR = 0;
	MMA_MAC_YCOUNT = 0;
	/*Set the multiply registers */
	MMA_MAC_MULT = (gMmaMacYMatrix.row) * (gMmaMacYMatrix.col) + 1;
	MMA_MAC_ACCU = 0;
	MMA_MAC_BURST = 0x0000008;
	if (gMmaMacXMatrix.type == 1)	//add for signed operation
	{
		MMA_MAC_CTRL |= 0x01000000;
	}
	if (gMmaMacYMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x00010000;
	}
	tempaddr = (int *) gMmaMacResult.baseaddr;
	switch (gMacTransMode) {
	case MAC_TRANS_POLL:
		//while the operation not finished
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op without enable interrupt

		while (MMA_MAC_CTRL & MAC_EN_OP) {
			while (((MMA_MAC_INTR & MAC_FIFO_FULL_IRQ) == 0x0)
			       && (timeout < 20)) {
				timeout++;
			}
			MMA_MAC_INTR = 0x00000001;
			for (i = 0; i < count; i++) {
				*tempaddr = MMA_MAC_FIFO;
				tempaddr++;
				testcount--;
			}

		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	case MAC_TRANS_INTR:
		//enable op end and fifo full interrupt
		gMacDataRead = (gMmaMacResult.col) * (gMmaMacResult.row);
		Enable_Mac_Irq(MAC_OP_END_IRQ);
		Enable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op with enable interrupt
		while (gMmaMacEndFlag == 0)	//when use if can not wake up
		{
			interruptible_sleep_on(&gMmaMacWaitQueue);
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);

		break;
	case MAC_TRANS_DMA:
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op with enable interrupt
		mx1ads_request_dma_intr(gMmaMacDmaChannum, (callback_t) mac_dma,
					NULL);
		DMA_SAR(gMmaMacDmaChannum) = 0x00222018;	//FIFO address
		DMA_DAR(gMmaMacDmaChannum) = (UINT32) zAddr;	//this is the physical address for result
		DMA_BLR(gMmaMacDmaChannum) = 0x40;	//16 words burst
		DMA_RTOR(gMmaMacDmaChannum) = 0x0;
		DMA_RSSR(gMmaMacDmaChannum) = 11;
		DMA_CNTR(gMmaMacDmaChannum) = count * 4;	//result data number
		DMA_CCR(gMmaMacDmaChannum) = 0x00000808;

		Disable_Mac_Irq(MAC_OP_END_IRQ);
		Disable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		(*((VUINT32 *) (IO_ADDRESS((0x00209008))))) &= (~(1 << gMmaMacDmaChannum));	// gk correction
		DMA_CCR(gMmaMacDmaChannum) = 0x00000809;	//enable DMA transfer
		/*Now use poll to check if the DMA finish */
		while (gMmaMacEndFlag == 0) {
		   udelay(1);
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);

		break;
	default:
		break;
	}
}

/*******************************************************
*MAC 1D*1D routine
* using interrupt of OP end
* z=x++*y++;z++
********************************************************/
void
mac_1D_1D()
{
	unsigned int *tempaddr;
	unsigned int *xAddr;
	unsigned int *yAddr;
	unsigned int *zAddr;
	unsigned int *testaddr;
	int timeout;
	int count, testcount;
	int i;
	gMmaMacEndFlag = 0;
	timeout = 0;
	count = (gMmaMacResult.col) * (gMmaMacResult.row);
	testcount = count;
	//first reset the MAC module
	MMA_MAC_MOD = 0x80000001;
	//map the virtual address to physical address
#ifdef BUG_FIX
	xAddr = (int *) xphyaddr;
	yAddr = (int *) yphyaddr;
	zAddr = (int *) resultphyaddr;
#endif
#ifndef BUG_FIX
	xAddr = (int *) virt_to_bus(gMmaMacXMatrix.baseaddr);
	yAddr = (int *) virt_to_bus(gMmaMacYMatrix.baseaddr);
	zAddr = (int *) virt_to_bus(gMmaMacResult.baseaddr);
#endif
	MMA_MAC_XBASE = (UINT32) xAddr;
	MMA_MAC_XINDEX = 0;
	MMA_MAC_XLENGTH = gMmaMacXMatrix.length;
	MMA_MAC_XMODIFY = 4;
	MMA_MAC_XINCR = 0;
	MMA_MAC_XCOUNT = 0;

	/*Set Y matrix information */
	MMA_MAC_YBASE = (UINT32) yAddr;
	MMA_MAC_YINDEX = 0;
	MMA_MAC_YLENGTH = gMmaMacYMatrix.length;
	MMA_MAC_YMODIFY = 4;
	MMA_MAC_YINCR = 0;
	MMA_MAC_YCOUNT = 0;
	/*Set the multiply registers */
	MMA_MAC_BURST = 0x0000008;
	MMA_MAC_MULT = (gMmaMacXMatrix.length) / 4 + 1;
	MMA_MAC_ACCU = 0x0;
	tempaddr = (int *) gMmaMacResult.baseaddr;

	testaddr = (int *) gMmaMacResult.baseaddr;
	if (gMmaMacXMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x01000000;
	}
	if (gMmaMacYMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x00010000;
	}

	switch (gMacTransMode) {
	case MAC_TRANS_POLL:
		//while the operation not finished
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op without enable interrupt
		while (MMA_MAC_CTRL & MAC_EN_OP) {
			while (((MMA_MAC_INTR & MAC_FIFO_FULL_IRQ) == 0x0)
			       && (timeout < 20)) {
				timeout++;
			}
			MMA_MAC_INTR = 0x00000001;
			for (i = 0; i < count; i++) {
				*tempaddr = MMA_MAC_FIFO;
				tempaddr++;
				testcount--;
			}
		}

		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);

		break;
	case MAC_TRANS_INTR:
		//enable op end and fifo full interrupt
		gMacDataRead = (gMmaMacResult.col) * (gMmaMacResult.row);
		Enable_Mac_Irq(MAC_OP_END_IRQ);
		Enable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op with enable interrupt
		while (gMmaMacEndFlag == 0)	//when use if can not wake up
		{
			interruptible_sleep_on(&gMmaMacWaitQueue);
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	case MAC_TRANS_DMA:
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op with enable interrupt
		mx1ads_request_dma_intr(gMmaMacDmaChannum, (callback_t) mac_dma,
					NULL);
		DMA_SAR(gMmaMacDmaChannum) = 0x00222018;	//FIFO address
		DMA_DAR(gMmaMacDmaChannum) = (UINT32) zAddr;	//this is the physical address for result
		DMA_BLR(gMmaMacDmaChannum) = 0x40;	//16 words burst
		DMA_RTOR(gMmaMacDmaChannum) = 0x0;
		DMA_RSSR(gMmaMacDmaChannum) = 11;
		DMA_CNTR(gMmaMacDmaChannum) = count * 4;	//result data number
		DMA_CCR(gMmaMacDmaChannum) = 0x00000808;
		(*((VUINT32 *) (IO_ADDRESS((0x00209008))))) &= (~(1 << gMmaMacDmaChannum));	// gk correction
		DMA_CCR(gMmaMacDmaChannum) = 0x00000809;	//enable DMA transfer
		/*Now use poll to check if the DMA finish */
		while (gMmaMacEndFlag == 0) {
			udelay(1);
			timeout++;
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	default:
		break;

	}

}

/*******************************************************
*MAC 1D*1D routine
* using interrupt of OP end
* z+=x--*y++;
********************************************************/
void
mac_dec1D_1D()
{
	unsigned int *tempaddr;
	unsigned int *xAddr;
	unsigned int *yAddr;
	unsigned int *zAddr;
	unsigned int *testaddr;
	int timeout;
	int count, testcount;
	int i;
	gMmaMacEndFlag = 0;
	//first reset the MAC module
	MMA_MAC_MOD = 0x80000001;
	//map the virtual address to physical address
#ifdef BUG_FIX
	xAddr = (int *) xphyaddr;
	yAddr = (int *) yphyaddr;
	zAddr = (int *) resultphyaddr;
#endif
#ifndef BUG_FIX
	xAddr = (int *) virt_to_bus(gMmaMacXMatrix.baseaddr);
	yAddr = (int *) virt_to_bus(gMmaMacYMatrix.baseaddr);
	zAddr = (int *) virt_to_bus(gMmaMacResult.baseaddr);
#endif
	timeout = 0;
	count = (gMmaMacResult.col) * (gMmaMacResult.row);
	testcount = count;
	MMA_MAC_XBASE = (UINT32) xAddr;
	MMA_MAC_XINDEX = gMmaMacXMatrix.length - 4;
	MMA_MAC_XLENGTH = gMmaMacXMatrix.length;
	MMA_MAC_XMODIFY = gMmaMacXMatrix.length - 4;
	MMA_MAC_XINCR = 0;
	MMA_MAC_XCOUNT = 0;

	/*Set Y matrix information */
	MMA_MAC_YBASE = (UINT32) yAddr;
	MMA_MAC_YINDEX = 0;
	MMA_MAC_YLENGTH = gMmaMacYMatrix.length;
	MMA_MAC_YMODIFY = 4;
	MMA_MAC_YINCR = 0;
	MMA_MAC_YCOUNT = 0;
	/*Set the multiply registers */
	MMA_MAC_BURST = 0x0000008;
	MMA_MAC_MULT = ((gMmaMacXMatrix.length) / 4) + 1;
	MMA_MAC_ACCU = (gMmaMacXMatrix.length) / 4 - 1;

	tempaddr = (int *) gMmaMacResult.baseaddr;

	testaddr = (int *) gMmaMacResult.baseaddr;
	if (gMmaMacXMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x01000000;
	}
	if (gMmaMacYMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x00010000;
	}

	switch (gMacTransMode) {
	case MAC_TRANS_POLL:
		//while the operation not finished
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op without enable interrupt
		while (MMA_MAC_CTRL & MAC_EN_OP) {
			while (((MMA_MAC_INTR & MAC_FIFO_FULL_IRQ) == 0x0)
			       && (timeout < 20)) {
				timeout++;
			}
			for (i = 0; i < count; i++) {
				*tempaddr = MMA_MAC_FIFO;
				tempaddr++;
				testcount--;
			}
			MMA_MAC_INTR = 0x00000001;
		}

		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	case MAC_TRANS_INTR:
		//enable op end and fifo full interrupt
		gMacDataRead = (gMmaMacResult.col) * (gMmaMacResult.row);
		Enable_Mac_Irq(MAC_OP_END_IRQ);
		Enable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op with enable interrupt
		while (gMmaMacEndFlag == 0)	//when use if can not wake up
		{
			interruptible_sleep_on(&gMmaMacWaitQueue);
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	case MAC_TRANS_DMA:
		MMA_MAC_CTRL |= MAC_EN_OP;	//start op with enable interrupt
		mx1ads_request_dma_intr(gMmaMacDmaChannum, (callback_t) mac_dma,
					NULL);
		DMA_SAR(gMmaMacDmaChannum) = 0x00222018;	//FIFO address
		DMA_DAR(gMmaMacDmaChannum) = (UINT32) zAddr;	//this is the physical address for result
		DMA_BLR(gMmaMacDmaChannum) = 0x40;	//16 words burst
		DMA_RTOR(gMmaMacDmaChannum) = 0x0;
		DMA_RSSR(gMmaMacDmaChannum) = 11;
		DMA_CNTR(gMmaMacDmaChannum) = count * 4;	//result data number
		DMA_CCR(gMmaMacDmaChannum) = 0x00000808;
		(*((VUINT32 *) (IO_ADDRESS((0x00209008))))) &= (~(1 << gMmaMacDmaChannum));	// gk correction
		DMA_CCR(gMmaMacDmaChannum) = 0x00000809;	//enable DMA transfer
		/*Now use poll to check if the DMA finish */
		while (gMmaMacEndFlag == 0) {
			udelay(1);
			timeout++;
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	default:
		break;

	}

}

/*******************************************************
*MAC 1D*2D routine the yMatrix is stored horizontal
*xMatrix.row is the number of element in Matrix, its col is 1
*using interrupt of OP end
* z+=x++*y++;
********************************************************/
void
mac_1D_2D()
{

	unsigned int *tempaddr;
	unsigned int *xAddr;
	unsigned int *yAddr;
	unsigned int *zAddr;
	unsigned int *testaddr;
	int timeout;
	int count, testcount;
	int i;
	gMmaMacEndFlag = 0;
	//first reset the MAC module
	MMA_MAC_MOD = 0x80000001;
	//map the virtual address to physical address
#ifdef BUG_FIX
	xAddr = (int *) xphyaddr;
	yAddr = (int *) yphyaddr;
	zAddr = (int *) resultphyaddr;
#endif
#ifndef BUG_FIX
	xAddr = (int *) virt_to_bus(gMmaMacXMatrix.baseaddr);
	yAddr = (int *) virt_to_bus(gMmaMacYMatrix.baseaddr);
	zAddr = (int *) virt_to_bus(gMmaMacResult.baseaddr);
#endif
	timeout = 0;
	count = (gMmaMacResult.col) * (gMmaMacResult.row);
	testcount = count;
	//map the virtual address to physical address
	MMA_MAC_XBASE = (UINT32) xAddr;
	MMA_MAC_XINDEX = gMmaMacXMatrix.index;
	MMA_MAC_XLENGTH = gMmaMacXMatrix.length;
	MMA_MAC_XMODIFY = 4;
	MMA_MAC_XINCR = 0;
	MMA_MAC_XCOUNT = gMmaMacXMatrix.col - 1;

	/*Set Y matrix information */
	MMA_MAC_YBASE = (UINT32) yAddr;
	MMA_MAC_YINDEX = gMmaMacYMatrix.index;
//      MMA_MAC_YLENGTH = ((gMmaMacYMatrix.col)*4)<<16 + gMmaMacYMatrix.length;
//      temp = (gMmaMacYMatrix.col)<<20;
	MMA_MAC_YLENGTH = gMmaMacYMatrix.length;
	MMA_MAC_YMODIFY = (gMmaMacYMatrix.col) * 4;
	MMA_MAC_YINCR = 4;
	MMA_MAC_YCOUNT = gMmaMacYMatrix.row - 1;
	/*Set the multiply registers */
	MMA_MAC_BURST = 0x0000008;
	MMA_MAC_MULT = (gMmaMacYMatrix.row) * (gMmaMacYMatrix.col) + 1;
	MMA_MAC_ACCU = (gMmaMacYMatrix.row) - 1;

	tempaddr = (int *) gMmaMacResult.baseaddr;

	testaddr = (int *) gMmaMacResult.baseaddr;
	if (gMmaMacXMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x01000000;
	}
	if (gMmaMacYMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x00010000;
	}

	switch (gMacTransMode) {
	case MAC_TRANS_POLL:
		//while the operation not finished
		MMA_MAC_CTRL |=
		    MAC_EN_XLOAD | MAC_EN_YINCR | MAC_EN_YLOAD | MAC_EN_OP;

		while (((MMA_MAC_INTR & MAC_OP_END_IRQ) == 0x0)
		       && (timeout < 20)) {
			timeout++;
		}
		MMA_MAC_INTR = 0xffffffff;
		for (i = 0; i < count; i++) {
			*tempaddr = MMA_MAC_FIFO;
			tempaddr++;
			testcount--;
		}

		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	case MAC_TRANS_INTR:
		//enable op end and fifo full interrupt
		gMacDataRead = (gMmaMacResult.col) * (gMmaMacResult.row);
		Enable_Mac_Irq(MAC_OP_END_IRQ);
		Enable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		MMA_MAC_CTRL |=
		    MAC_EN_XLOAD | MAC_EN_YINCR | MAC_EN_YLOAD | MAC_EN_OP;
		while (gMmaMacEndFlag == 0)	//when use if can not wake up
		{
			interruptible_sleep_on(&gMmaMacWaitQueue);
		}

		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	case MAC_TRANS_DMA:
		MMA_MAC_CTRL |=
		    MAC_EN_XLOAD | MAC_EN_YINCR | MAC_EN_YLOAD | MAC_EN_OP;
		mx1ads_request_dma_intr(gMmaMacDmaChannum, (callback_t) mac_dma,
					NULL);
		DMA_SAR(gMmaMacDmaChannum) = 0x00222018;	//FIFO address
		DMA_DAR(gMmaMacDmaChannum) = (UINT32) zAddr;	//this is the physical address for result
		DMA_BLR(gMmaMacDmaChannum) = 0x40;	//16 words burst
		DMA_RTOR(gMmaMacDmaChannum) = 0x0;
		DMA_RSSR(gMmaMacDmaChannum) = 11;
		DMA_CNTR(gMmaMacDmaChannum) = count * 4;	//result data number
		DMA_CCR(gMmaMacDmaChannum) = 0x00000808;
		(*((VUINT32 *) (IO_ADDRESS((0x00209008))))) &= (~(1 << gMmaMacDmaChannum));	// gk correction
		DMA_CCR(gMmaMacDmaChannum) = 0x00000809;	//enable DMA transfer
		/*Now use poll to check if the DMA finish */
		while (gMmaMacEndFlag == 0) {
			udelay(1);
			timeout++;
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);

		break;
	default:
		break;

	}

}

/*******************************************************
*MAC 2D*2D routine
* using interrupt of OP end
* z+=x++*y++;
********************************************************/
void
mac_2D_2D()
{
	unsigned int *tempaddr;
	unsigned int *xAddr;
	unsigned int *yAddr;
	unsigned int *zAddr;
	unsigned int *testaddr;
	int timeout;
	int count, testcount;
	int i;
	UINT32 temp;
	gMmaMacEndFlag = 0;
	//first reset the MAC module
	MMA_MAC_MOD = 0x80000001;
#ifdef BUG_FIX
	xAddr = (int *) xphyaddr;
	yAddr = (int *) yphyaddr;
	zAddr = (int *) resultphyaddr;
#endif
#ifndef BUG_FIX
	xAddr = (int *) virt_to_bus(gMmaMacXMatrix.baseaddr);
	yAddr = (int *) virt_to_bus(gMmaMacYMatrix.baseaddr);
	zAddr = (int *) virt_to_bus(gMmaMacResult.baseaddr);
#endif
	timeout = 0;
	count = (gMmaMacResult.col) * (gMmaMacResult.row);
	testcount = count;

	MMA_MAC_XBASE = (UINT32) xAddr;
	MMA_MAC_XINDEX = gMmaMacXMatrix.index;
	MMA_MAC_XLENGTH = gMmaMacXMatrix.length;
	MMA_MAC_XMODIFY = 4;
	MMA_MAC_XINCR = (gMmaMacXMatrix.col) * 4;
	MMA_MAC_XCOUNT = ((gMmaMacYMatrix.row) * (gMmaMacYMatrix.col)) - 1;

	/*Set Y matrix information */
	MMA_MAC_YBASE = (UINT32) yAddr;
	MMA_MAC_YINDEX = gMmaMacYMatrix.index;
	temp = ((gMmaMacYMatrix.col) * 4) << 16;
	MMA_MAC_YLENGTH = temp + gMmaMacYMatrix.length;
	MMA_MAC_YMODIFY = (gMmaMacYMatrix.col) * 4;
	MMA_MAC_YINCR = 4;
	MMA_MAC_YCOUNT = gMmaMacYMatrix.row - 1;

	/*Set the multiply registers */
	MMA_MAC_BURST = 0x0000008;
	MMA_MAC_MULT =
	    (gMmaMacXMatrix.row) * (gMmaMacYMatrix.row) * (gMmaMacYMatrix.col) +
	    1;
	MMA_MAC_ACCU = (gMmaMacYMatrix.row) - 1;

	tempaddr = (int *) gMmaMacResult.baseaddr;

	testaddr = (int *) gMmaMacResult.baseaddr;
	if (gMmaMacXMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x01000000;
	}
	if (gMmaMacYMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x00010000;
	}
	switch (gMacTransMode) {
	case MAC_TRANS_POLL:
		//while the operation not finished
		MMA_MAC_CTRL |= 0x30300001;
		while (((MMA_MAC_CTRL & MAC_EN_OP) == 0x1) && (timeout < 20)) {
			timeout++;
		}

		for (i = 0; i < count; i++) {
			*tempaddr = MMA_MAC_FIFO;
			tempaddr++;
			testcount--;
		}

		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	case MAC_TRANS_INTR:
		//enable op end and fifo full interrupt
		//enable op end and fifo full interrupt
		Enable_Mac_Irq(MAC_OP_END_IRQ);
		Enable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		gMacDataRead = (gMmaMacResult.col) * (gMmaMacResult.row);
		Enable_Mac_Irq(MAC_OP_END_IRQ);
		Enable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		MMA_MAC_CTRL |= 0x30300001;
		while (gMmaMacEndFlag == 0)	//when use if can not wake up
		{
			interruptible_sleep_on(&gMmaMacWaitQueue);
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	case MAC_TRANS_DMA:
		MMA_MAC_CTRL |= 0x30300001;
		mx1ads_request_dma_intr(gMmaMacDmaChannum, (callback_t) mac_dma,
					NULL);
		DMA_SAR(gMmaMacDmaChannum) = 0x00222018;	//FIFO address
		DMA_DAR(gMmaMacDmaChannum) = (UINT32) zAddr;	//this is the physical address for result
		DMA_BLR(gMmaMacDmaChannum) = 0x40;	//16 words burst
		DMA_RTOR(gMmaMacDmaChannum) = 0x0;
		DMA_RSSR(gMmaMacDmaChannum) = 11;
		DMA_CNTR(gMmaMacDmaChannum) = count * 4;	//result data number
		DMA_CCR(gMmaMacDmaChannum) = 0x00000808;
		(*((VUINT32 *) (IO_ADDRESS((0x00209008))))) &= (~(1 << gMmaMacDmaChannum));	// gk correction
		DMA_CCR(gMmaMacDmaChannum) = 0x00000809;	//enable DMA transfer
		/*Now use poll to check if the DMA finish */
		while (gMmaMacEndFlag == 0) {
			udelay(1);
			timeout++;
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	default:
		break;

	}

}

/*******************************************************
*MAC block scale routine
* using interrupt of OP end
* z=x*y++; x++
********************************************************/
void
mac_scale()
{
	unsigned int *tempaddr;
	unsigned int *xAddr;
	unsigned int *yAddr;
	unsigned int *zAddr;
	unsigned int *testaddr;
	int timeout;
	int count, testcount;
	int i;
	gMmaMacEndFlag = 0;
	//first reset the MAC module
	MMA_MAC_MOD = 0x80000001;
	//map the virtual address to physical address
#ifdef BUG_FIX
	xAddr = (int *) xphyaddr;
	yAddr = (int *) yphyaddr;
	zAddr = (int *) resultphyaddr;
#endif
#ifndef BUG_FIX
	xAddr = (int *) virt_to_bus(gMmaMacXMatrix.baseaddr);
	yAddr = (int *) virt_to_bus(gMmaMacYMatrix.baseaddr);
	zAddr = (int *) virt_to_bus(gMmaMacResult.baseaddr);
#endif
	timeout = 0;
	count = (gMmaMacResult.col) * (gMmaMacResult.row);
	testcount = count;
	MMA_MAC_XBASE = (UINT32) xAddr;
	MMA_MAC_XINDEX = gMmaMacXMatrix.index;
	MMA_MAC_XLENGTH = gMmaMacXMatrix.length;
	MMA_MAC_XMODIFY = 0;
	MMA_MAC_XINCR = 4;
	MMA_MAC_XCOUNT = (gMmaMacYMatrix.col) - 1;

	/*Set Y matrix information */
	MMA_MAC_YBASE = (UINT32) yAddr;
	MMA_MAC_YINDEX = gMmaMacYMatrix.index;
	MMA_MAC_YLENGTH = gMmaMacYMatrix.length;
	MMA_MAC_YMODIFY = 4;
	MMA_MAC_YINCR = 0;
	MMA_MAC_YCOUNT = 0;
	/*Set the multiply registers */
	MMA_MAC_MULT = (gMmaMacYMatrix.row) * (gMmaMacYMatrix.col) + 1;
	MMA_MAC_ACCU = 0;

	tempaddr = (int *) gMmaMacResult.baseaddr;

	testaddr = (int *) gMmaMacResult.baseaddr;
	if (gMmaMacXMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x01000000;
	}
	if (gMmaMacYMatrix.type == 1) {
		MMA_MAC_CTRL |= 0x00010000;
	}
	switch (gMacTransMode) {
	case MAC_TRANS_POLL:
		//while the operation not finished
		MMA_MAC_CTRL |=
		    MAC_EN_OP | MAC_EN_XLOAD | MAC_EN_XINCR | MAC_EN_CACHE;
		while (MMA_MAC_CTRL & MAC_EN_OP) {
			while (((MMA_MAC_INTR & MAC_FIFO_FULL_IRQ) == 0x0)
			       && (timeout < 20)) {
				timeout++;
			}
			for (i = 0; i < count; i++) {
				*tempaddr = MMA_MAC_FIFO;
				tempaddr++;
				testcount--;
			}
			MMA_MAC_INTR = 0x00000001;
		}

		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);

		break;
	case MAC_TRANS_INTR:
		//enable op end and fifo full interrupt
		Enable_Mac_Irq(MAC_OP_END_IRQ);
		Enable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		gMacDataRead = (gMmaMacResult.col) * (gMmaMacResult.row);
		Enable_Mac_Irq(MAC_OP_END_IRQ);
		Enable_Mac_Irq(MAC_FIFO_FULL_IRQ);
		MMA_MAC_CTRL |=
		    MAC_EN_OP | MAC_EN_XLOAD | MAC_EN_XINCR | MAC_EN_CACHE;
		while (gMmaMacEndFlag == 0)	//when use if can not wake up
		{
			interruptible_sleep_on(&gMmaMacWaitQueue);
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);

		break;
	case MAC_TRANS_DMA:
		MMA_MAC_CTRL |=
		    MAC_EN_OP | MAC_EN_XLOAD | MAC_EN_XINCR | MAC_EN_CACHE;
		mx1ads_request_dma_intr(gMmaMacDmaChannum, (callback_t) mac_dma,
					NULL);
		DMA_SAR(gMmaMacDmaChannum) = 0x00222018;	//FIFO address
		DMA_DAR(gMmaMacDmaChannum) = (UINT32) zAddr;	//this is the physical address for result
		DMA_BLR(gMmaMacDmaChannum) = 0x40;	//16 words burst
		DMA_RTOR(gMmaMacDmaChannum) = 0x0;
		DMA_RSSR(gMmaMacDmaChannum) = 11;
		DMA_CNTR(gMmaMacDmaChannum) = count * 4;	//result data number
		DMA_CCR(gMmaMacDmaChannum) = 0x00000808;
		(*((VUINT32 *) (IO_ADDRESS((0x00209008))))) &= (~(1 << gMmaMacDmaChannum));	// gk correction
		DMA_CCR(gMmaMacDmaChannum) = 0x00000809;	//enable DMA transfer
		/*Now use poll to check if the DMA finish */
		while (gMmaMacEndFlag == 0) {
			udelay(1);
			timeout++;
		}
		MAC_READ(gMmaMacResultAddr, testaddr, count * 4);
		break;
	default:
		break;

	}
}

/*********************************************************************
**  This Function will configure the DSPA for                       **
**  DCT 16 x 16 Matrix Multiplication                               **
**  Using the cached data already preloaded in the X cache          **
**                                                                  **
**  The X base Address is always restore to the preprogrammed value **
**  so as to utilise the cache.                                     **
**  However, note that the actually physical location is not        **
**  accessed and is used for something else.                        **
**                                                                  **
**  To save on the MIPS, since the this function is call upon       **
**  One after another by mma_mac_dct64                              **
**  Then only need to programme minimum registers that need to      **
**  change values.                                                  **
*********************************************************************/

void
mma_mac_dct_16x16_config(UINT32 * y_operand, int odd)
{
	// Clear all Interrupt.
	// Always use the copied base address of the cache.
	if (odd)		// Odd Table base will add 0x40 physical address
	{
		MMA_MAC_XBASE =
		    (UINT32) virt_to_bus(dct_x_operand_base_ptr) + 0x40;
	} else			// Even - Initial Setup
	{
		MMA_MAC_XBASE = (UINT32) virt_to_bus(dct_x_operand_base_ptr);
	}
	// Registers that needs to be reconfigured.
	MMA_MAC_XINDEX = 0x0;
	MMA_MAC_XLENGTH = 0x00000800;
	MMA_MAC_XMODIFY = 0x00000004;
	MMA_MAC_XINCR = 0x0000080;
	MMA_MAC_XCOUNT = 16 - 1;

	MMA_MAC_YBASE = (UINT32) virt_to_bus(y_operand);
	MMA_MAC_YINDEX = 0x0;
	MMA_MAC_YLENGTH = 0x00000040;
	MMA_MAC_YMODIFY = 0x00000004;	// increment by 4

	MMA_MAC_ACCU = 16 - 1;
	MMA_MAC_MULT = 16 * 16 + 1;

	// Select [47:16]
	MMA_MAC_BIT_SEL = 0x00000005;

	// Signed X and Y operand Multiplication
	// 1-D x 2-D automatic reload and increment
	// Enable Cache and use the cache copy for X_operand
	// Do not clear the cache.
	MMA_MAC_CTRL = 0x39010001;
}

/*
* This function is used to Make DCT change fro Appliation layer
*/
void
mma_mac_dct64(struct MAC_DCT64 macdct)
{
	int dctOutPut[0x110];
	int dctInPut[32];
	register int sample1, sample2;
	int i;
	int timeout;
	/*Construct DCT Table Ptr */
	dct_x_operand_base_ptr = (unsigned int *) gMmaMacDctTable;

	//Copy Input from Application
	MAC_WRITE(dctInPut, macdct.ybase, macdct.ysize * 4);

	//Construct input to  2'D array
	for (i = 0; i < 16; i++) {
		sample1 = dctInPut[i];
		sample2 = dctInPut[31 - i];
		gMmaMacDctYbase[i] = (sample1 + sample2);
		gMmaMacDctYbase[16 + i] = (sample1 - sample2);
	}

	//Even Update
	mma_mac_dct_16x16_config(gMmaMacDctYbase, 0);

	//check the first result
	timeout = 0;
	while (((MMA_MAC_CTRL & MAC_EN_OP) == 0x1) && (timeout < 32768)) {
		timeout++;
	}
	for (i = 0; i < 16; i++) {
		dctOutPut[i] = MMA_MAC_FIFO;
	}
	//Odd Caculate
	mma_mac_dct_16x16_config(gMmaMacDctYbase + 16, 1);
	//check the second result
	timeout = 0;
	while (((MMA_MAC_CTRL & MAC_EN_OP) == 0x1) && (timeout < 32768)) {
		timeout++;
	}
	for (i = 16; i < 32; i++) {
		dctOutPut[i] = MMA_MAC_FIFO;
	}
	MAC_READ(macdct.resultbase, dctOutPut, 128);
}

/*MAC ioctl routine */
static int
mac_ioctl(struct inode *inode, struct file *filp, u_int cmd, u_long arg)
{
	UINT32 tempaddr;
	struct MAC_DCT64 temp1;
	switch (cmd) {
	case MAC_CMD_SCALE:
		mac_scale();
		break;
	case MAC_CMD_2D_2D:
		mac_2D_2D();
		break;
	case MAC_CMD_1D_2D:
		mac_1D_2D();
		break;
	case MAC_CMD_1D_DEC:
		mac_dec1D_1D();
		break;
	case MAC_CMD_1D_1D:
		mac_1D_1D();
		break;
	case MAC_CMD_CONST_2D:
		mac_const_2D();
		break;
	case MAC_CMD_SET_XMATRIX:
		if (gMmaMacXMatrix.baseaddr != 0x0) {
#ifdef BUG_FIX
			consistent_free(gMmaMacXMatrix.baseaddr,
					gMmaMacXMatrix.length, xphyaddr);
#endif
#ifndef BUG_FIX
			kfree(gMmaMacXMatrix.baseaddr);
			gMmaMacXMatrix.baseaddr = NULL;
#endif
		}

		MAC_WRITE(&gMmaMacXMatrix, arg, sizeof (struct Matrix));
#ifdef BUG_FIX
		tempaddr =
		    (unsigned int) consistent_alloc(GFP_KERNEL | GFP_DMA,
						    gMmaMacXMatrix.length,
						    &xphyaddr);
#endif
#ifndef BUG_FIX
		tempaddr = (UINT32) kmalloc(gMmaMacXMatrix.length, GFP_KERNEL);
#endif
		MAC_WRITE(tempaddr, gMmaMacXMatrix.baseaddr,
			  gMmaMacXMatrix.length);
		gMmaMacXMatrix.baseaddr = (UINT32 *) tempaddr;
		break;

	case MAC_CMD_SET_YMATRIX:
		if (gMmaMacYMatrix.baseaddr != 0x0) {
#ifdef BUG_FIX
			consistent_free(gMmaMacYMatrix.baseaddr,
					gMmaMacYMatrix.length, yphyaddr);
#endif
#ifndef BUG_FIX
			kfree(gMmaMacYMatrix.baseaddr);
			gMmaMacYMatrix.baseaddr = NULL;
#endif
		}
		MAC_WRITE(&gMmaMacYMatrix, arg, sizeof (struct Matrix));
#ifdef BUG_FIX
		tempaddr =
		    (unsigned int) consistent_alloc(GFP_KERNEL | GFP_DMA,
						    gMmaMacYMatrix.length,
						    &yphyaddr);
#endif
#ifndef BUG_FIX
		tempaddr = (UINT32) kmalloc(gMmaMacYMatrix.length, GFP_KERNEL);
#endif
		MAC_WRITE(tempaddr, gMmaMacYMatrix.baseaddr,
			  gMmaMacYMatrix.length);
		gMmaMacYMatrix.baseaddr = (UINT32 *) tempaddr;
		break;

	case MAC_CMD_SET_RESULT:
		if (gMmaMacResult.baseaddr != 0x0) {
#ifdef BUG_FIX
			consistent_free(gMmaMacResult.baseaddr,
					gMmaMacResult.length,
					(unsigned int) resultphyaddr);
#endif
#ifndef BUG_FIX
			kfree(gMmaMacResult.baseaddr);
			gMmaMacResult.baseaddr = NULL;
#endif
		}
		MAC_WRITE(&gMmaMacResult, arg, sizeof (struct Matrix));
		gMmaMacResultAddr = gMmaMacResult.baseaddr;
#ifdef BUG_FIX
		tempaddr =
		    (unsigned int) consistent_alloc(GFP_KERNEL | GFP_DMA,
						    gMmaMacResult.length,
						    &resultphyaddr);
#endif
#ifndef BUG_FIX
		tempaddr = (UINT32) kmalloc(gMmaMacResult.length, GFP_KERNEL);
#endif
		gMmaMacResult.baseaddr = (UINT32 *) tempaddr;
		memset(gMmaMacResult.baseaddr, 0, gMmaMacResult.length);
		gMmaMacResult.ppos = (UINT32 *) tempaddr;
		break;

	case MAC_CMD_DCT64:
		MAC_WRITE(&temp1, arg, sizeof (struct MAC_DCT64));
		mma_mac_dct64(temp1);
		break;

	default:
		break;
	}

	return 0;
}

void
mac_isr(UINT16 irq, void *dev_id, struct pt_regs *regs)
{
	int i;
	gIntrData = MMA_MAC_INTR;
	if (gIntrData & MAC_FIFO_FULL_IRQ) {
		MMA_MAC_INTR |= MAC_FIFO_FULL_IRQ;
		printk("fifo full inter \n");
		//      here should get how many number of data need be transferred
		for (i = 0; i < 32; i++) {
			//here need to transfer the result to the destAddr with the matrix struct
			//tempAddr = virt_to_bus(gMmaMacResult.baseaddr);
			*(gMmaMacResult.ppos) = MMA_MAC_FIFO;
			(gMmaMacResult.ppos)++;
			gMacDataRead--;
		}
	}

	else if (gIntrData & MAC_OP_END_IRQ) {
		MMA_MAC_INTR |= MAC_OP_END_IRQ;
		for (i = 0; i < gMacDataRead; i++) {
			*(gMmaMacResult.ppos) = MMA_MAC_FIFO;
			(gMmaMacResult.ppos)++;
		}
		gMacDataRead = 0;
		gMmaMacEndFlag = 1;
		wake_up_interruptible(&gMmaMacWaitQueue);
	}
}

int
mma_mac_pm_handler(struct pm_dev *dev, pm_request_t rqst, void *data)
{
	switch (rqst) {
	case PM_RESUME:
		//printk("PM resumed in mma mac driver. \n");
		MMA_MAC_MOD = 0x80000001;	//disable the module

		break;
	case PM_SUSPEND:
		//printk("PM suspended in mma mac driver. \n");
		MMA_MAC_MOD = 0x0;	//disable the module
		break;
	default:
		break;
	}
	return 0;
}

/************************************************************************
 * 	Init/Cleanup Module, for module operation
 ************************************************************************/
//#ifdef MODULE
MODULE_DESCRIPTION("MAC Module");
//MODULE_PARM(mac_debug, "i");
//MODULE_PARM_DESC(mac_debug,"debug level");
MODULE_LICENSE("GPL");

/************************************************************
* provide some device operation for test
*************************************************************/

struct file_operations mac_fops = {
	read:NULL,
	poll:NULL,
	ioctl:mac_ioctl,
	open:mac_open,
	release:mac_release,
};
/*******************************************************
*MMA init function
*Parameters:None
*Return	
*	0	indicates SUCCESS
* 	-1	indicates FAILURE
* 	
********************************************************/
static devfs_handle_t devfs_handle;
//SINT16 __init mac_init(void)
SINT16
mac_init(void)
{
	int tmp;
	int result;

	printk("\nMMA DRIVER START\n");
	/*Initialize its global variable */
	gMacAvail = TRUE;

	/*Request for MAC ISR handler */
	tmp = request_irq(MAC_IRQ,
			  (void *) mac_isr, MAC_INTR_MODE, "mac_Mx1", NULL);
	if (tmp < 0) {
		printk(KERN_ERR "mac driver ERROR: NO irq %d", tmp);
		return tmp;
	}
	init_waitqueue_head(&gMmaMacWaitQueue);

	//Register to char device tab

	result = devfs_register_chrdev(0, "mac", &mac_fops);
	if (result < 0) {
		printk(KERN_ERR
		       "mac driver ERROR: Unable to register driver\n");
		return -ENODEV;
	}
	devfs_handle = devfs_register(NULL, "mac", DEVFS_FL_DEFAULT,
				      result, 0,
				      S_IFCHR | S_IRUSR | S_IWUSR,
				      &mac_fops, NULL);

	MAC_MAJOR_DEV = result;

	pm = pm_register(PM_SYS_DEV, PM_SYS_UNKNOWN, mma_mac_pm_handler);

	return 0;
}

/*******************************************************
*MMA cleanup function
*Parameters:None
*Return	
* 	
********************************************************/
//void __exit mac_cleanup( void )
void
mac_cleanup(void)
{
	FUNC_START;
	/*Do some cleanup work */
	/*release the memory occupied */
	/*release MAC ISR handler */
	free_irq(MAC_IRQ, NULL);

	pm_unregister_all(mma_mac_pm_handler);

	if (gMmaMacXMatrix.baseaddr != 0x0) {
#ifdef BUG_FIX
		consistent_free(gMmaMacXMatrix.baseaddr, gMmaMacXMatrix.length,
				xphyaddr);
#endif
#ifndef BUG_FIX
		kfree(gMmaMacXMatrix.baseaddr);
#endif
	}
	if (gMmaMacYMatrix.baseaddr != 0x0) {
#ifdef BUG_FIX
		consistent_free(gMmaMacYMatrix.baseaddr, gMmaMacYMatrix.length,
				yphyaddr);
#endif
#ifndef BUG_FIX
		kfree(gMmaMacYMatrix.baseaddr);
#endif
	}
	if (gMmaMacResult.baseaddr != 0x0) {
#ifdef BUG_FIX
		consistent_free(gMmaMacResult.baseaddr, gMmaMacResult.length,
				resultphyaddr);
#endif
#ifndef BUG_FIX
		kfree(gMmaMacResult.baseaddr);
#endif
	}
	memset(&gMmaMacXMatrix, 0, sizeof (struct Matrix));
	memset(&gMmaMacYMatrix, 0, sizeof (struct Matrix));
	memset(&gMmaMacResult, 0, sizeof (struct Matrix));

	devfs_unregister_chrdev(MAC_MAJOR_DEV, "mac");
	devfs_unregister(devfs_handle);

	printk("this is MAC module release successfully \n");

	FUNC_END;
}

module_init(mac_init);
module_exit(mac_cleanup);

/*
int init_module(void)
{
	return mac_init();
}
*/

/*
void cleanup_module(void)
{
	mac_cleanup();
}
*/
//#endif
