/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Copyright 2002, 2003 Motorola, Inc. All Rights Reserved.
 *
 */

#ifndef _MMA_DCT_DD_H_INC_
#define _MMA_DCT_DD_H_INC_

#ifndef BOOLEAN
typedef signed char BOOLEAN;
typedef unsigned char UINT8;

typedef signed char SINT8;
typedef unsigned short UINT16;
typedef signed short SINT16;
typedef unsigned long UINT32;
typedef signed long SINT32;

typedef volatile BOOLEAN VBOOLEAN;
typedef volatile UINT8 VUINT8;
typedef volatile SINT8 VSINT8;
typedef volatile UINT16 VUINT16;
typedef volatile SINT16 VSINT16;
typedef volatile UINT32 VUINT32;
typedef volatile SINT32 VSINT32;
#endif				/* BOOLEAN */

#define TRUE	1
#define FALSE	0
/**********************************************
Macro definition for CMD 
**********************************************/
#define DCT_CMD_SET_SRC	0x3101
#define DCT_CMD_SET_DES	0x3102
#define DCT_CMD_SET_MODE	0x3103
//#define DCT_SET_DCT   0x3104
#define DCT_SET_MEMMODE	0x3105
#define DCT_CMD_START	0x3106
#define DCT_CMD_GET_STAT	0x3107
#define DCT_CMD_GET_DATA	0x3108
#define DCT_CMD_NO_WAIT		0x3109
#define DCT_CMD_SET_WAIT	0x310a
/**********************************************
Macro definition for memory access 
**********************************************/
#define DCT_MC_ARC			0x00000004
#define DCT_ARC_MC			0x00000008
#define DCT_ARC_ARC			0x0000000c
#define DCT_MC_MC			0x00000000
#define DCT_DCT				0x00000002
#define DCT_XPOSE			0x00000080
#define DCT_iDCT			0x00000000
#define DCT_SWAP			0x00002000

struct DCT {
	UINT32 *baseaddr;
	UINT16 xCount;
	UINT16 yCount;
	UINT32 yOffset;
	UINT32 xOffset;
	UINT32 skip;
	UINT32 datalen;
};

#endif
