/*
 * drivers/char/gt64260_mpsc.h
 *
 * Author: Wade Farnsworth <wfarnsworth@mvista.com>
 *
 * 2004 (c) MontaVista, Software, Inc.  This file is licensed under
 * the terms of the GNU General Public License version 2.  This program
 * is licensed "as is" without any warranty of any kind, whether express
 * or implied.
 */

#ifndef __GT64260_MPSC_H
#define __GT64260_MPSC_H

#include <asm/gt64260.h>

/* UART mode SDMA command/status field bits */
#define SDMA_PE		(1<<0)
#define SDMA_CDL	(1<<1)
#define SDMA_CTSL	(1<<1)
#define SDMA_FR		(1<<3)
#define SDMA_OR		(1<<6)
#define SDMA_BR		(1<<9)
#define SDMA_MI		(1<<10)
#define SDMA_A		(1<<11)
#define SDMA_AM		(1<<12)
#define SDMA_CT		(1<<13)
#define SDMA_C		(1<<14)
#define SDMA_ES		(1<<15)
#define SDMA_L		(1<<16)
#define SDMA_F		(1<<17)
#define SDMA_P		(1<<18)
#define SDMA_TA		(1<<19)
#define SDMA_NS		(1<<20)
#define SDMA_EI		(1<<23)
#define SDMA_AUTO	(1<<30)
#define SDMA_O		(1<<31)

/* SDMA Command Register bits */
#define SDCM_ERD	(1<<7)
#define SDCM_AR		(1<<15)
#define SDCM_STD	(1<<16)
#define SDCM_TXD	(1<<23)
#define SDCM_AT		(1<<31)

/* Character Length */
#define MPCR_CL_5	0x00
#define MPCR_CL_6	0x01
#define MPCR_CL_7	0x02
#define MPCR_CL_8	0x03

/* Stop bit length */
#define MPCR_SBL_1	0x00
#define MPCR_SBL_2	0x01

/* Parity Modes */
#define CHR2_PAR_ODD	0x00
#define CHR2_PAR_LOW	0x01
#define CHR2_PAR_EVEN	0x02
#define CHR2_PAR_HIGH	0x03
#define CHR2_PAR_NONE	-1

#define MPSC_CONNECT	0x1

#endif /* __GT64260_MPSC_H */
