/*	cs5535_wdt.h	
 *	AMD Geode GX2 CS5535 WDT driver for Linux 2.4.x
 *      May also work on other similar models
 *
 *	Author: MontaVista Software, Inc.
 *         source@mvista.com
 *       
 *	2002-2004 (c)MontaVista Software, Inc. This file is licensed under
 * 	the terms of the GNU General Public License version 2. This program
 * 	is licensed "as is" without any warranty of any kind, whether express
 * 	or implied.
 *
 */
#ifndef _CS5535_WDT_H_
#define _CS5535_WDT_H_

/*GPT MSR's*/
#define MFGPT_NR 		0x51400029
#define MFGPT0_C2_RSTEN		(1<<24)

/* LBAR base addresses */
#define MSR_LBAR_MFGPT		0x5140000d
/* GPT offsets */
#define MFGPT0_CNT 		0x04
#define MFGPT0_SETUP 		0x06

/* GPT setup masks */
#define CS5535_GPT_EN		0x8000
#define CS5535_GPT_EXT_EN	0x400
#define CS5535_MFGPT_CMP2MODE	(0x3 << 8)

#define CS5535_GPT_SETUP_32KHZ	0
#define CS5535_GPT_SETUP_16KHZ	0x1
#define CS5535_GPT_SETUP_8KHZ	0x2
#define CS5535_GPT_SETUP_4KHZ	0x3
#define CS5535_GPT_SETUP_2KHZ	0x4
#define CS5535_GPT_SETUP_1KHZ	0x5
#define CS5535_GPT_SETUP_500HZ	0x6
#define CS5535_GPT_SETUP_250HZ	0x7
#define CS5535_GPT_SETUP_125HZ	0x8
#define CS5535_GPT_SETUP_2HZ	0xe

/* WDT srop magic sequence */
#define MAGIC 			"bye"

struct frequencies {
	unsigned int freq;
	unsigned int setup_flags;
};

struct frequencies cs5535_freq[] = {
	{32000, CS5535_GPT_SETUP_32KHZ},
	{16000, CS5535_GPT_SETUP_16KHZ},
	{8000, CS5535_GPT_SETUP_8KHZ},
	{4000, CS5535_GPT_SETUP_4KHZ},
	{2000, CS5535_GPT_SETUP_2KHZ},
	{1000, CS5535_GPT_SETUP_1KHZ},
	{500, CS5535_GPT_SETUP_500HZ},
	{250, CS5535_GPT_SETUP_250HZ},
	{125, CS5535_GPT_SETUP_125HZ},
	{2, CS5535_GPT_SETUP_2HZ},
};

#endif
