#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <linux/config.h>
#include <linux/delay.h>
#include <linux/spinlock.h>
#include <linux/init.h>
#include <asm/tx4925/basil_s1/basil_s1.h>
#include <asm/uaccess.h>

#include <asm/param.h>
#include <linux/timer.h>


/* Driver MajorNo Define		*/
#define LED_CHAR_MAJOR			231

#define LED_PIO_CHECK_LED3		( 1 << 20 )
#define LED_PIO_CHECK_LED2		( 1 << 19 )
#define LED_PIO_CHECK_LED1		( 1 << 3 )

#define LED_ARG_CHECK_LED3		( 1 << 2 )
#define LED_ARG_CHECK_LED2		( 1 << 1 )
#define LED_ARG_CHECK_LED1		1

/* change start:  stop debug : 2003/01/24T09:40 RSK Hirata */
/* #define LED_DEBUG                    1 */
#define LED_DEBUG                       0
/* change end  :  stop debug : 2003/01/24T09:40 RSK Hirata */

/* for spinlock */
spinlock_t basil_ledioctl_lock = SPIN_LOCK_UNLOCKED;

static int basil_led_open(struct inode * inode, struct file * file);
static int basil_led_close(struct inode * inode, struct file * file);
static int basil_led_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg);

/* Timer for blink */
static struct timer_list blink_timer;
/* Blink interval times (msec) */
static long intvl_on = 500, intvl_off = 500;
/* Enable blink flags for LED1 to LED3 */
static int blink_flag_LED1 = 0, blink_flag_LED2 = 0,  blink_flag_LED3 = 0;
/* spin_lock for update datas */
static spinlock_t led_spin_lock;

void blink_timer_register( void );
static void blink_timer_handler(unsigned long exd);
void set_blink_state( int nStateLed1,  int nStateLed2,  int nStateLed3 );

/********************************************************/
/*	Normal LED Control Drivers			*/
/*							*/
/*							*/
/*							*/
/*							*/
/*							*/
/*       						*/
/*							*/
/********************************************************/
struct file_operations led_fopes = {
	open:		basil_led_open,
	release:	basil_led_close,
	ioctl:		basil_led_ioctl,
};

void blink_timer_register( void )
{
	static int nBlinkCly = 0;

#if LED_DEBUG
	printk("blink_timer_register %d\n", nBlinkCly);
#endif
		
	init_timer(&blink_timer);

	spin_lock(&led_spin_lock);
	blink_timer.function = blink_timer_handler;
	blink_timer.data = (unsigned long)nBlinkCly;
	blink_timer.expires = jiffies + ((!nBlinkCly)?intvl_on:intvl_off) * HZ / 1000;
	spin_unlock(&led_spin_lock);

	add_timer (&blink_timer);
	nBlinkCly = (!nBlinkCly)?1:0;
	return;
}

static void blink_timer_handler(unsigned long exd)
{
	unsigned long piodo;
	
	piodo = TX4925_RD(TX4925_MKA(TX4925_PIO_PIODO));
	if( exd ) {
		if( blink_flag_LED1 ) piodo &= ~LED_PIO_CHECK_LED1;
		if( blink_flag_LED2 ) piodo &= ~LED_PIO_CHECK_LED2;
		if( blink_flag_LED3 ) piodo &= ~LED_PIO_CHECK_LED3;
	} else {
		if( blink_flag_LED1 ) piodo |= LED_PIO_CHECK_LED1;
		if( blink_flag_LED2 ) piodo |= LED_PIO_CHECK_LED2;
		if( blink_flag_LED3 ) piodo |= LED_PIO_CHECK_LED3;
	}
	TX4925_WR(TX4925_MKA(TX4925_PIO_PIODO), (piodo));
	
	blink_timer_register();
}

void set_blink_state( int nStateLed1,  int nStateLed2,  int nStateLed3 )
{
	int nEnableTimer = (!blink_flag_LED1 && !blink_flag_LED2 && !blink_flag_LED3) ? 0 : 1;
	
#if LED_DEBUG
	printk("set_blink_state %d %d %d\n", nStateLed1, nStateLed2, nStateLed3 );
#endif

	spin_lock(&led_spin_lock);
	if( nStateLed1 >= 0 ) {
		blink_flag_LED1 = nStateLed1;
	}
	if( nStateLed2 >= 0 ) {
		blink_flag_LED2 = nStateLed2;
	}
	if( nStateLed3 >= 0 ) {
		blink_flag_LED3 = nStateLed3;
	}
	spin_unlock(&led_spin_lock);
	
	if( nEnableTimer && (!blink_flag_LED1 && !blink_flag_LED2 && !blink_flag_LED3) ) {
		/* Set timer OFF */
		del_timer_sync(&blink_timer);
	} else if( !nEnableTimer && (blink_flag_LED1 || blink_flag_LED2 || blink_flag_LED3) ) {
		/* Set timer ON */
		blink_timer_register();
	}
}

/********************************************************/
/*	Normal LED Open					*/
/********************************************************/
static int basil_led_open(struct inode * inode, struct file * file)
{
	ushort val = 0;
#if LED_DEBUG
	printk("LED: open() is called \n");
#endif
	MOD_INC_USE_COUNT;
	return val;
}

/********************************************************/
/*	Normal LED Close				*/
/********************************************************/
static int basil_led_close(struct inode * inode, struct file * file)
{
	ushort val = 0;
#if LED_DEBUG
	printk("LED: close() is called \n");
#endif
	MOD_DEC_USE_COUNT;
	return val;
}

/********************************************************/
/*	Normal LED Ioctl				*/
/********************************************************/
static int basil_led_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg)
{
	unsigned long piodo;
	unsigned long arg_wrk;

    switch( cmd ){
		case TIOCSLED1:
			if ( arg > 2 ){
#if LED_DEBUG
			printk("LED: ioctl() set LED1  argNG = %d\n", (int)arg);
#endif
				return -EINVAL;
			}
#if LED_DEBUG
			printk("LED: ioctl() set LED1  arg = %d\n", (int)arg);
#endif
			piodo = TX4925_RD(TX4925_MKA(TX4925_PIO_PIODO));
			if ( arg == 1 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED1;
			}else if ( arg == 2 ) {
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is BLINK \n");
#endif
				/* Enable blink LED1 */
				set_blink_state( 1, -1, -1 );
				return 0;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED1;
			}
			/* Disable blink LED1 */
			set_blink_state( 0, -1, -1 );
			
			TX4925_WR(TX4925_MKA(TX4925_PIO_PIODO), (piodo));
			return 0;

		case TIOCSLED2:
			if ( arg > 2 ){
#if LED_DEBUG
			printk("LED: ioctl() set LED2  argNG = %d\n", (int)arg);
#endif
				return -EINVAL;
			}
#if LED_DEBUG
			printk("LED: ioctl() set LED2  arg = %d\n", (int)arg);
#endif
			piodo = TX4925_RD(TX4925_MKA(TX4925_PIO_PIODO));
			if ( arg == 1 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED2;
			}else if ( arg == 2 ) {
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is BLINK \n");
#endif
				/* Enable blink LED2 */
				set_blink_state( -1, 1, -1 );
				return 0;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED2;
			}
			/* Disable blink LED2 */
			set_blink_state( -1, 0, -1 );
			
			TX4925_WR(TX4925_MKA(TX4925_PIO_PIODO), (piodo));
			return 0;

		case TIOCSLED3:

			if ( arg > 2 ){
#if LED_DEBUG
			printk("LED: ioctl() set LED3  argNG = %d\n", (int)arg);
#endif
				return -EINVAL;
			}
#if LED_DEBUG
			printk("LED: ioctl() set LED3  arg = %d\n", (int)arg);
#endif
			piodo = TX4925_RD(TX4925_MKA(TX4925_PIO_PIODO));
			if ( arg == 1 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED3;
			}else if ( arg == 2 ) {
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is BLINK \n");
#endif
				/* Enable blink LED3 */
				set_blink_state( -1, -1, 1 );
				return 0;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED3;
			}
			/* Disable blink LED3 */
			set_blink_state( -1, -1, 0 );
			
			TX4925_WR(TX4925_MKA(TX4925_PIO_PIODO), (piodo));
			return 0;

		case TIOCSLEDPTN:
			if ( arg >= 8 ){
#if LED_DEBUG
			printk("LED: ioctl() set LED2  argNG = %d\n", (int)arg);
#endif
				return -EINVAL;
			}
#if LED_DEBUG
			printk("LED: ioctl() set pattern is called set_pattern = 0x%x\n", (int)arg);
#endif
			piodo = TX4925_RD(TX4925_MKA(TX4925_PIO_PIODO));
#if LED_DEBUG
			printk("             get pio is 0x%08x\n", (int)piodo);
#endif
			if ( arg & LED_ARG_CHECK_LED3 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED3;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED3 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED3;
			}

			if ( arg & LED_ARG_CHECK_LED2 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED2;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED2 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED2;
			}

			if ( arg & LED_ARG_CHECK_LED1 ){
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is ON \n");
#endif
				piodo &= ~LED_PIO_CHECK_LED1;
			}else{
#if LED_DEBUG
				printk("       ioctl() SetLED LED1 is OFF \n");
#endif
				piodo |= LED_PIO_CHECK_LED1;
			}
#if LED_DEBUG
			printk("             set pio is 0x%08x\n", (int)piodo);
#endif
			TX4925_WR(TX4925_MKA(TX4925_PIO_PIODO), (piodo));
			return 0;

		case TIOCGLEDSTS:
#if LED_DEBUG
			printk("LED: ioctl() get pattern is called \n");
#endif
			piodo = TX4925_RD(TX4925_MKA(TX4925_PIO_PIODO));
			arg_wrk = 0;

			if ( !(piodo & LED_PIO_CHECK_LED3) ){
				arg_wrk |= LED_ARG_CHECK_LED3;
			}
			if ( !(piodo & LED_PIO_CHECK_LED2) ){
				arg_wrk |= LED_ARG_CHECK_LED2;
			}
			if ( !(piodo & LED_PIO_CHECK_LED1) ){
				arg_wrk |= LED_ARG_CHECK_LED1;
			}

			copy_to_user ( (unsigned long *)arg, &arg_wrk, sizeof(unsigned long) );
			return 0;

	    case TIOCSINTVLON:
#if LED_DEBUG
			printk("LED: ioctl() set blink on interval = %ld\n", (unsigned long)arg);
#endif
			spin_lock(&led_spin_lock);
			intvl_on = (unsigned long)arg;
			spin_unlock(&led_spin_lock);
			return 0;
			
	    case TIOCSINTVLOFF:
#if LED_DEBUG
			printk("LED: ioctl() set blink off interval = %ld\n", (unsigned long)arg);
#endif
			spin_lock(&led_spin_lock);
			intvl_off = (unsigned long)arg;
			spin_unlock(&led_spin_lock);
			return 0;
				
		default:
#if LED_DEBUG
			printk("LED: ioctl() NG commnad is called \n");
#endif
			return -EOPNOTSUPP;
	}
}

/********************************************************/
/*	Normal LED init					*/
/********************************************************/
static int __init basil_led_init_module(void){
#if 0
	unsigned long piodo;
#endif
	if (register_chrdev(LED_CHAR_MAJOR, "led", &led_fopes)){
		printk(KERN_NOTICE "Can't allocate major number %d for LED Driver.\n",
		       LED_CHAR_MAJOR);
		return -EAGAIN;
	}

	spin_lock_init( &led_spin_lock );

#if 0		/* 030523 no need LED all clear */
	piodo = TX4925_RD(TX4925_PIO_PIODO);
	piodo |= LED_PIO_CHECK_LED3 | LED_PIO_CHECK_LED2 | LED_PIO_CHECK_LED1;
	TX4925_WR(TX4925_PIO_PIODO, piodo);
#endif
	printk("Basil-S1 LED Driver\n");

	return 0;
}


void __exit basil_led_cleanup_module(void)
{
	unregister_chrdev(LED_CHAR_MAJOR, "led");
}

module_init(basil_led_init_module);
module_exit(basil_led_cleanup_module);


