#include <linux/module.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <linux/config.h>
#include <linux/delay.h>
#include <linux/spinlock.h>
#include <linux/init.h>
#include <asm/tx4925/basil_s1/basil_s1.h>
#include <asm/uaccess.h>


/* Driver MajorNo Define		*/
#define DIPSW_CHAR_MAJOR		232

/* get DipSwitch status Macro */
#define BASIL_S1_DIPSW2			(1 << 31)
#define BASIL_S1_DIPSW1			(1 << 30)
#define BASIL_S1_DIPSW0			(1 << 27)
#define DIPSW				TX4925_RD(TX4925_MKA(TX4925_PIO_PIODI))

/* change start:  stop debug : 2003/01/24T14:35 RSK Hirata */
/* #define DIP_DEBUG			1 */
#define DIP_DEBUG			0
/* change end  :  stop debug : 2003/01/24T14:35 RSK Hirata */


static int basil_dipsw_open(struct inode * inode, struct file * file);
static int basil_dipsw_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg);
static int basil_dipsw_close(struct inode * inode, struct file * file);


/********************************************************/
/*	DIPSW Control Drivers				*/
/*							*/
/*							*/
/*							*/
/*							*/
/*							*/
/*							*/
/*							*/
/********************************************************/
struct file_operations dipsw_fopes = {
	open:		basil_dipsw_open,
	release:	basil_dipsw_close,
	ioctl:		basil_dipsw_ioctl,

};

/********************************************************/
/*	DipSw Open					*/
/********************************************************/
static int basil_dipsw_open(struct inode * inode, struct file * file)
{
	ushort val = 0;
#if DIP_DEBUG
	printk("DipSW: open() is called \n");
#endif
	MOD_INC_USE_COUNT;

	return val;
}

/********************************************************/
/*	DipSw Close					*/
/********************************************************/
static int basil_dipsw_close(struct inode * inode, struct file * file)
{
	ushort val = 0;

#if DIP_DEBUG
	printk("DipSW: close() is called \n");
#endif
	MOD_DEC_USE_COUNT;
	return val;
}

/********************************************************/
/*	Normal DipSw Ioctl				*/
/********************************************************/
static int basil_dipsw_ioctl(struct inode *inode, struct file *filp, unsigned int cmd, unsigned long arg)
{
	unsigned long  val;
	unsigned long  arg_wrk = 0 ;


    switch( cmd ){
		case TIOCGDIPSWSTS:
			val = (unsigned long)DIPSW;
#if DIP_DEBUG
			printk("       ioctl() GetDip val is 0x%x \n", (int)val);
#endif
			if ( !(val & BASIL_S1_DIPSW2) ){
#if DIP_DEBUG
				printk("       ioctl() GetDip SW2 is ON \n");
#endif
				arg_wrk |= ( 1 << 2 );
			}
			if ( !(val & BASIL_S1_DIPSW1) ){
#if DIP_DEBUG
				printk("       ioctl() GetDip SW1 is ON \n");
#endif
				arg_wrk |= ( 1 << 1 );
			}
			if ( !(val & BASIL_S1_DIPSW0) ){
#if DIP_DEBUG
				printk("       ioctl() GetDip SW0 is ON \n");
#endif
				arg_wrk |= 1;
			}
#if DIP_DEBUG
			printk("       ioctl() GetDip return arg_wrk = 0x%x\n", (int)arg_wrk);
#endif
			copy_to_user ( (unsigned long *)arg, &arg_wrk, sizeof(unsigned long) );
			return 0;

		default:
#if DIP_DEBUG
  	printk("DipSW: ioctl() NG command is called \n");
#endif
			return -EOPNOTSUPP;
	}
}

/********************************************************/
/*	DipSw Init Module				*/
/********************************************************/
static int __init basil_dipsw_init_module(void)
{
	if (register_chrdev(DIPSW_CHAR_MAJOR, "dipsw", &dipsw_fopes))
	{
		printk(KERN_NOTICE "Can't allocate major number %d for DIPSW Driver.\n",
		       DIPSW_CHAR_MAJOR);
		return -EAGAIN;
	}
	printk("Basil-S1 DipSwitch Driver\n");
	return 0;
}


/********************************************************/
/*	DipSw Cleanup Module				*/
/********************************************************/
void __exit basil_dipsw_cleanup_module(void)
{
	unregister_chrdev(DIPSW_CHAR_MAJOR, "dipsw");
}

module_init(basil_dipsw_init_module);
module_exit(basil_dipsw_cleanup_module);

