/*
 * basil_asap.c --- implements the ASAP(N_MOUSE) line discipline.
 * 
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/major.h>
#include <linux/errno.h>
#include <linux/signal.h>
#include <linux/fcntl.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/tty.h>
#include <linux/timer.h>
#include <linux/ctype.h>
#include <linux/kd.h>
#include <linux/mm.h>
#include <linux/string.h>
#include <linux/slab.h>
#include <linux/poll.h>
#include <linux/ioctl.h>

#define CONSOLE_DEV MKDEV(TTY_MAJOR,0)
#define SYSCONS_DEV  MKDEV(TTYAUX_MAJOR,1)

/*========================================================================*/
/*--------------------
  
 ---------------------*/
/* ASAPǡե졼७塼ΥǥեȥʸĿ*/
#define ASAP_DATAFRAME_QUE_DEF_SIZE   10

/* Ԥ֥ǥեȡms*/
#define ASAP_RESPONS_DEF_WAIT_TIME	100

/* ASAP */
enum AsapRespons {
	ASAP_RESPONS_NONE=0,	/* ̤ */
	ASAP_RESPONS_WAIT,      /* Ԥ*/
	ASAP_RESPONS_ACK,       /* ACK */
	ASAP_RESPONS_NAK,	    /* NAK */
	ASAP_RESPONS_TIMEOUT,	/* ॢ */
	ASAP_RESPONS_ATN	    /* ATN */
};

/* ̿󥯳ΩƻԲ */
#define ASAP_TRY_LINK_MAX		10

/* ASAP業饯 */
#define ASAP_CTL_ST1    0xF0
#define ASAP_CTL_ST2    0xF1
#define ASAP_CTL_ACK    0xF2
#define ASAP_CTL_NAK    0xF3
#define ASAP_CTL_ETX    0xF4
#define ASAP_CTL_DLE    0xF5
#define ASAP_CTL_ATN    0xFF

/* ASAPưޥɥ */
#define ASAP_ATNCMD_SIZE   16

/*--------------------
  ¤
 ---------------------*/
/* ASAPǡե졼 */
struct tagAsapDataFrame
{
	unsigned char* pCmdData;		/* ޥɥǡΥɥ쥹 */
	int nCmdSize;	                /* ޥɥǡ */
};

/*--------------------
  Хѿ
 ---------------------*/
static unsigned char* g_pReadBuff;       /* ǡХåե */
static int g_nReadCnt;                   /* ǡ */
static struct tagAsapDataFrame* g_pAsapCmdDataQue;        /* ASAPޥɥǡ塼 */
static ushort g_unAsapCmdDataQueMax;     /* ASAPޥɥǡ塼ΥASAPޥɥǡθĿ */
static unsigned char g_sAsapCmdWithATN[ASAP_ATNCMD_SIZE];          /* ATNμưASAPޥ */
static unsigned long g_lRespWaitTime;    /* ॢȻ֡msec*/
static ushort g_unRespons;               /* ľα̡emum AsapResponsΤ줫 */
static int g_bEnableLink = 0;            /* ΤȤ̿󥯳Ωե饰0=̿Ω/1=̿󥯳Ω/-1=̿󥯳ΩԤ*/
static struct timer_list rsp_timer;      /* ƻ륿ޡʱॢȸѡ*/
static ushort g_bEvenCmd = 0;
static ushort g_bInASAPFrame = 0;
static ushort g_bDLE=0;
static ushort g_bRespPermit = 0;
static spinlock_t asap_spin_lock = SPIN_LOCK_UNLOCKED;
static int g_nRecvAtnCnt = 0;

/*--------------------
  ޥ
 ---------------------*/
#ifdef ASAP_DEBUG
#define ASAP_DEBUGOUT( ... ) printk( "basil_asap: " __VA_ARGS__ )
#else
#define ASAP_DEBUGOUT( ... )
#endif

#ifndef MIN
#define MIN(a,b)	((a) < (b) ? (a) : (b))
#endif

/*--------------------
  ץȥ
 ---------------------*/
void asap_resp_timer_register(void);

/*========================================================================*/

static inline unsigned char *alloc_buf(unsigned int size)
{
	unsigned char *p;
	int prio = in_interrupt() ? GFP_ATOMIC : GFP_KERNEL;

	p = kmalloc( size, prio );
	if(p) {
		memset(p, 0, size);
	}

	return p;
}

static inline void free_buf(unsigned char *buf)
{
	if( buf ) {
		kfree(buf);
	}
}

/*
 * Reset the read buffer counters, clear the flags, 
 * and make sure the driver is unthrottled. Called
 * from asap_open() and asap_flush_buffer().
 */
static void reset_buffer_flags(struct tty_struct *tty)
{
	unsigned long flags;

	spin_lock_irqsave(&tty->read_lock, flags);
	tty->read_head = tty->read_tail = tty->read_cnt = 0;
	spin_unlock_irqrestore(&tty->read_lock, flags);
	tty->canon_head = tty->canon_data = tty->erasing = 0;
	memset(&tty->read_flags, 0, sizeof tty->read_flags);
}

static inline void put_char(unsigned char c, struct tty_struct *tty)
{
	tty->driver.put_char(tty, c);
}

/*
 * Perform OPOST processing.  Returns -1 when the output device is
 * full and the character must be retried.
 */
static int opost(unsigned char c, struct tty_struct *tty)
{
	int	space;

	space = tty->driver.write_room(tty);
	if (!space)
		return -1;

	if (O_OPOST(tty)) {
		if (O_OLCUC(tty))
			c = toupper(c);
		if (!iscntrl(c))
			tty->column++;
	}
	if( c >= 0xF0 ) {
		tty->driver.put_char(tty, ASAP_CTL_DLE);
		c &= 0x7F;
	}
	tty->driver.put_char(tty, c);
	return 0;
}

static int asap_receive_room(struct tty_struct *tty)
{
	int	left = N_TTY_BUF_SIZE - g_nReadCnt - 1;

	if (tty->icanon && !tty->canon_data)
		return N_TTY_BUF_SIZE;

	if (left > 0)
		return left;
	return 0;
}

static int addAsapCmdQue( const unsigned char* pAsapCmdData, int nCmdSize )
{
	int i;

	if( !pAsapCmdData || !g_pAsapCmdDataQue ) {
		return 0;
	}
	for(i=0; i<g_unAsapCmdDataQueMax; i++) {
		if( (g_pAsapCmdDataQue+i)->nCmdSize == 0 ) {
			(g_pAsapCmdDataQue+i)->pCmdData = alloc_buf( nCmdSize );
			if( !(g_pAsapCmdDataQue+i)->pCmdData ) {
				return 0;
			}
			memcpy( (g_pAsapCmdDataQue+i)->pCmdData, pAsapCmdData, nCmdSize );
			(g_pAsapCmdDataQue+i)->nCmdSize = nCmdSize;
			return nCmdSize;
		}
	}
	
	return 0;
}

static int getAsapCmdQue( unsigned char* pDst, int nDstSize )
{
	int i;
	int nRealCopySize;

	if( !pDst || !g_pAsapCmdDataQue || (nDstSize<=0) ) {
		return 0;
	}
	
	for(i=0; i<g_unAsapCmdDataQueMax; i++) {
		if( ((g_pAsapCmdDataQue+i)->nCmdSize > 0) && ((g_pAsapCmdDataQue+i)->pCmdData) ) {
			nRealCopySize = MIN(nDstSize, (g_pAsapCmdDataQue+i)->nCmdSize);
			copy_to_user( pDst, (g_pAsapCmdDataQue+i)->pCmdData, nRealCopySize );
			free_buf( (unsigned char*)(g_pAsapCmdDataQue+i)->pCmdData );
			(g_pAsapCmdDataQue+i)->pCmdData = 0;
			(g_pAsapCmdDataQue+i)->nCmdSize = 0;
			if( i < g_unAsapCmdDataQueMax - 1 ) {
				memcpy( (g_pAsapCmdDataQue+i), (g_pAsapCmdDataQue+i+1), (g_unAsapCmdDataQueMax-(i+1))*sizeof(struct tagAsapDataFrame));
				(g_pAsapCmdDataQue+(g_unAsapCmdDataQueMax-1))->pCmdData = 0;
				(g_pAsapCmdDataQue+(g_unAsapCmdDataQueMax-1))->nCmdSize = 0;
			}
			return nRealCopySize;
		}
	}
	
	return 0;
}

static void asap_receive_buf(struct tty_struct *tty, const unsigned char *cp,
			      char *fp, int count)
{
	const unsigned char *p;
	char *f, flags = TTY_NORMAL;
	int	i;
	int nAtnCnt=0;

	if (!g_pReadBuff) {
		ASAP_DEBUGOUT("ASAP: g_pReadBuff is no alocated.\n");
		return;
	}

	for (i=count, p = cp, f = fp; i; i--, p++) {
		if (f) flags = *f++;
		
		switch (flags) {
		case TTY_NORMAL:
			/*  */
			if( (*p == ASAP_CTL_ACK) || (*p == ASAP_CTL_NAK) ) {
				ASAP_DEBUGOUT("ASAP: ctl=ACK/NAK(%02x)\n", *p);
				spin_lock(&asap_spin_lock);
				if( (g_unRespons == ASAP_RESPONS_WAIT) || (g_unRespons == ASAP_RESPONS_NONE) ) {
					g_unRespons = (*p==ASAP_CTL_ACK)?ASAP_RESPONS_ACK:ASAP_RESPONS_NAK;
					del_timer_sync(&rsp_timer);
					if( *p==ASAP_CTL_ACK ) g_bEvenCmd = (g_bEvenCmd==1)?0:1;
				}
				spin_unlock(&asap_spin_lock);
				g_nRecvAtnCnt = 0;
				continue;
			/* Ʃǡ */
			} else if( *p == ASAP_CTL_DLE ) {
				ASAP_DEBUGOUT("ASAP: ctl=DLE\n");
				g_bDLE = 1;
				continue;
            /* ATN */
			} else if( *p == ASAP_CTL_ATN ) {
				ASAP_DEBUGOUT("ASAP: ctl ATN. cnt=%d\n", g_nRecvAtnCnt);
				g_nRecvAtnCnt++;
				if( g_nRecvAtnCnt == 2 ) {
#if 0
					spin_lock(&asap_spin_lock);
					if( (g_unRespons == ASAP_RESPONS_WAIT) || (g_unRespons == ASAP_RESPONS_NONE) ) {
						g_unRespons = ASAP_RESPONS_ATN;
					}
					spin_unlock(&asap_spin_lock);
#endif					
					/* ATN */
					for( nAtnCnt=0; nAtnCnt<10; nAtnCnt++ ) put_char(ASAP_CTL_ATN, tty);
					if( g_bEnableLink != 1 ) {
						spin_lock(&asap_spin_lock);
						g_bEnableLink = 1;
						spin_unlock(&asap_spin_lock);  
					}
					/* Ƽե饰 */
					g_bDLE = g_bInASAPFrame = g_nReadCnt = g_bEvenCmd = 0;
					/* ASAPޥɥ塼ɲ */
					if( addAsapCmdQue( "\377", 1 ) <= 0 ) {
						printk("ASAP: addAsapCmdQue full!\n");
					}
					ASAP_DEBUGOUT("ASAP: send ATN\n");
				}
				continue;
			/* ASAPǡե졼 IN */
			} else if( (*p == ASAP_CTL_ST1) || (*p == ASAP_CTL_ST2) ) {
				ASAP_DEBUGOUT("ASAP: ctl STn\n");
				g_bInASAPFrame = 1;
				g_nReadCnt= 0;
				continue;
			/* ASAPǡե졼 OUT */
			} else if( *p == ASAP_CTL_ETX ) {
				ASAP_DEBUGOUT("ASAP: ctl ETX\n");
				if( g_bInASAPFrame && g_bRespPermit ) {
					/* ASAPޥɥ塼ɲ */
					if( addAsapCmdQue( g_pReadBuff, g_nReadCnt ) <= 0 ) {
						/* 塼FULLξNAK */
						put_char(ASAP_CTL_NAK, tty);
					} else {
						/* ACK */
						put_char(ASAP_CTL_ACK, tty);
					}
				}
			/* ǡ */
			} else {
				if (g_nReadCnt < N_TTY_BUF_SIZE) {
					*(g_pReadBuff + g_nReadCnt) = *p;
					if( g_bDLE ) {
						*(g_pReadBuff + g_nReadCnt) |= 0x80;
						g_bDLE = 0;
					}
					g_nReadCnt ++;
					continue;
				} else {
					/* NAK */
					put_char(ASAP_CTL_NAK, tty);
				}
			}
			break;
		case TTY_BREAK:
#if 1
			spin_lock(&asap_spin_lock);
			g_bEnableLink = 0;
			spin_unlock(&asap_spin_lock);
#endif			
			if( *p == 0x00 ) {
				ASAP_DEBUGOUT("ASAP: break receive.\n");
				break;
			} else if( *p == ASAP_CTL_ATN ) {
				/* BREAKATNäƤƤޤ礬ΤǤǤ⥫Ȥ */
				g_nRecvAtnCnt++;
				ASAP_DEBUGOUT("ASAP: break receive. but looks like ATN...\n");
			}
			continue;
		case TTY_PARITY:
		case TTY_FRAME:
		case TTY_OVERRUN:
			ASAP_DEBUGOUT("ASAP: com error. flag=%d.\n", flags);
			put_char(ASAP_CTL_NAK, tty);
			break;
		default:
			printk("ASAP: unknown flag %d\n", flags);
			break;
		}
		g_bDLE = 0;
		g_bInASAPFrame = 0;
		g_nReadCnt= 0;
		g_nRecvAtnCnt = 0;
	}
	
	if (tty->driver.flush_chars) {
		tty->driver.flush_chars(tty);
	}
}

int AllocAsapCmdDataQue( void )
{
	/* ASAPޥɥ塼γ */
	if( !g_pAsapCmdDataQue ) {
		g_pAsapCmdDataQue = (struct tagAsapDataFrame*)alloc_buf( (unsigned int)(g_unAsapCmdDataQueMax*sizeof(struct tagAsapDataFrame)) );
		if (!g_pAsapCmdDataQue) {
			return -ENOMEM;
		}
		memset(g_pAsapCmdDataQue, 0, (unsigned int)(g_unAsapCmdDataQueMax*sizeof(struct tagAsapDataFrame)));
	}
	return 0;
}

int FreeAsapCmdDataQue( void )
{
	int i;

	/* ASAPޥɥǡ塼β */
	if (g_pAsapCmdDataQue) {
		for(i=0; i<g_unAsapCmdDataQueMax; i++) {
			if( (g_pAsapCmdDataQue+i)->pCmdData ) {
				free_buf( (g_pAsapCmdDataQue+i)->pCmdData );
				(g_pAsapCmdDataQue+i)->pCmdData = 0;
				(g_pAsapCmdDataQue+i)->nCmdSize = 0;
			}
		}
		free_buf( (unsigned char*)g_pAsapCmdDataQue );
		g_pAsapCmdDataQue = 0;
	}
	return 0;
}

static void asap_close(struct tty_struct *tty)
{
	/* TTYХåեβ */
	if( g_pReadBuff ) {
		free_buf( g_pReadBuff );
		g_pReadBuff = 0;
	}
	g_nReadCnt = 0;

	/* ASAPޥɥǡ塼β */
	FreeAsapCmdDataQue();
}

static int asap_open(struct tty_struct *tty)
{
	if (!tty)
		return -EINVAL;

	/* TTYХåեʤг */
	if (!g_pReadBuff) {
		g_pReadBuff = alloc_buf( N_TTY_BUF_SIZE );
		if (!g_pReadBuff) {
			return -ENOMEM;
		}
	}
	memset(g_pReadBuff, 0, N_TTY_BUF_SIZE);
	g_nReadCnt = 0;

	/* TTYν */
	reset_buffer_flags(tty);
	tty->column = 0;
	tty->minimum_to_wake = 1;
	tty->closing = 0;
	if (tty->driver.flush_buffer)
		tty->driver.flush_buffer(tty);
	tty_ldisc_flush(tty);
	
	/* ̤ν */
	spin_lock(&asap_spin_lock);
	g_unRespons = ASAP_RESPONS_NONE;
    g_bEnableLink = 0;
	spin_unlock(&asap_spin_lock);

	g_bEvenCmd = 0;
	g_bInASAPFrame = 0;
	g_bDLE=0;
	g_nRecvAtnCnt = 0;

	/* ATNưޥɤν */
	memset(g_sAsapCmdWithATN, 0, ASAP_ATNCMD_SIZE);

	/* ASAPޥɥ塼γ */
	return AllocAsapCmdDataQue();
}

static ssize_t asap_read(struct tty_struct *tty, struct file *file,
			 unsigned char *buf, size_t nr)
{
	ssize_t retval = 0;
#if 0	
	unsigned char *b = buf;
	DECLARE_WAITQUEUE(wait, current);
	int minimum, time;
	ssize_t size;
	long timeout;

do_it_again:
	/* Job control check -- must be done at start and after
	   every sleep (POSIX.1 7.1.1.4). */
	/* NOTE: not yet done after every sleep pending a thorough
	   check of the logic of this change. -- jlc */
	/* don't stop on /dev/console */
	if (file->f_dentry->d_inode->i_rdev != CONSOLE_DEV &&
	    file->f_dentry->d_inode->i_rdev != SYSCONS_DEV &&
	    current->tty == tty) {
		if (tty->pgrp <= 0)
			printk("read_chan: tty->pgrp <= 0!\n");
		else if (current->pgrp != tty->pgrp) {
			if (is_ignored(SIGTTIN) ||
			    is_orphaned_pgrp(current->pgrp))
				return -EIO;
			kill_pg(current->pgrp, SIGTTIN, 1);
			return -ERESTARTSYS;
		}
	}
	minimum = time = 0;
	timeout = MAX_SCHEDULE_TIMEOUT;
	if (!tty->icanon) {
		time = (HZ / 10) * TIME_CHAR(tty);
		minimum = MIN_CHAR(tty);
		if (minimum) {
			if (time)
				tty->minimum_to_wake = 1;
			else if (!waitqueue_active(&tty->read_wait) ||
				 (tty->minimum_to_wake > minimum))
				tty->minimum_to_wake = minimum;
		} else {
			timeout = 0;
			if (time) {
				timeout = time;
				time = 0;
			}
			tty->minimum_to_wake = minimum = 1;
		}
	}

	if (file->f_flags & O_NONBLOCK) {
		if (down_trylock(&tty->atomic_read))
			return -EAGAIN;
	}
	else {
		if (down_interruptible(&tty->atomic_read))
			return -ERESTARTSYS;
	}

	add_wait_queue(&tty->read_wait, &wait);
	set_bit(TTY_DONT_FLIP, &tty->flags);
#endif	

	/* do read */
	retval = getAsapCmdQue( buf, nr );

#if 0
	clear_bit(TTY_DONT_FLIP, &tty->flags);
	up(&tty->atomic_read);
	remove_wait_queue(&tty->read_wait, &wait);

	if (!waitqueue_active(&tty->read_wait))
		tty->minimum_to_wake = minimum;

	current->state = TASK_RUNNING;
	size = b - buf;
	if (size) {
		retval = size;
		if (nr)
	       		clear_bit(TTY_PUSH, &tty->flags);
	} else if (test_and_clear_bit(TTY_PUSH, &tty->flags))
		 goto do_it_again;
#endif
	return retval;
}

static ssize_t asap_write(struct tty_struct * tty, struct file * file,
			  const unsigned char * buf, size_t nr)
{
	const unsigned char *b = buf;
	DECLARE_WAITQUEUE(wait, current);
	int c;
	ssize_t retval = 0;

	spin_lock(&asap_spin_lock);
	/* ̿󥯤ΩƤʤ̿Բ */
	/* ԤWriteԲ */
	if( (g_bEnableLink != 1) || (g_unRespons == ASAP_RESPONS_WAIT) ) {
		spin_unlock(&asap_spin_lock);
		ASAP_DEBUGOUT("ASAP: No comm link or now waiting respons. so can't write.\n");
		return -EAGAIN;
	}
	g_unRespons = ASAP_RESPONS_NONE;
	spin_unlock(&asap_spin_lock);

	/* Job control check -- must be done at start (POSIX.1 7.1.1.4). */
	if (L_TOSTOP(tty) && 
	    file->f_dentry->d_inode->i_rdev != CONSOLE_DEV &&
	    file->f_dentry->d_inode->i_rdev != SYSCONS_DEV) {
		retval = tty_check_change(tty);
		if (retval)
			return retval;
	}

	add_wait_queue(&tty->write_wait, &wait);
	while (1) {
		set_current_state(TASK_INTERRUPTIBLE);
		if (signal_pending(current)) {
			retval = -ERESTARTSYS;
			break;
		}
		if (tty_hung_up_p(file) || (tty->link && !tty->link->count)) {
			retval = -EIO;
			break;
		}

		retval = nr;
		put_char( (g_bEvenCmd==1)?ASAP_CTL_ST2:ASAP_CTL_ST1, tty );
		while (nr > 0) {
			get_user(c, b);
			if (opost(c, tty) < 0) {
				printk("asap_write opost fail. (write buffer full). retry...\n");
				schedule();
				continue;
			}
			b++; nr--;

			spin_lock(&asap_spin_lock);
#if 0			
			if( (g_unRespons == ASAP_RESPONS_NAK) || (g_unRespons == ASAP_RESPONS_ATN) ) {
				if( g_unRespons != ASAP_RESPONS_ATN ) {
					retval = -EFAULT;
				} else {
					ASAP_DEBUGOUT("ATN recv. so stop send cmd.\n");
				}
				spin_unlock(&asap_spin_lock);
				if (tty->driver.flush_buffer)
					tty->driver.flush_buffer(tty);
				tty_ldisc_flush(tty);
				b = buf;
				goto break_out;
			}
#else			
			if( g_unRespons == ASAP_RESPONS_NAK ) {
				spin_unlock(&asap_spin_lock);
				if (tty->driver.flush_buffer)
					tty->driver.flush_buffer(tty);
				tty_ldisc_flush(tty);
				retval = 0;
				b = buf;
				goto break_out;
			}
#endif			
			spin_unlock(&asap_spin_lock);
		}

		put_char( ASAP_CTL_ETX, tty );

		if (tty->driver.flush_chars)
			tty->driver.flush_chars(tty);
		
		if (!nr)
			break;
		if (file->f_flags & O_NONBLOCK) {
			retval = -EAGAIN;
			break;
		}
		
		schedule();
	}

	/* ॢȴƻ륿޵ư */
	asap_resp_timer_register();
	
break_out:
	current->state = TASK_RUNNING;
	remove_wait_queue(&tty->write_wait, &wait);
	
	return (b - buf) ? b - buf : retval;
}

static int asap_send_break(struct tty_struct *tty, int duration)
{
	tty->driver.break_ctl(tty, -1);
	if (!signal_pending(current)) {
		set_current_state(TASK_INTERRUPTIBLE);
		schedule_timeout(duration);
	}
	tty->driver.break_ctl(tty, 0);
	if (signal_pending(current))
		return -EINTR;

	spin_lock(&asap_spin_lock);
	g_bEnableLink = -1;
	spin_unlock(&asap_spin_lock);
	return 0;
}

int asap_ioctl(struct tty_struct * tty, struct file * file,
		       unsigned int cmd, unsigned long arg)
{
	int error = 0;
	
	switch (cmd) {
	case IOCSETRBS:
		if( g_unAsapCmdDataQueMax != (ushort)arg ) {
			ASAP_DEBUGOUT("ioctl(IOCSETRBS). arg=%ld\n", arg);
			/* ASAPޥɥǡ塼β */
			FreeAsapCmdDataQue();
			g_unAsapCmdDataQueMax = (ushort)arg;
			error = AllocAsapCmdDataQue();
		}
		break;
	case IOCGETRBS:
		ASAP_DEBUGOUT("ioctl(IOCGETRBS).\n");
		put_user( g_unAsapCmdDataQueMax, ((ushort*)arg));
		break;
	case IOCSETTMO:
		ASAP_DEBUGOUT("ioctl(IOCSETTMO). arg=%ld\n", arg);
		g_lRespWaitTime = (long)arg;
		break;
	case IOCGETTMO:
		ASAP_DEBUGOUT("ioctl(IOCGETTMO).\n");
		put_user( g_lRespWaitTime, ((unsigned long*)arg));
		break;
	case IOCWTSTS:
		ASAP_DEBUGOUT("ioctl(IOCWTSTS). g_unRespons=%d\n", g_unRespons);
		spin_lock(&asap_spin_lock);
		put_user( g_unRespons, ((unsigned long*)arg));
		spin_unlock(&asap_spin_lock);
		break;
	case IOCSETIDD:
		ASAP_DEBUGOUT("ioctl(IOCSETIDD).\n");
		memset(g_sAsapCmdWithATN, 0, ASAP_ATNCMD_SIZE);
		copy_from_user(g_sAsapCmdWithATN, (char*)arg, 16);
		break;
	case IOCSNDBRK:
		ASAP_DEBUGOUT("ioctl(IOCSNDBRK).\n");
#if 0		
		asap_send_break(tty, (arg*(HZ/1000)));  /* HZǣ */
#endif		
		asap_send_break(tty, ((arg*HZ)/100000)+1);
		break;
	case IOCGETLNK:
		ASAP_DEBUGOUT("ioctl(IOCGETLNK).\n");
		spin_lock(&asap_spin_lock);
		put_user( g_bEnableLink, ((unsigned long*)arg));
		spin_unlock(&asap_spin_lock);
		break;
	case IOCSETPERM:
		ASAP_DEBUGOUT("ioctl(IOCSETPERM).\n");
		spin_lock(&asap_spin_lock);
		g_bRespPermit = (ushort)arg;
		spin_unlock(&asap_spin_lock);
		break;
	default:
		ASAP_DEBUGOUT("ioctl(other).\n");
		error = n_tty_ioctl (tty, file, cmd, arg);
		break;
	}
	
	return error;
}

struct tty_ldisc asap_ldisc = {
	TTY_LDISC_MAGIC,	    /* magic */
	"asap",		            /* name */
	0,			            /* num */
	0,			            /* flags */
	asap_open,		        /* open */
	asap_close,		        /* close */
	NULL,                   /* flush_buffer */
	NULL,                   /* chars_in_buffer */
	asap_read,		        /* read */
	asap_write,		        /* write */
	asap_ioctl,	            /* ioctl */
	NULL,                   /* set_termios */
	NULL,		            /* poll */
	NULL,		            /* hangup */
	asap_receive_buf,       /* receive_buf */
	asap_receive_room,      /* receive_room */
	NULL                    /* write_wakeup */
};

static void asap_resp_timer_handler(unsigned long exd)
{
	spin_lock(&asap_spin_lock);
	if( g_unRespons == ASAP_RESPONS_WAIT ) {
		g_unRespons = ASAP_RESPONS_TIMEOUT;
		ASAP_DEBUGOUT("timer_expire. g_unRespons = ASAP_RESPONS_TIMEOUT\n");
	}
	spin_unlock(&asap_spin_lock);
}

void asap_resp_timer_register(void)
{
	spin_lock(&asap_spin_lock);
	if( g_unRespons == ASAP_RESPONS_NONE ) {
		g_unRespons = ASAP_RESPONS_WAIT;
	} else {
		ASAP_DEBUGOUT("Can't move status to ASAP_RESPONS_WAIT(%d).\n", g_unRespons);
	}
	spin_unlock(&asap_spin_lock);

	ASAP_DEBUGOUT("timer_register. g_unRespons = ASAP_RESPONS_WAIT\n");
	init_timer(&rsp_timer);
	rsp_timer.function = asap_resp_timer_handler;
	rsp_timer.expires = jiffies + (g_lRespWaitTime * HZ / 1000);
	add_timer (&rsp_timer);
	return;
}

static int __init basil_asap_init_module(void)
{
	int status;

	/* Хѿν */
	g_pAsapCmdDataQue = NULL;
	g_unRespons = ASAP_RESPONS_NONE;
	g_lRespWaitTime = ASAP_RESPONS_DEF_WAIT_TIME;
	g_unAsapCmdDataQueMax = ASAP_DATAFRAME_QUE_DEF_SIZE;
	memset(g_sAsapCmdWithATN, 0, ASAP_ATNCMD_SIZE);

	/* line discipline Ͽ */
	if ((status = tty_register_ldisc(N_MOUSE, &asap_ldisc)) != 0)  {
		printk("ASAP: can't register line discipline (err = %d)\n", status);
	}

	spin_lock_init( &asap_spin_lock );

	printk( "basil_asap initialized.\n" );
	
	return 0;
}

void __exit basil_asap_cleanup_module(void)
{
	/* ޤκ */
	del_timer_sync(&rsp_timer);
}

#ifdef MODULE
int 
init_module( void )
{
	return basil_asap_init_module();
}
void 
cleanup_module( void )
{
	basil_asap_cleanup_module();
}
#else
module_init(basil_asap_init_module);
module_exit(basil_asap_cleanup_module);
#endif

MODULE_LICENSE("Ricoh");
MODULE_AUTHOR("Ricoh Company, Ltd.");
MODULE_DESCRIPTION("ASAP driver");
