/* (C) Copyright Koninklijke Philips Electronics NV 2004. All rights reserved.
 *
 * You can redistribute and/or modify this software under the terms of
 * version 2 of the GNU General Public License as published by the Free
 * Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _VH_SSA1ADC_H_
#define _VH_SSA1ADC_H_
/*!
    This register map is used to access the register of the BL-AS (SSA1) 10 bits ADC 
    IP block and if neccessary from elsewhere. The register map is documented to get
    a reference which registers are accessible in read only, write only or read write 
    mode. See register comments for details.
*/
#ifndef ASM_INCLUDE
#include "vhtypes.h"
#endif

#ifdef __cplusplus
extern "C" {  // Assume C declarations for C++
#endif

// ----------------------------------------------------------------------------
// The SSA1 ADC device description
// ----------------------------------------------------------------------------

// -----------------------------------
// Register offsets from base address
// -----------------------------------

#define VH_ADC_R0_REG            0x00  //  Digital conversion data with respect to analog input channel  
#define VH_ADC_R1_REG            0x04  //  Digital conversion data with respect to analog input channel                  
#define VH_ADC_R2_REG            0x08  //  Digital conversion data with respect to analog input channel                 
#define VH_ADC_R3_REG            0x0C  //  Digital conversion data with respect to analog input channel 
#define VH_ADC_R4_REG            0x10  //  Digital conversion data with respect to analog input channel
#define VH_ADC_R5_REG            0x10  //  Digital conversion data with respect to analog input channel
#define VH_ADC_R6_REG            0x10  //  Digital conversion data with respect to analog input channel
#define VH_ADC_R7_REG            0x10  //  Digital conversion data with respect to analog input channel
#define VH_ADC_CON_REG           0x20  //  ADC Control register 
#define VH_ADC_CSEL_RES_REG      0x24  //  ADC Channel Selection and Resolution register
#define VH_ADC_INT_ENABLE_REG    0x28  //  ADC Interrupt Enable register
#define VH_ADC_INT_STATUS_REG    0x2C  //  ADC Interrupt Status register
#define VH_ADC_INT_CLEAR_REG     0x30  //  ADC Interrupt Clear register
// Reserved from 0x34


#define VH_SSA1_ADC_REGS_NUMBER        10

/* - Mode 
#define	ADC10_R0			(0x00)
#define	ADC10_R0_Mask		    	(0x300)
#define	ADC10_R0_InitialValue	    	()
#define	ADC10_R0_AccessType  	    	(RO)
#define	ADC10_R0_TestMask		()

#define	ADC10_R1			(0x04)
#define	ADC10_R1_Mask		    	(0x300)
#define	ADC10_R1_InitialValue	    	()
#define	ADC10_R1_AccessType  	    	(RO)
#define	ADC10_R1_TestMask		()

#define	ADC10_CON 		    	(0x20)
#define	ADC10_CON_Mask		    	(0xf)
#define	ADC10_CON_InitialValue	    	()
#define	ADC10_CON_AccessType  	    	(RW)
#define	ADC10_CON_TestMask		()

#define	ADC10_CSEL_RES			(0x24)
#define	ADC10_CSEL_RES_Mask		(0xff)
#define	ADC10_CSEL_RES_InitialValue	()
#define	ADC10_CSEL_RES_AccessType  	(RW)
#define	ADC10_CSEL_RES_TestMask		()

#define	ADC10_INT_ENABLE		(0x28)
#define	ADC10_INT_ENABLE_Mask		(0x1)
#define	ADC10_INT_ENABLE_InitialValue	()
#define	ADC10_INT_ENABLE_AccessType  	(RW)
#define	ADC10_INT_ENABLE_TestMask	()

#define	ADC10_INT_STATUS		(0x2C)
#define	ADC10_INT_STATUS_Mask		(0x1)
#define	ADC10_INT_STATUS_InitialValue	()
#define	ADC10_INT_STATUS_AccessType  	(R)
#define	ADC10_INT_STATUS_TestMask	()

#define ADC10_INT_CLEAR			(0x30)
#define	ADC10_INT_CLEAR_Mask		(0x1)
#define	ADC10_INT_CLEAR_InitialValue	()
#define	ADC10_INT_CLEAR_AccessType  	(W)
#define	ADC10_INT_CLEAR_TestMask	()

#define SSAADC10_R0	 	0x8A000000		
#define SSAADC10_R1		0x8A000004	       
#define SSAADC10_CON		0x8A000020  
#define SSAADC10_CSEL_RES	0x8A000024     
#define SSAADC10_INT_ENABLE	0x8A000028
#define SSAADC10_INT_STATUS	0x8A00002C  
#define SSAADC10_INT_CLEAR	0x8A000030  
*/

// -----------------------------------
// The device register structure
// -----------------------------------

#ifndef ASM_INCLUDE

typedef volatile struct {
  
      UInt32  ADC_R0_REG;              // 0x00: Digital conversion data with respect to analog input channel
      UInt32  ADC_R1_REG;              // 0x04: Digital conversion data with respect to analog input channel
      UInt32  ADC_R2_REG;              // 0x08: Digital conversion data with respect to analog input channel
      UInt32  ADC_R3_REG;              // 0x0C: Digital conversion data with respect to analog input channel
      UInt32  ADC_R4_REG;              // 0x10: Digital conversion data with respect to analog input channel
      UInt32  ADC_R5_REG;              // 0x14: Digital conversion data with respect to analog input channel
      UInt32  ADC_R6_REG;              // 0x18: Digital conversion data with respect to analog input channel
      UInt32  ADC_R7_REG;              // 0x1C: Digital conversion data with respect to analog input channel
      UInt32  ADC_CON_REG;             // 0x20: ADC Control register
      UInt32  ADC_CSEL_RES_REG;        // 0x24: ADC Channel Selection and Resolution register
      UInt32  ADC_INT_ENABLE_REG;      // 0x28: ADC Interrupt Enable register
      UInt32  ADC_INT_STATUS_REG;      // 0x2C: ADC Interrupt Status register
      UInt32  ADC_INT_CLEAR_REG;       // 0x30: ADC Interrupt Clear register
      UInt32  _d3;                     // 0x34: Dummy regs

} vhssa1adcRegs, *pvhssa1adcRegs;

#endif // ASM_INCLUDE

// ----------------------------------------------------------
// ADC R0 Data Register (0x00) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_R0_STATUS_POS              0
#define VH_ADC_R0_STATUS_LEN             10
#define VH_ADC_R0_STATUS_MSK     0x000003FF
// Bits [31:10] reserved

// ----------------------------------------------------------
// ADC R1 Data Register (0x04) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_R1_STATUS_POS              0
#define VH_ADC_R1_STATUS_LEN             10
#define VH_ADC_R1_STATUS_MSK     0x000003FF
// Bits [31:10] reserved

// ----------------------------------------------------------
// ADC R2 Data Register (0x08) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_R2_STATUS_POS              0
#define VH_ADC_R2_STATUS_LEN             10
#define VH_ADC_R2_STATUS_MSK     0x000003FF
// Bits [31:10] reserved

// ----------------------------------------------------------
// ADC R3 Data Register (0x0C) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_R3_STATUS_POS              0
#define VH_ADC_R3_STATUS_LEN             10
#define VH_ADC_R3_STATUS_MSK     0x000003FF
// Bits [31:10] reserved

// ----------------------------------------------------------
// ADC R4 Data Register (0x10) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_R4_STATUS_POS              0
#define VH_ADC_R4_STATUS_LEN             10
#define VH_ADC_R4_STATUS_MSK     0x000003FF
// Bits [31:10] reserved

// ----------------------------------------------------------
// ADC R5 Data Register (0x14) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_R5_STATUS_POS              0
#define VH_ADC_R5_STATUS_LEN             10
#define VH_ADC_R5_STATUS_MSK     0x000003FF
// Bits [31:10] reserved

// ----------------------------------------------------------
// ADC R6 Data Register (0x18) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_R6_STATUS_POS              0
#define VH_ADC_R6_STATUS_LEN             10
#define VH_ADC_R6_STATUS_MSK     0x000003FF
// Bits [31:10] reserved

// ----------------------------------------------------------
// ADC R7 Data Register (0x1C) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_R7_STATUS_POS              0
#define VH_ADC_R7_STATUS_LEN             10
#define VH_ADC_R7_STATUS_MSK     0x000003FF
// Bits [31:10] reserved

// ----------------------------------------------------------
// ADC CON Data Register (0x20) - Read/Write
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_CON_ADC_SELREF_STATUS_POS              0
#define VH_ADC_CON_ADC_SELREF_STATUS_LEN              1
#define VH_ADC_CON_ADC_SELREF_STATUS_MSK     0x00000001

#define VH_ADC_CON_ADC_ENABLE_STATUS_POS              1
#define VH_ADC_CON_ADC_ENABLE_STATUS_LEN              1
#define VH_ADC_CON_ADC_ENABLE_STATUS_MSK     0x00000002

#define VH_ADC_CON_ADC_CSCAN_STATUS_POS               2
#define VH_ADC_CON_ADC_CSCAN_STATUS_LEN               1
#define VH_ADC_CON_ADC_CSCAN_STATUS_MSK      0x00000004


#define VH_ADC_CON_ADC_START_STATUS_POS               3
#define VH_ADC_CON_ADC_START_STATUS_LEN               1
#define VH_ADC_CON_ADC_START_STATUS_MSK      0x00000008

//  Read Only
#define VH_ADC_CON_ADC_STATUS_STATUS_POS              4
#define VH_ADC_CON_ADC_STATUS_STATUS_LEN              1
#define VH_ADC_CON_ADC_STATUS_STATUS_MSK     0x00000010

// Bits [31:5] reserved

// ----------------------------------------------------------
// ADC CSEL-RES Data Register (0x24) - Read/Write
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_CON_ADC_CSEL0_STATUS_POS               0
#define VH_ADC_CON_ADC_CSEL0_STATUS_LEN               4
#define VH_ADC_CON_ADC_CSEL0_STATUS_MSK      0x0000000F

#define VH_ADC_CON_ADC_CSEL1_STATUS_POS               4
#define VH_ADC_CON_ADC_CSEL1_STATUS_LEN		      4
#define VH_ADC_CON_ADC_CSEL1_STATUS_MSK      0x000000F0

#define VH_ADC_CON_ADC_CSEL2_STATUS_POS	              8
#define VH_ADC_CON_ADC_CSEL2_STATUS_LEN	              4
#define VH_ADC_CON_ADC_CSEL2_STATUS_MSK	     0x00000F00

#define VH_ADC_CON_ADC_CSEL3_STATUS_POS	             12
#define VH_ADC_CON_ADC_CSEL3_STATUS_LEN	              4
#define VH_ADC_CON_ADC_CSEL3_STATUS_MSK	     0x0000F000

#define VH_ADC_CON_ADC_CSEL4_STATUS_POS	             16
#define VH_ADC_CON_ADC_CSEL4_STATUS_LEN	              4
#define VH_ADC_CON_ADC_CSEL4_STATUS_MSK	      0x000F000

#define VH_ADC_CON_ADC_CSEL5_STATUS_POS	             20
#define VH_ADC_CON_ADC_CSEL5_STATUS_LEN	              4
#define VH_ADC_CON_ADC_CSEL5_STATUS_MSK	      0x00F0000

#define VH_ADC_CON_ADC_CSEL6_STATUS_POS	             24
#define VH_ADC_CON_ADC_CSEL6_STATUS_LEN	              4
#define VH_ADC_CON_ADC_CSEL6_STATUS_MSK	      0x0F00000

#define VH_ADC_CON_ADC_CSEL7_STATUS_POS	             28
#define VH_ADC_CON_ADC_CSEL7_STATUS_LEN	              4
#define VH_ADC_CON_ADC_CSEL7_STATUS_MSK	      0xF000000

// Bits [31:20] reserved

// ----------------------------------------------------------
// ADC INT-ENABLE Data Register (0x28) - Read/Write
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_CON_ADC_INT_ENABLE_STATUS_POS		   0
#define VH_ADC_CON_ADC_INT_ENABLE_STATUS_LEN		   1
#define VH_ADC_CON_ADC_INT_ENABLE_STATUS_MSK	  0x00000001

// Bits [31:1] reserved

// ----------------------------------------------------------
// ADC INT-STATUS Data Register (0x2C) - Read Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_CON_ADC_INT_STATUS_STATUS_POS		     0
#define VH_ADC_CON_ADC_INT_STATUS_STATUS_LEN		     1
#define VH_ADC_CON_ADC_INT_STATUS_STATUS_MSK	    0x00000001

// Bits [31:1] reserved

// ----------------------------------------------------------
// ADC INT-CLEAR Data Register (0x30) - Write Only
// ----------------------------------------------------------
// Bitfields
#define VH_ADC_CON_ADC_INT_CLEAR_STATUS_POS		       0
#define VH_ADC_CON_ADC_INT_CLEAR_STATUS_LEN		       1
#define VH_ADC_CON_ADC_INT_CLEAR_STATUS_MSK	      0x00000001

// Bits [31:1] reserved


#ifndef ASM_INCLUDE
// ----------------------------------------------------------------------------
// Generic Types
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// Global variables
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// Function Prototypes (Exported)
// ----------------------------------------------------------------------------


#endif // ASM_INCLUDE

#ifdef __cplusplus
}
#endif

#endif // _VH_SSA1ADC_H_

// ----------------------------------------------------------------------------
// End of vHAL include
// ----------------------------------------------------------------------------
