/* basil_s1.h
 *	Definitions for the Basil-S1 board.
 */

#if !defined(_basil_s1_H_)
#define _basil_s1_H_

#define FOR_PHASE2

#define	TX4925REG_BASE_PHYS	0x12000000
#define	TX4925REG_BASE		0xB2000000
#define	TX4925_REG(x)		(TX4925REG_BASE + (x))
#define	TX4925_SDRAMC_BASE	0x8000
#define	TX4925_EBUSC_BASE	0x9000
#define	TX4925_CONFIG_BASE	0xe000
#define	TX4925_PIO_BASE		0xf500
#define	TX4925_IRC_BASE		0xf510

#define	CCFG_MASK	0xF8FE3FCC
#define	PCFG_MASK	0x038000F0
#define	PDNCTR_MASK	0xAC000000
#define	GARBP_MASK	0xFFFF8000
#define	TOCNT_MASK	0xFFFF0000
#define	DRQCTR_MASK	0xFFFF0000
#define	CLKCTR_MASK	0xF000F000
#define	GARBC_MASK	0xFFFFE000
#define	RAMP_MASK	0xFFFF0000

#if defined(FOR_PHASE2)
#define	DEF_CCFG	0x18B680B5
#if 0	/* modified PCICLK2 is disabled */
#define	DEF_PCFG	0xBC207000
#else
#define	DEF_PCFG	0xAC207000
#endif
#define	DEF_PDNCTR	0x00330000
#define	DEF_GARBP	0x00003501
#define	DEF_TOCNT	0x0000ffff
#define	DEF_DRQCTR	0x00009B8A
#define	DEF_CLKCTR	0x0DF50DFF
#define	DEF_GARBC	0x0000001F
#define	DEF_RAMP	((TX4925REG_BASE_PHYS >> 16) & 0xFFFF)

#define	DEF_PIODO	0x00080008
#define DEF_PIODIR	0x07BA3A2A
#define DEF_PIOOD	0x07BA3A2A

#define	DEF_EBBAR0	0x1FC00000
#define	DEF_EBBAR1	0x1EC00000
#define	DEF_EBBAR2	0x14000000
#define	DEF_EBBAR3	0x13100000
#define	DEF_EBBAR4	0x13400000
#define	DEF_EBBAR5	0x13500000
#define	DEF_EBBAR6	0x13600000
#define	DEF_EBBAR7	0x13700000

#define	DEF_EBCCR0	0x00602228
#define	DEF_EBCCR1	0x00603228
#define	DEF_EBCCR2	0x00602428
#define	DEF_EBCCR3	0x00601029
#define	DEF_EBCCR4	0x00600037
#define	DEF_EBCCR5	0x00600037
#define	DEF_EBCCR6	0x00600037
#define	DEF_EBCCR7	0x00600037

#else	/* FOR_PHASE1 */
#define	DEF_CCFG	0x00018031
#define	DEF_PCFG	0x3C2C7000
#define	DEF_PDNCTR	0x00330000
#define	DEF_GARBP	0x00003501
#if 0
#define	DEF_TOCNT	0x00000040
#else
#define	DEF_TOCNT	0x0000ffff
#endif
#define	DEF_DRQCTR	0x00009B8A
#define	DEF_CLKCTR	0x0DF50DFF
#define	DEF_GARBC	0x00000010
#if 1
#define	DEF_RAMP	((TX4925REG_BASE_PHYS >> 16) & 0xFFFF)
#else
#define	DEF_RAMP	((TX4925REG_BASE >> 16) & 0xFFFF)
#endif

#define	DEF_PIODO	0x00000000
#define DEF_PIODIR	0xB6AE0A28
#define DEF_PIOOD	0xB6AE0A28

#define	DEF_EBBAR0	0x1FC00000
#define	DEF_EBBAR1	0x1E000000
#define	DEF_EBBAR2	0x13000000
#define	DEF_EBBAR3	0x1D000000
#define	DEF_EBBAR4	0x13100000
#define	DEF_EBBAR5	0x1C000000
#define	DEF_EBBAR6	0x14000000
#define	DEF_EBBAR7	0x18000000

#define	DEF_EBCCR0	0x00605228
#define	DEF_EBCCR1	0x00605428
#define	DEF_EBCCR2	0x00605039
#define	DEF_EBCCR3	0x00605438
#define	DEF_EBCCR4	0x00600037
#define	DEF_EBCCR5	0x00600037
#define	DEF_EBCCR6	0x03630629
#define	DEF_EBCCR7	0x03E30629
#endif	/* FOR_PHASE2 */

#define	DEF_PCIMEM_GBUS	0x10000000
#define	DEF_PCIMEM_PCI	DEF_PCIMEM_GBUS
#define	DEF_PCIMEM_SIZE	(16 * 1024 * 1024)

#define	DEF_PCIIO_GBUS	0x11800000
#define	DEF_PCIIO_PCI	DEF_PCIIO_GBUS
#define	DEF_PCIIO_SIZE	(8 * 1024 * 1024)

#if 0
#define	BDSTS		((DEF_EBBAR2|0xA0000000) + 0x00)
#define	DEVCTL		((DEF_EBBAR2|0xA0000000) + 0x04)
#define	DISPCNT		((DEF_EBBAR2|0xA0000000) + 0x08)
#define	CARDSTS		((DEF_EBBAR2|0xA0000000) + 0x10)
#define	CARDCTL		((DEF_EBBAR2|0xA0000000) + 0x14)

#define	DEF_DEVCTL	0x00FF
#define	DEF_DISPCNT	0x31FF
#endif

#define BASIL_S1_MASTERCLK	18432000


#define TX4925_RD(reg)		(*(volatile unsigned long*)(TX4925_REG(reg)))
#define TX4925_WR(reg, val)	((*(volatile unsigned long*)(TX4925_REG(reg))) = (val))

#define TX4925_PIO_BASE		0xf500
#define TX4925_PIO_PIODO	TX4925_PIO_BASE
#define TX4925_PIO_PIODI	0xf504


/* LED */
#define LED_YELLOW		(1 << 3)
#define LED_ORANGE		(1 << 19)
#define LED_RED			(1 << 20)
#define LED_ALL			(LED_YELLOW | LED_ORANGE | LED_RED)

#define LED_YELLOW_ON		{unsigned long pio;	\
				pio = TX4925_RD(TX4925_PIO_PIODO);	\
				pio &= ~(LED_YELLOW);	\
				TX4925_WR(TX4925_PIO_PIODO, pio); }
#define LED_YELLOW_OFF		{unsigned long pio;	\
				pio = TX4925_RD(TX4925_PIO_PIODO);	\
				pio |= (LED_YELLOW);	\
				TX4925_WR(TX4925_PIO_PIODO, pio); }

#define LED_ORANGE_ON		{unsigned long pio;	\
				pio = TX4925_RD(TX4925_PIO_PIODO);	\
				pio &= ~(LED_ORANGE);	\
				TX4925_WR(TX4925_PIO_PIODO, pio); }
#define LED_ORANGE_OFF		{unsigned long pio;	\
				pio = TX4925_RD(TX4925_PIO_PIODO);	\
				pio |= (LED_ORANGE);	\
				TX4925_WR(TX4925_PIO_PIODO, pio); }

#define LED_RED_ON		{unsigned long pio;	\
				pio = TX4925_RD(TX4925_PIO_PIODO);	\
				pio &= ~(LED_RED);	\
				TX4925_WR(TX4925_PIO_PIODO, pio); }
#define LED_RED_OFF		{unsigned long pio;	\
				pio = TX4925_RD(TX4925_PIO_PIODO);	\
				pio |= (LED_RED);	\
				TX4925_WR(TX4925_PIO_PIODO, pio); }

/* DIPSW */
#define DIPSW1			(1 << 27)
#define DIPSW2			(1 << 30)
#define DIPSW3			(1 << 31)

#define DIPSW1_OFF		(TX4925_RD(TX4925_PIO_PIODI) & DIPSW1)
#define DIPSW1_ON		(!DIPSW1_OFF)
#define DIPSW2_OFF		(TX4925_RD(TX4925_PIO_PIODI) & DIPSW2)
#define DIPSW2_ON		(!DIPSW2_OFF)
#define DIPSW3_OFF		(TX4925_RD(TX4925_PIO_PIODI) & DIPSW3)
#define DIPSW3_ON		(!DIPSW3_OFF)


#endif	/* _basil_s1_H_ */
