/*
 * filesyste/util.h
 *
 */

#if	!defined(_FILESYSTEM_UTIL_H_)
#define	_FILESYSTEM_UTIL_H_


/**********************************************************
 * Grobal Definition
 */

#define BASENAME_LEN	8
#define EXTNAME_LEN		3


/**********************************************************
 * MACRO definition
 */


/*
 * CHS buffer -> Cylinder, Header, Sector
 *       b : CHS buffer  :: char [3]
 *       c : cylinder    :: u16
 *       h : header      :: u8
 *       s : sector      :: u8
 */
#define SPLIT_CHS(b, c, h, s)						\
	(c) = (((u16)((b)[1] & 0xC0) << 2) | (b)[2]);	\
	(h) = (b)[0];									\
	(s) = ((b)[1] & 0x3F);



int split_filename(const char *path, char *base, char *ext);



/*
 * There are functions for debug
 */
#if defined(SDBOOT_DEBUG)

void dump_PartitionEntry(PartitionEntry *pe);
void dump_Bpb50(Bpb50 *bpb);
void dump_Direntry(Direntry *dir);
void dump_Fat_fs(Fat_fs *fs);
void dump_Sector(const char *sector);
int dump_FAT(Fat_fs* fs, const char *fat);

#else

#define dump_PartitionEntry(pe)
#define dump_Bpb50(bpb)
#define dump_Direntry(dir)
#define dump_Fat_fs(fs)
#define dump_Sector(sector)
#define dump_FAT(fs, fat)

#endif	/* defined(SDBOOT_DEBUG) */


#endif	/* !defined(_FILESYSTEM_UTIL_H_) */
