/*
 * filesyste/util.c
 *
 */

#include "config.h"

#include <asm/page.h>
#include <asm/byteorder.h>

#include "nonstdio.h"
#include "fat.h"
#include "util.h"

#include "../sd/sdmem.h"




/**********************************************************
 * split filename to basename and extension
 *
 * Params
 *       path : filename to split
 *       base : buffer to store basename
 *       ext : buffer to store extionsion
 *
 * Return
 *       0:SUCCESS
 *       other:FAILD
 *
 * Limitation
 *       support 8.3 formated filename only.
 *       filename with directory path is not supported.
 */
int split_filename(const char *path, char *base, char *ext)
{
	char *p = path;
	int i;

	/* fill buffer with space */
	memset(base, ' ', BASENAME_LEN);
	memset(ext, ' ', EXTNAME_LEN);

	/* parse basename */
	for (i = 0; i < BASENAME_LEN; i++) {
		/* check "." delimiter */
		if (*p == '.') {
			p++;
			break;
		}
		/* support code CP932
		 * if there is 0xE5 in 1st byte, modify to 0x05.
		 */
		if ((i == 0) && (*p == SLOT_DELETED)) {
			base[i] = SLOT_E5;
		} else {
			base[i] = *p;
		}
		p++;
	}
	/* parse extention */
	for ( i = 0; i < EXTNAME_LEN; i++) {
		if (*p == NULL) {
			break;
		}
		ext[i] = *p;
		p++;
	}

	/* DEBUG */
	DBG_PRINT("Path:[%s] -> Base[%c%c%c%c%c%c%c%c],Ext[%c%c%c]\n",
		path, base[0], base[1], base[2], base[3], base[4], base[5], base[6], base[7],
		ext[0], ext[1], ext[2]);

	return OK;
}
