/*
 * NS16550 support
 */

#include <linux/config.h>
#include "basil_s1.h"
#include "ns16550.h"

typedef unsigned char uint8;
typedef unsigned int uint32;

#define	DEF_BAUD	38400
#define BASE		0xb3100000
#define	CLOCK		4915200
#define TX		0
#define RX		0
#define	DLLO		0
#define	DLHI		1
#define	IENB		1
#define	IID		2
#define	FCR		2
#define	LINECTL		3
#define MODCTL		4
#define	LSTAT		5
#define	MODSTAT		6
#define	SCRATCH		7

#define UART_GETREG(x, dp, reg) \
	x = *((volatile unsigned char *)(dp + (reg * 4)))
#define UART_PUTREG(x, dp, reg) \
	*((volatile unsigned char *)(dp + (reg * 4))) = x

volatile struct NS16550 *
serial_init(int chan)
{
    /* disable interrupts */
    UART_PUTREG(0, BASE, IENB);

    /* set up baud rate */
    {
        uint32 divisor;
        /* set DIAB bit */
        UART_PUTREG(0x80, BASE, LINECTL);
        /* set divisor */
        divisor = (CLOCK + DEF_BAUD * 8) / (DEF_BAUD * 16);
        UART_PUTREG((divisor & 0xFF), BASE, DLLO);
        UART_PUTREG(((divisor >> 8) & 0xFF), BASE, DLHI);
        /* clear DIAB bit */
        UART_PUTREG(0, BASE, LINECTL);
    }
    /* set data format */
    UART_PUTREG(0x03, BASE, LINECTL);
    UART_PUTREG(0x07, BASE, FCR);

    return((struct NS16550 *)BASE);
}

unsigned char
serial_getc(volatile struct NS16550 *com_port)
{
    uint8  lsr_reg, c;

    do {
        UART_GETREG(lsr_reg, (unsigned long)com_port, LSTAT);
    } while ((lsr_reg & LSR_DR) == 0);
    UART_GETREG(c, (unsigned long)com_port, RX);
    return(c);
}

void
serial_putc(volatile struct NS16550 *com_port, unsigned char c)
{
    uint8  lsr_reg;

    do {
        UART_GETREG(lsr_reg, (unsigned long)com_port, LSTAT);
    } while ((lsr_reg & LSR_THRE) == 0);
    UART_PUTREG(c, (unsigned long)com_port, TX);
}

int
serial_tstc(volatile struct NS16550 *com_port)
{
    uint8  lsr_reg;

    UART_GETREG(lsr_reg, (unsigned long)com_port, LSTAT);
	return ((com_port->lsr & LSR_DR) != 0);
}
