/*
 * main.c
 *
 * Copyright (C) 2002 MONTAVISTA SOFTWARE JAPAN. All rights reserved.
 * Written by akira ishitsuka
 *
 * history
 * 2003/04/11  A.I.   1.01    added retry code in init_sd().
 * 2003/04/25  A.I.   1.02    force set 0x0000 to PORTSEL in detect DIPSW3.
 * 2003/05/20  A.I.   1.03    change LED On/Off condition.
 *
 **************************************************************************
 *  
 **************************************************************************
 */

#include <linux/config.h>

#include "config.h"
#include "basil_s1.h"
#include "ns16550.h"

#include "../sd/sdbd.h"
#include "../sd/sdhc.h"
#include "../sd/sdmem.h"


#include <asm/page.h>

#if 0
#include "../filesystem/file.h"
#else
#include "../filesystem/fat.h"
#endif

#include "zlib.h"


extern struct NS16550 *com_port;
extern volatile struct NS16550 *serial_init(int chan);

unsigned int kernel_entry;
unsigned char *kernel_base;
unsigned int kernel_size;

extern char *avail_ram;
extern char *end_avail;


void led_on(unsigned long led)
{
	unsigned long piodo;
	piodo = TX4925_RD(TX4925_PIO_PIODO);
	/* LED ALL OFF */
	piodo |= LED_ALL;
	piodo &= ~(led);
	TX4925_WR(TX4925_PIO_PIODO, piodo);
}

void led_off(unsigned long led)
{
	unsigned long piodo;
	piodo = TX4925_RD(TX4925_PIO_PIODO);
	/* LED ALL OFF */
	piodo |= led;
	TX4925_WR(TX4925_PIO_PIODO, piodo);
}


int init_sd(void)
{
	long ret;
#if 1	/* rev 1.01 */
	int retry = BOOT_SD_RETRY;

RETRY:
#endif
	/* init SD Host Contoroller */
	puts("Initialize SD Host Controller...");
	SDHC_Init();
	puts("done\n");

	if (DIPSW3_OFF) {
		/* select backword port */
		puts("DIPSW-3 is OFF\n");
		SDHC_SD_PORTSEL = 0x0001;
	} else {
		puts("DIPSW-3 is ON\n");
#if 1	/* rev 1.02 */
		SDHC_SD_PORTSEL = 0x0000;
#endif
	}

	/* Init SD Memory Card */
	puts("Initialize SD Memory Card...");
	ret = SDmem_CardInit();
	if(ret) {
		/* error */
#if 1	/* rev 1.01 */
		PRINTF("retry: %x\n", ret);
		if (retry-- > 0) {
			SD_WaitTimer(100);
			goto RETRY;
		}
#endif
		PRINTF("faild: %x\n", ret);
		goto ERROR;
	}
	puts("done\n");

	return 0;
ERROR:
	return -1;
}


void boot_init(void)
{
#if 1	/* rev 1.03 */
	led_on(LED_ALL);
#else
	led_off(LED_ALL);
#endif
	/* initialize Debug Serial */
	com_port = (struct NS16550*)serial_init(0);
	puts("Checking Kernel Writing Flag.\n");
#if 1	/* for Debug */
	PRINTF("kernel writing flag(0x%x) is %x\n",
		KERNEL_WFLG_ADDR, *((volatile unsigned long*)KERNEL_WFLG_ADDR));
#endif
}


void load_kernel(void)
{
	unsigned char *work_base;
	unsigned int work_size;
#if 0
	struct file fp;
#else
	File fp;
#endif
#if 1	/* rev 1.01 */
	int retry = BOOT_SD_RETRY;

RETRY:
#endif
	if (init_sd()) {
		/* error */
#if 1	/* rev 1.03 */
		led_off(LED_YELLOW);
#else
		led_on(LED_YELLOW);
#endif
		return;
	}

	/* initialize filesystem, partitions */
	puts("Initialize FAT filesystem ... ");
#if 0
	if(file_open(&fp)) {
		/* error */
		puts("error\n");
#if 1	/* rev 1.03 */
		led_off(LED_ORANGE);
#else
		led_on(LED_ORANGE);
#endif
		return;
	}
#else
	if (init_fat_fs()) {
		/* error */
		puts("error\n");
#if 1	/* rev 1.03 */
		led_off(LED_ORANGE);
#else
		led_on(LED_ORANGE);
#endif
		return;
	}
#endif
	puts("done\n");

#if 0
	/* read kernel image from SD Card */
	puts("Read vmlinux.bin from SD Card... ");
	if (file_read(&fp, "VMLINUX.BIN", 0)) {
		/* error */
		puts("error\n");
		led_on(LED_RED);
		return;
	}
	puts("done\n");
#else
	/* open kernel image from SD Card */
	puts("Open vmlinux.bin from SD Card... ");
	if (open_file(&fp, "VMLINUX.BIN")) {
		/* error */
		puts("error\n");
#if 1	/* rev 1.03 */
		led_off(LED_RED);
#else
		led_on(LED_RED);
#endif
		return;
	}
	puts("done\n");
	/* read kernel image from SD Card */
	puts("Read vmlinux.bin from SD Card... ");
	if (read_file(&fp, (u8 *)AVAIL_FILEIMAGE_START)) {
		/* error */
#if 1	/* rev 1.01 */
		PRINTF("retry\n");
		if (retry-- > 0) {
			SD_WaitTimer(1000);
			goto RETRY;
		}
#endif
		puts("error\n");
#if 1	/* rev 1.03 */
		led_off(LED_RED);
#else
		led_on(LED_RED);
#endif
		return;
	}
	puts("done\n");
#endif

	/* assume the chunk below 8M is free */
	avail_ram = (char *)AVAIL_RAM_START;
	end_avail = (char *)AVAIL_RAM_END;

	work_base = (char *)AVAIL_FILEIMAGE_START;
	work_size = kernel_size;

	PRINTF("work %x @ %x, compressed kernel %x @ %x\n",
		avail_ram, end_avail, work_base, work_base + work_size);
	puts("Uncompressing Linux at load address ");
	puthex(kernel_base);
	puts("\n");
	gunzip((void*)kernel_base, 0x400000, work_base, &work_size);

#if 0	/* ishi */
	for (work_base = (unsigned char*)kernel_entry; work_base < (unsigned char*)kernel_entry + 0x200; work_base++) {
		if (!((unsigned long)work_base % 16)) {
			DBG_PRINT("\n");
		}
		DBG_PRINT("%x ", *work_base);
	}
	DBG_PRINT("\n");
#endif
	PRINTF("Now booting the kernle at 0x%x...\n\n", kernel_entry);
}

