/*
 * arch/mips/zboot/basil_s1/head.S
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1994, 1995 Waldorf Electronics
 * Written by Ralf Baechle and Andreas Busse
 * Copyright (C) 1995 - 1999 Ralf Baechle
 * Copyright (C) 1996 Paul M. Antoine
 * Modified for DECStation and hence R3000 support by Paul M. Antoine
 * Further modifications by David S. Miller and Harald Koerfgen
 * Copyright (C) 1999 Silicon Graphics, Inc.
 *
 * Head.S contains the MIPS exception handler and startup code.
 *
 **************************************************************************
 *  9 Nov, 2000.
 *  Added Cache Error exception handler and SBDDP EJTAG debug exception.
 *
 *  Kevin Kissell, kevink@mips.com and Carsten Langgaard, carstenl@mips.com
 *  Copyright (C) 2000 MIPS Technologies, Inc.  All rights reserved.
 **************************************************************************
 */
#include <linux/config.h>
#include <linux/threads.h>

#include <asm/asm.h>
#include <asm/cacheops.h>
#include <asm/current.h>
#include <asm/offset.h>
#include <asm/processor.h>
#include <asm/regdef.h>
#include <asm/cachectl.h>
#include <asm/mipsregs.h>
#include <asm/stackframe.h>
#include <asm/cacheops.h>

#include "basil_s1.h"

	.set noreorder
	.cprestore
	LEAF(start)
start:

locate:
	la	sp, (.stack+(4096*2)-24)
	move	s0, a0
	move	s1, a1
	move	s2, a2
	move	s3, a3

	li	t0, 0xa0000000
	or	sp, t0

	li	t0, ST0_BEV
	mtc0	t0, CP0_STATUS
	mtc0	zero, CP0_CAUSE

	mfc0	t0, CP0_CONFIG
	and	t0, ~(TX49_CONF_IC | TX49_CONF_DC | CONF_CM_CMASK)
	or	t0, CONF_CM_CACHABLE_NONCOHERENT
	mtc0    t0, CP0_CONFIG
	nop

	.set push
	.set mips3
/*
 * TX4925 Setup
 */
	/* CFG */
	la	t0, 0xFF1FE000
	/* - RAMP - */
	li	t1, DEF_RAMP
	sw	t1, 0x30(t0)

	la	t0, TX4925_REG(TX4925_CONFIG_BASE)
	/* - CCFG - */
	lw	t1, 0x00(t0)
	li	t2, CCFG_MASK
	and	t1, t2
	li	t2, DEF_CCFG
	or	t1, t2
	sw	t1, 0x00(t0)

	/* - PCFG - */
	lw	t1, 0x08(t0)
	li	t2, PCFG_MASK
	and	t1, t2
	li	t2, DEF_PCFG
	or	t1, t2
	sw	t1, 0x08(t0)

	/* - PDNCTR - */
	lw	t1, 0x10(t0)
	li	t2, PDNCTR_MASK
	and	t1, t2
	li	t2, DEF_PDNCTR
	or	t1, t2
	sw	t1, 0x10(t0)

	/* - GARBP - */
	lw	t1, 0x18(t0)
	li	t2, GARBP_MASK
	and	t1, t2
	li	t2, DEF_GARBP
	or	t1, t2
	sw	t1, 0x18(t0)

	/* - TOCNT - */
	lw	t1, 0x20(t0)
	li	t2, TOCNT_MASK
	and	t1, t2
	li	t2, DEF_TOCNT
	or	t1, t2
	sw	t1, 0x20(t0)

	/* - DRQCTR - */
	lw	t1, 0x24(t0)
	li	t2, DRQCTR_MASK
	and	t1, t2
	li	t2, DEF_DRQCTR
	or	t1, t2
	sw	t1, 0x24(t0)

	/* - CLKCTR - */
	lw	t1, 0x28(t0)
	li	t2, CLKCTR_MASK
	and	t1, t2
	li	t2, DEF_CLKCTR
	or	t1, t2
	sw	t1, 0x28(t0)

	/* - GARBC - */
	lw	t1, 0x2C(t0)
	li	t2, GARBC_MASK
	and	t1, t2
	li	t2, DEF_GARBC
	or	t1, t2
	sw	t1, 0x2C(t0)

	/* IRC */
	la	t0, TX4925_REG(TX4925_IRC_BASE)
	li	t1, 0
	sw	t1, 0x00(t0)		/* IRDEN */

	/* PIO */
	la	t0, TX4925_REG(TX4925_PIO_BASE)
	li	t1, DEF_PIODIR
	sw	t1, 0x08(t0)		/* XPIODIR */
	li	t1, DEF_PIOOD
	sw	t1, 0x0c(t0)		/* XPIOOD */
	li	t1, DEF_PIODO
	sw	t1, 0x00(t0)		/* XPIODO */

	/* EBUSC(ROMC) */
	la	t0, TX4925_REG(TX4925_EBUSC_BASE)

	li	t1, DEF_EBCCR0
	li	t2, DEF_EBBAR0
	sw	t1, 0x00(t0)		/* EBCCR0 */
	sw	t2, 0x04(t0)		/* EBCBA0 */

	li	t1, DEF_EBCCR1
	li	t2, DEF_EBBAR1
	sw	t1, 0x08(t0)		/* EBCCR1 */
	sw	t2, 0x0C(t0)		/* EBCBA1 */

	li	t1, DEF_EBCCR2
	li	t2, DEF_EBBAR2
	sw	t1, 0x10(t0)		/* EBCCR2 */
	sw	t2, 0x14(t0)		/* EBCBA2 */

	li	t1, DEF_EBCCR3
	li	t2, DEF_EBBAR3
	sw	t1, 0x18(t0)		/* EBCCR3 */
	sw	t2, 0x1C(t0)		/* EBCBA3 */

	li	t1, DEF_EBCCR4
	li	t2, DEF_EBBAR4
	sw	t1, 0x20(t0)		/* EBCCR4 */
	sw	t2, 0x24(t0)		/* EBCBA4 */

	li	t1, DEF_EBCCR5
	li	t2, DEF_EBBAR5
	sw	t1, 0x28(t0)		/* EBCCR5 */
	sw	t2, 0x2C(t0)		/* EBCBA5 */

	li	t1, DEF_EBCCR6
	li	t2, DEF_EBBAR6
	sw	t1, 0x30(t0)		/* EBCCR6 */
	sw	t2, 0x34(t0)		/* EBCBA6 */

	li	t1, DEF_EBCCR7
	li	t2, DEF_EBBAR7
	sw	t1, 0x38(t0)		/* EBCCR7 */
	sw	t2, 0x3C(t0)		/* EBCBA7 */

	/* SDRAMC */
	la	t0, TX4925_REG(TX4925_SDRAMC_BASE)
#if defined(FOR_PHASE2)
	li	t1, 0xBE402240		/* refresh:240 */
#else
	li	t1, 0xBE002240		/* refresh:240 */
#endif
	sw	t1, 0x20(t0)		/* SDCTR */
#if defined(FOR_PHASE2)
	li	t1, 0x0000FE22
#else
	li	t1, 0x0000FE24
#endif
	sw	t1, 0x00(t0)		/* SDCCR0 */
	li	t1, 0x00000013		/* All Precharge (ch0) */
	sw	t1, 0x2c(t0)		/* SDCCMD */
	li	t1, 0x00000011		/* Set Mode Reg (ch0) */
	sw	t1, 0x2c(t0)		/* SDCCMD */

#if defined(FOR_PHASE2)
	li	t1, 0x0800FC24
	sw	t1, 0x04(t0)		/* SDCCR1 */
	li	t1, 0x00000013		/* All Precharge (ch0) */
	sw	t1, 0x2c(t0)		/* SDCCMD */
	li	t1, 0x00000011		/* Set Mode Reg (ch0) */
	sw	t1, 0x2c(t0)		/* SDCCMD */

	li	t1, 0x0800FC24
	sw	t1, 0x08(t0)		/* SDCCR2 */
	li	t1, 0x00000013		/* All Precharge (ch0) */
	sw	t1, 0x2c(t0)		/* SDCCMD */
	li	t1, 0x00000011		/* Set Mode Reg (ch0) */
	sw	t1, 0x2c(t0)		/* SDCCMD */

	li	t1, 0x0800FC24
	sw	t1, 0x0C(t0)		/* SDCCR3 */
	li	t1, 0x00000013		/* All Precharge (ch0) */
	sw	t1, 0x2c(t0)		/* SDCCMD */
	li	t1, 0x00000011		/* Set Mode Reg (ch0) */
	sw	t1, 0x2c(t0)		/* SDCCMD */
#endif
	/* wait at least 8 auto refreshes */
	la	t0, TX4925_REG(TX4925_SDRAMC_BASE)
	lw	t1, 0x20(t0)		/* SDCTR */
	li	t2, 0x007c0000
	not	t2
	and	t1, t2
	or	t1, 0x00200000		/* 16 times */
	sw	t1, 0x20(t0)		/* SDCTR */
1:	lw	t1, 0x20(t0)		/* SDCTR */
	and	t1, 0x007c0000
	bnez	t1, 1b
	nop

#if !defined(FOR_PHASE2)
	/* Basil-S1 I/O Port */
	la	t0, DEVCTL
	li	t1, DEF_DEVCTL
	sh	t1, 0x02(t0)

	la	t0, DISPCNT
	li	t1, DEF_DISPCNT
	sh	t1, 0x02(t0)
#endif

	.set mips2
	.set pop

/*
 * Cache Initialize
 */
	mtc0	zero, CP0_TAGLO
	mtc0	zero, CP0_TAGHI
	nop
	nop

	/* I-Cache Initialize */
	li	a0, 0x80000000
	li	a1, (32 * 1024)		/* icache size (32KB) */
	srl	a1, 2			/* 4way are processed for each address */
	addu	a1, a0			/* limit = base + size */

	.set mips3
2:	cache	Index_Store_Tag_I, 0(a0)	/* clear Tag */
	cache	Index_Store_Tag_I, 1(a0)
	cache	Index_Store_Tag_I, 2(a0)
	cache	Index_Store_Tag_I, 3(a0)
	nop
	cache	Fill, 0(a0)		/* fill line */
	cache	Fill, 1(a0)
	cache	Fill, 2(a0)
	cache	Fill, 3(a0)
	nop
	cache	Index_Store_Tag_I, 0(a0)	/* clear Tag */
	cache	Index_Store_Tag_I, 1(a0)
	cache	Index_Store_Tag_I, 2(a0)
	cache	Index_Store_Tag_I, 3(a0)
	nop
	.set mips2

	addi	a0, 32
	bne	a0, a1, 2b
	nop

	/* D-Cache Initialize */
	li	a0, 0x80000000
	li	a1, (32 * 1024)		/* dcache size (32KB) */
	srl	a1, 2			/* 4way are processed for each address */
	addu	a1, a0			/* limit = base + size */

	.set mips3
31:	cache	Index_Store_Tag_D, 0(a0)	/* clear Tag */
	cache	Index_Store_Tag_D, 1(a0)
	cache	Index_Store_Tag_D, 2(a0)
	cache	Index_Store_Tag_D, 3(a0)
	nop
	.set mips2

	addi	a0, 32
	bne	a0, a1, 31b
	nop
	
	li	a0, 0x80000000
	li	a1, (32 * 1024)		/* dcache size (32KB) */
	addu	a1, a0			/* limit = base + size */
32:	addi	a0, 32
	bne	a0, a1, 32b
	lw	zero, -4(a0)		/* fill line */

	li	a0, 0x80000000
	li	a1, (32 * 1024)		/* dcache size (32KB) */
	srl	a1, 2			/* 4way are processed for each address */
	addu	a1, a0			/* limit = base + size */

	.set mips3
33:	cache	Index_Store_Tag_D, 0(a0)	/* clear Tag */
	cache	Index_Store_Tag_D, 1(a0)
	cache	Index_Store_Tag_D, 2(a0)
	cache	Index_Store_Tag_D, 3(a0)
	nop
	.set mips2

	addi	a0, 32
	bne	a0, a1, 33b
	nop
	
/*
 * Copy & Clear BSS
 */
	la	a0, start
	li	a1, FLASH_LOAD_ADDR
	la	a2, _edata
	subu	t1, a2, a0
	srl	t1, t1, 2

	/* copy text section */
	li	t0, 0
1:	lw	v0, 0(a1)
	nop
	sw	v0, 0(a0)
	xor	t0, t0, v0
	addu	a0, 4
	bne	a2, a0, 1b
	addu	a1, 4

	/* Clear BSS */
	la	a0, _edata
	la	a2, _end
2:	sw	zero, 0(a0)
	bne	a2, a0, 2b
	addu	a0, 4

	/* flush Cache */
	li	a0, 0x80000000
	li	a1, (32 * 1024)		/* dcache size (32KB) */
	srl	a1, 2			/* 4way are processed for each address */
	li	a2, 32			/* dcache line size (32Byte) */
	addu	t1, a0, a1
	subu	t2, a2, 1
	not	t2
	and	t0, a0, t2
	addu	t1, -1
	and	t1, t1, t2
31:	.set mips3
	cache	Index_Writeback_Inv_D, 0(t0)
	cache	Index_Writeback_Inv_D, 1(t0)
	cache	Index_Writeback_Inv_D, 2(t0)
	cache	Index_Writeback_Inv_D, 3(t0)
	.set mips2
	bne	t0, t1, 31b
	addu	t0, a2
	
	li	a1, (32 * 1024)		/* icache size (32KB) */
	srl	a1, 2			/* 4way are processed for each address */
	li	a2, 32			/* icache line size (32Byte) */
	addu	t1, a0, a1
	subu	t2, a2, 1
	not	t2
	and	t0, a0, t2
	addu	t1, -1
	and	t1, t1, t2
32:	.set mips3
	cache	Index_Invalidate_I, 0(t0)
	cache	Index_Invalidate_I, 1(t0)
	cache	Index_Invalidate_I, 2(t0)
	cache	Index_Invalidate_I, 3(t0)
	.set mips2
	bne	t0, t1, 32b
	addu	t0, a2
	
#if defined(FOR_PHASE2)
/*
 * Load Kernel from SD Card
 */
	la	sp, (.stack+(4096*2)-24)

	/* start message */
	la	ra, 40f
	la	k0, boot_init
	jr	k0
	nop

40:
#if 1	/* comment out for not fixed address */
	li	t0, KERNEL_WFLG_ADDR	/* kernel writing flag */
	nop
	lw	t1, 0x0(t0)		/* read flag */
	bnez	t1, 43f			/* if flag is not zero, */
					/* jump decompress_kernel */
	nop
	la	a0, msg2
	la	ra, 41f
	la	k0, puts
	jr	k0
	nop
#endif

41:
	la	ra, 42f
	la	k0, load_kernel
	jr	k0
	nop

42:
	la	k0, kernel_entry
	lw	t0, 0(k0)
	jr	t0
	nop

43:
	la	a0, msg1
	la	ra, 44f
	la	k0, puts
	jr	k0
	nop
44:

#endif
/*
 * Decompress Kernel
 */
	la	sp, (.stack+(4096*2)-24)

	li	a0, FLASH_LOAD_ADDR  /* load address */
	move	a1, t1               /* length in words */
	move	a2, t0               /* checksum */
	move	a3, sp

	la	ra, 1f
	la	k0, decompress_kernel
	jr	k0
	nop
1:

	move	a0, s0
	move	a1, s1
	move	a2, s2
	move	a3, s3
	li	k0, KERNEL_ENTRY
	jr	k0
	nop
3:
	b 3b
	END(start)

	LEAF(udelay)
udelay:
	END(udelay)


	LEAF(FlushCache)

	li	a0, 0x80000000
	li	a1, (32 * 1024)		/* dcache size (32KB) */
	srl	a1, 2			/* 4way are processed for each address */
	li	a2, 32			/* dcache line size (32Byte) */
	addu	t1, a0, a1
	subu	t2, a2, 1
	not	t2
	and	t0, a0, t2
	addu	t1, -1
	and	t1, t1, t2
31:	.set mips3
	cache	Index_Writeback_Inv_D, 0(t0)
	cache	Index_Writeback_Inv_D, 1(t0)
	cache	Index_Writeback_Inv_D, 2(t0)
	cache	Index_Writeback_Inv_D, 3(t0)
	.set mips2
	bne	t0, t1, 31b
	addu	t0, a2
	
	li	a1, (32 * 1024)		/* icache size (32KB) */
	srl	a1, 2			/* 4way are processed for each address */
	li	a2, 32			/* icache line size (32Byte) */
	addu	t1, a0, a1
	subu	t2, a2, 1
	not	t2
	and	t0, a0, t2
	addu	t1, -1
	and	t1, t1, t2
32:	.set mips3
	cache	Index_Invalidate_I, 0(t0)
	cache	Index_Invalidate_I, 1(t0)
	cache	Index_Invalidate_I, 2(t0)
	cache	Index_Invalidate_I, 3(t0)
	.set mips2
	bne	t0, t1, 32b
	addu	t0, a2
	
	jr	ra
	nop
	END(FlushCache)

	.comm .stack,4096*2,4


	.align 2
msg1:	.string "Booting from FlashROM\n"
	.align 2
msg2:	.string "Booting from SD Card\n"
	.align 2
fb_msg:	.long msg1
cb_msg:	.long msg2

