/*
**	S334ram.h - this header files contains common definitions used by
**	RC32334 SRAM and DRAM configuration.
*/


/*
*******************************************************************************
**	Copyright 1998 Integrated Device Technology, Inc.
**	All Rights Reserved
*******************************************************************************
*/

#ifndef __S334RAM__
#define __S334RAM__
/******************************** D E F I N E S *******************************/

#define SRAM_ONLY	1
#define SDRAM_ONLY	2
#define EDO_ONLY	3
#define SRAM_N_SDRAM	4
#define SRAM_N_EDO	5
#define SDRAM_N_SRAM	6
#define EDO_N_SRAM	7

#define MB32	1
#define MB64	2
#define MB128	3
#define MB32SO  4

#define EP8	1
#define EP32	2

#define EXTU	1
#define INTU	2

#ifndef LED_BASE

#if defined(EB332)
#define	LED_BASE	PHYS_TO_K1(0x10000000)
#define	LED_DIGIT0	0xC
#define	LED_DIGIT1	0x8
#define	LED_DIGIT2	0x4
#define	LED_DIGIT3	0x0
#define	LED_CLEAR	0x400
#else
#define	LED_BASE	PHYS_TO_K1(0x14000000)
#define	LED_DIGIT0	0xf
#define	LED_DIGIT1	0xb
#define	LED_DIGIT2	0x7
#define	LED_DIGIT3	0x3
#define	LED_CLEAR	0x400
#endif

#endif

#define SYS_BTA_CTRL            PHYS_TO_K1(0x18000000)
#define SYS_ALT_CTRL            PHYS_TO_K1(0x18000004)
#if MHZ < 67000000
#warning : compiling for less than 67 MHz
#define SYS_ALT_SETUP           0x00000003  
#else
#warning : compiling for more than 67 MHz
#define SYS_ALT_SETUP           0x00000007   
#endif
#define	PORT_WIDTH_CONTROL	0xffffe200	/* port width control register address */
#define	BTA_CONTROL		0xffffe204      /* was 0xffffe240 - hak 06-16-98 - BTA control register address */
#define	BTA_SETUP		0x3fffffff      /* 3 turnaround cycles for all regions */

#if EPRMPRTWD == EP8
/*#define	PORT_SETUP		0xaaa22aaa       was 0xaaa82aaa - hak 06-16-98, today 22 is for boot prom and external UART 1-4-99 */
#if defined(EB332)
#define PORT_SETUP              0xaaa22aaa
#else
#define	PORT_SETUP		0xaa822aaa       /* changed for 8-bit wide NVRAM at physical 1200_0000: Upen-000530*/
#endif /* EB332 */
#elif EPRMPRTWD == EP32
#define PORT_SETUP		0xaaa2aaaa	/* boot EPROM space port width = 32 bits */
#else
#error "illegal value for eprom port width"
#endif

#define MEM_CTL_BASE		PHYS_TO_K1(0x18000200)	/* base address of all (0-5) Memory Control Registers */
#define MEM_BASE_BASE		PHYS_TO_K1(0x18000080)	/* base address of 2 (0-1) Base Address Registers */
#define R32134_IREG_BASE		PHYS_TO_K1(0x18000000)	/* all R32134 internal registers' base address */

/* 
** b14:13=>01=PROM;b12=>1= do not assert CS during writes; b11:10=>00=8 bit port 
** b09:05=>0A=10 wait states; b04:00=>0A= 10 wait states
*/


/*#define MCR_CS0_BS		0x31ef31ef*/
#define MCR_CS0_BS		0x30843084

/* 
** b14:13=>00=SRAM;b12=>0= assert CS during writes; b11:10=>10=32 bit port 
** b09:05=>FF=31 wait states; b04:00=>FF= 31 wait states.
** NOTE: wait states should be tuned.
*/


/*#define MCR_CS1_BS		0x28e728e7*/
#define MCR_CS1_BS		0x28a528a5

#define MCR_CS2_BS		0xa0e7a0e7

#define MCR_CS3_BS		0xa0e7a0e7

#define MCR_CS4_BS		0xa0e7a0e7     /* S334 LED */


/* 
** b14:13=>01=I Type;b12=>0= assert CS during writes; b11:10=>00=8 bit port 
** b09:05=>FF=31 wait states; b04:00=>FF= 31 wait states
*/

#define MCR_CS5_BS		0xa0E7a0E7
/*#define MCR_CS5_BS		0x21EF21EF*/

/*
** physical memory base address register value for Chip Select 0 - EPROM
** NOTE: for starters see if you can just set the default value: 0x1FC00000
*/
#define MBA_REG0		0x1FC00000

/*
** memory base mask register value for Chip Select 0 - EPROM - 4MB
*/
#define MBM_REG0		0xFFC00000


#define CPU_BERR_BS		0xFF
#define IP_BERR_BS		0xFF



#if MEMCFG == SRAM_ONLY
/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1		0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000

#elif MEMCFG == SDRAM_ONLY || MEMCFG == SDRAM_N_SRAM
/*
*************************************
** SDRAM_ONLY or SDRAM_N_SRAM section
*************************************
*/

#define APATTERN 0xa5a5a5a5

#if DRAMSZ == MB128
/*
===============================
== 128MB section
===============================
*/
/*
** DRAM BANK0 BASE.  Starting Bank at 0MB:
*/
#define DRAM_BNK0_BASE		0x00000000
/*
** DRAM BANK1 BASE. 2nd bank at 32MB:
*/
#define DRAM_BNK1_BASE		0x02000000
/*
** DRAM BANK2 BASE. 3rd bank at 64MB:
*/
#define DRAM_BNK2_BASE		0x04000000
/*
** DRAM BANK3 BASE. 4th bank at 96MB:
*/
#define DRAM_BNK3_BASE		0x06000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK		0xFFF00000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS		0xb95500FF	/* old: 0x9EFBOOFF */
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS		0x2AF800FF
/*
** Precharge Value
*/
#define SDRAM_PC_VAL		0xb95501a0
/*
** Refresh Cmd
*/
#define	SDRAM_RFRSH_CMD		0xb9550090
/*
** Mode Register
*/
#define SDRAM_MODE_REG		0xAAF80080

#if MEMCFG == SDRAM_N_SRAM
/*
** physical memory base address register value for Chip Select 1 - SRAM
** at 128MB:
*/
#define MBA_REG1		0x08000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000

#endif /* #if MEMCFG == SDRAM_N_SRAM */

#elif DRAMSZ == MB32
/*
===============================
== 32MB section
===============================
*/
/*
** DRAM BANK0 BASE.  Starting Bank at 0MB:
*/
#define DRAM_BNK0_BASE		0x00000000
/*
** DRAM BANK1 BASE. 2nd bank at 8MB:
*/
#define DRAM_BNK1_BASE		0x00800000
/*
** DRAM BANK2 BASE. 3rd bank at 16MB:
*/
#define DRAM_BNK2_BASE		0x01000000
/*
** DRAM BANK3 BASE. 4th bank at 24MB:
*/
#define DRAM_BNK3_BASE		0x01800000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK		0xFF800000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS		0xB95500FF	/* 11:18:99 0xBAF800FF */
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS		0x395500FF	/* 11:18:99 0x3AF800FF */
/*
** Precharge Value
*/
#define SDRAM_PC_VAL		0xB95501A0	/* 11:18:99 0xBAF801A0 */
/*
** Refresh Cmd
*/
#define	SDRAM_RFRSH_CMD		0xB9550090	/* 11:18:99 0xBAF80090 */
/*
** Mode Register
*/
#define SDRAM_MODE_REG		0xB9550080	/* 11:18:99 0xBAF80080 */
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS		0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS		0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS	0x000002A0

#if MEMCFG == SDRAM_N_SRAM
/*
** physical memory base address register value for Chip Select 1 - SRAM
** at 32MB:
*/
#define MBA_REG1		0x04000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000
#endif /* MEMCFG == SDRAM_N_SRAM */

#elif DRAMSZ == MB32SO
/*
===============================
== 32MB SODIMM section
===============================
*/
/*
** DRAM BANK0 BASE.  Starting Bank at 0MB:
*/
#define DRAM_BNK0_BASE		0x03000000
/*
** DRAM BANK1 BASE. 2nd bank at 8MB:
*/
#define DRAM_BNK1_BASE		0x02000000
/*
** DRAM BANK2 BASE. 3rd bank at 16MB:
*/
#define DRAM_BNK2_BASE		0x01000000
/*
** DRAM BANK3 BASE. 4th bank at 24MB:
*/
#define DRAM_BNK3_BASE		0x00000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK		0xFF000000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
/*#define SDRAM_CR_BS		0x8E78C0FF */   /* 11:18:99 0xBAF800FF */
#define SDRAM_CR_BS		0x895580FF
/*
** SDRAM DISABLE Settings
*/
/* #define SDRAM_DS_BS		0x0E78C0FF*/	/* 11:18:99 0x3AF800FF */
#define SDRAM_DS_BS		0x095580FF
/*
** Precharge Value
*/
/* #define SDRAM_PC_VAL		0x8E78C0A0*/	/* 11:18:99 0xBAF801A0 */
#define SDRAM_PC_VAL		0x895580A0
/*
** Refresh Cmd
*/
/* #define	SDRAM_RFRSH_CMD	  0x8E78C090*/	/* 11:18:99 0xBAF80090 */
#define	SDRAM_RFRSH_CMD	        0x89558090
/*
** Mode Register
*/
/*#define SDRAM_MODE_REG	0x8E78C080*/	/* 11:18:99 0xBAF80080 */
#define SDRAM_MODE_REG	        0x89558080
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS		0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS		0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS	0x000002A0

#if MEMCFG == SDRAM_N_SRAM
/*
** physical memory base address register value for Chip Select 1 - SRAM
** at 32MB:
*/
#define MBA_REG1		0x04000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000
#endif /* MEMCFG == SDRAM_N_SRAM */

#endif /* DRAMSZ == MB32SO */

#elif MEMCFG == EDO_ONLY || MEMCFG == EDO_N_SRAM
/*
*****************************************
** EDO only section or EDO_N_SRAM section
*****************************************
*/
/*
** DRAM BANK0 BASE.  Starting Bank at 0MB
*/
#define DRAM_BNK0_BASE		0x00000000
/*
** DRAM BANK1 BASE. 2nd bank at 16MB
*/
#define DRAM_BNK1_BASE		0x01000000
/*
** DRAM BANK2 BASE. 3rd bank at 32MB:
*/
#define DRAM_BNK2_BASE		0x02000000
/*
** DRAM BANK3 BASE. 4th bank at 48MB:
*/
#define DRAM_BNK3_BASE		0x03000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK		0xFF000000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK

/*
** EDO control register bit settings
*/

#define EDO_CR_BS		0x80000BA8	/* 0x80000E02 */

/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS		0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS		0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS	0x000000A0

/*
** EDO control register bit settings
*/

#define EDO_CR_BS		0x80000BA8	/* 0x80000E02 */

#if MEMCFG == EDO_N_SRAM
/*
** physical memory base address register value for Chip Select 1 - SRAM
** at 64MB:
*/
#define MBA_REG1		0x04000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000
#endif /* MEMCFG == EDO_N_SRAM */

#elif MEMCFG == SRAM_N_SDRAM

#define APATTERN 0xa5a5a5a5

/*
*******************************
** SRAM and SDRAM section
*******************************
*/
#if DRAMSZ == MB128
/*
===============================
== 128MB section
===============================
*/
/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1		0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000

/*
** DRAM BANK0 BASE.  Starting Bank at 32MB:
*/
#define DRAM_BNK0_BASE		0x02000000
/*
** DRAM BANK1 BASE. 2nd bank at 64MB:
*/
#define DRAM_BNK1_BASE		0x04000000
/*
** DRAM BANK2 BASE. 3rd bank at 96MB:
*/
#define DRAM_BNK2_BASE		0x06000000
/*
** DRAM BANK3 BASE. 4th bank at 128MB:
*/
#define DRAM_BNK3_BASE		0x08000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK		0xFE000000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS		0xAAF800FF	/* old: 0x9EFBOOFF */
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS		0x2AF800FF
/*
** Precharge Value
*/
#define SDRAM_PC_VAL		0xAAF801A0
/*
** Refresh Cmd
*/
#define	SDRAM_RFRSH_CMD		0xAAF80090
/*
** Mode Register
*/
#define SDRAM_MODE_REG		0xAAF80080
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS		0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS		0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS	0x000000A0

#elif DRAMSZ == MB32
/*
===============================
== 32MB section
===============================
*/

/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1		0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000

/*
** DRAM BANK0 BASE.  Starting Bank at 8MB:
*/
#define DRAM_BNK0_BASE		0x00800000
/*
** DRAM BANK1 BASE. 2nd bank at 16MB:
*/
#define DRAM_BNK1_BASE		0x01000000
/*
** DRAM BANK2 BASE. 3rd bank at 24MB:
*/
#define DRAM_BNK2_BASE		0x01800000
/*
** DRAM BANK3 BASE. 4th bank at 64MB:
*/
#define DRAM_BNK3_BASE		0x02000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK		0xFF800000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS		0xB95500FF	/* 11:18:99 0xBAF800FF */
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS		0x395500FF	/* 11:18:99 0x3AF800FF */
/*
** Precharge Value
*/
#define SDRAM_PC_VAL		0xB95501A0	/* 11:18:99 0xBAF801A0 */
/*
** Refresh Cmd
*/
#define	SDRAM_RFRSH_CMD		0xB9550090	/* 11:18:99 0xBAF80090 */
/*
** Mode Register
*/
#define SDRAM_MODE_REG		0xB9550080	/* 11:18:99 0xBAF80080 */
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS		0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS		0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS	0x000001A0	/* 11:18:99 0x000000A0 */

#elif DRAMSZ == MB32SO
/*
===============================
== 32MB section
===============================
*/

/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1		0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000

/*
** DRAM BANK0 BASE.  Starting Bank at 8MB:
*/
#define DRAM_BNK0_BASE		0x04000000
/*
** DRAM BANK1 BASE. 2nd bank at 16MB:
*/
#define DRAM_BNK1_BASE		0x03000000
/*
** DRAM BANK2 BASE. 3rd bank at 24MB:
*/
#define DRAM_BNK2_BASE		0x02000000
/*
** DRAM BANK3 BASE. 4th bank at 64MB:
*/
#define DRAM_BNK3_BASE		0x01000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK		0xFF000000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
/* #define SDRAM_CR_BS		0x8E78C0FF*/	/* 11:18:99 0xBAF800FF */
#define SDRAM_CR_BS		0x8955C0FF
/*
** SDRAM DISABLE Settings
*/
/* #define SDRAM_DS_BS		0x0E78C0FF*/	/* 11:18:99 0x3AF800FF */
#define SDRAM_DS_BS		0x0955C0FF
/*
** Precharge Value
*/
/* #define SDRAM_PC_VAL		0x8E78C0A0*/	/* 11:18:99 0xBAF801A0 */
#define SDRAM_PC_VAL		0x8955C0A0
/*
** Refresh Cmd
*/
/*#define	SDRAM_RFRSH_CMD	  0x8E78C090*/	/* 11:18:99 0xBAF80090 */
#define	SDRAM_RFRSH_CMD	        0x8955C090
/*
** Mode Register
*/
/*#define SDRAM_MODE_REG      0x8E78C080*/	/* 11:18:99 0xBAF80080 */
#define SDRAM_MODE_REG          0x8955C080
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS		0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS		0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS	0x000001A0	/* 11:18:99 0x000000A0 */

#else
#error "unrecognized dram size"
#endif /* DRAMSZ */

#elif MEMCFG == SRAM_N_EDO
/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1		0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1		0xFFF00000

/*
** DRAM BANK0 BASE.  Starting Bank at 16MB
*/
#define DRAM_BNK0_BASE		0x01000000
/*
** DRAM BANK1 BASE. 2nd bank at 32MB
*/
#define DRAM_BNK1_BASE		0x02000000
/*
** DRAM BANK2 BASE. 3rd bank at 48MB:
*/
#define DRAM_BNK2_BASE		0x03000000
/*
** DRAM BANK3 BASE. 4th bank at 64MB:
*/
#define DRAM_BNK3_BASE		0x04000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK		0xFF000000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK

/*
** EDO control register bit settings
*/
#define EDO_CR_BS		0x80000BA8	/* 0x80000E02 */

/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS		0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS		0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS	0x000000A0

#else
#error "unrecogized memory configuration parameter"
#endif /* error */

/* parameters for initialising the S134 board EEPROM */
#define DESTRUCTIVE 1
#define NONDESTRUCTIVE 0

#endif /* __S334RAM__ */


