/*
**	S334ram.h - this header files contains common definitions used by
**	RC32334 SRAM and DRAM configuration.
*/


/*
*******************************************************************************
**	Copyright 1998 Integrated Device Technology, Inc.
**	All Rights Reserved
*******************************************************************************
*/

#ifndef __S334RAM__
#define __S334RAM__
/******************************** D E F I N E S *******************************/

#define SRAM_ONLY	1
#define SDRAM_ONLY	2
/* #define EDO_ONLY	3 */
#define SRAM_N_SDRAM	4
/* #define SRAM_N_EDO	5 */
#define SDRAM_N_SRAM	6
/* #define EDO_N_SRAM	7 */

#define APATTERN 0xa5a5a5a5

#define MB32	1
#define MB64	2
#define MB128	3
#define MB32SO  4

#define EP8	1
#define EP32	2

#define EXTU	1
#define INTU	2

#ifndef LED_BASE

#if defined(EB332)
#define	LED_BASE	PHYS_TO_K1(0x10000000)
#else
#define	LED_BASE	PHYS_TO_K1(0x14000000)
#endif /* EB332 */

#define	LED_DIGIT0	0xf
#define	LED_DIGIT1	0xb
#define	LED_DIGIT2	0x7
#define	LED_DIGIT3	0x3
#define	LED_CLEAR	0x400

#endif

#define SYS_BTA_CTRL            PHYS_TO_K1(0x18000000)
#define SYS_ALT_CTRL            PHYS_TO_K1(0x18000004)

#if MHZ < 66000000
#define SYS_ALT_SETUP           0x00000003 
#define TRCD			0x00500000	/* used in SDRAM set-up (RCD value) */ 
#else
#define SYS_ALT_SETUP           0x00000007  
#define TRCD			0x00600000	/* used in SDRAM set-up (RCD value) */  
#endif

#define	PORT_WIDTH_CONTROL	0xffffe200	/* port width control register address */
#define	BTA_CONTROL		0xffffe204      /* was 0xffffe240 - hak 06-16-98 - BTA control register address */
#define	BTA_SETUP		0x3FFFFFFF      /* 3 turnaround cycles for all regions */

#if EPRMPRTWD == EP8

#define	PORT_SETUP		0xaa822aaa       /* changed for 8-bit wide NVRAM at physical 1200_0000: Upen-000530*/

#elif EPRMPRTWD == EP32
#define PORT_SETUP		0xaa82aaaa	/* boot EPROM space port width = 32 bits */
#else
#error "illegal value for eprom port width"
#endif

#define MEM_CTL_BASE		PHYS_TO_K1(0x18000200)	/* base address of all (0-5) Memory Control Registers */
#define MEM_BASE_BASE		PHYS_TO_K1(0x18000080)	/* base address of 2 (0-1) Base Address Registers */
#define R32134_IREG_BASE	PHYS_TO_K1(0x18000000)	/* all R32134 internal registers' base address */

/* 
** b14:13=>01=PROM;b12=>1= do not assert CS during writes; b11:10=>00=8 bit port 
** b09:05=>08=8 wait states; b04:00=>08= 8 wait states
*/

#define MCR_CS0_BS		0x31083108  


/* 
** b14:13=>00=SRAM;b12=>0= assert CS during writes; b11:10=>10=32 bit port 
** b09:05=>FF=31 wait states; b04:00=>FF= 31 wait states.
** NOTE: wait states should be tuned.
*/

#if defined(EB332)
#define MCR_CS1_BS		0x60e760e7
#else
#define MCR_CS1_BS		0x28632863
#endif /* EB332 */
#define MCR_CS2_BS		0x60e760e7
#define MCR_CS3_BS		0x60e760e7
#define MCR_CS4_BS		0x60e760e7     /* S334 LED */

/* 
** b14:13=>01=I Type;b12=>0= assert CS during writes; b11:10=>00=8 bit port 
** b09:05=>FF=31 wait states; b04:00=>FF= 31 wait states
*/

#define MCR_CS5_BS		0x60E760E7

#define MBA_REG0		0x1FC00000  /* phys mem base addr reg val for CS 0 - EPROM */
#define MBM_REG0		0xFFC00000  /* mem base mask reg for CS0 -EPROM-4MB */
#define CPU_BERR_BS		0xFF
#define IP_BERR_BS		0xFF



/*********************************
*    SRAM_ONLY section 				*
*********************************/

#if MEMCFG == SRAM_ONLY

#define MBA_REG1		0x00000000   /* physical mem bas addr fir CS-1 */
#define MBM_REG1		0xFFF00000   /* mem bas mask for CS1 */

/****************************************
*    SDRAM_ONLY or SDRAM_N_SRAM section *
****************************************/

#elif MEMCFG == SDRAM_ONLY || MEMCFG == SDRAM_N_SRAM

/* =======  128 MB DIMM section ===============*/

#if DRAMSZ == MB128

#define DRAM_BNK0_BASE		0x00000000	/* 0 MB */
#define DRAM_BNK1_BASE		0x02000000	/* 32 MB */
#define DRAM_BNK2_BASE		0x04000000	/* 64 MB */
#define DRAM_BNK3_BASE		0x06000000	/* 96 MB */

#define DRAM_BNK0_MASK		0xFE000000	/* masks for other banks are defined at the end */

#define SDRAM_CR_BS		0xB90500FF | TRCD	/* SDRAM enable */
#define SDRAM_DS_BS		0x390500FF | TRCD	/* SDRAM disable */
#define SDRAM_PC_VAL		0xB90501A0 | TRCD	/* precharge value */
#define SDRAM_RFRSH_CMD		0xB9050090 | TRCD	/* refresh command */
#define SDRAM_MODE_REG		0xB9050080 | TRCD	/* mode register */

#if MEMCFG == SDRAM_N_SRAM
/* leave a gap of one SDRAM bank's worth of space between end of SDRAM and start of SRAM */
#define MBA_REG1 		0x0A000000  	/* physical mem bas add for CS1 - 128MB + 32MB*/
#define MBM_REG1 		0xFFF00000  	/* mem bas mask for CS1 - SRAM */
#endif 						/* #if MEMCFG == SDRAM_N_SRAM */

/* ========  32MB DIMM section  ================*/

#elif DRAMSZ == MB32

#define DRAM_BNK0_BASE		0x00000000   	/* 0 MB */
#define DRAM_BNK1_BASE		0x00800000	/* 8 MB */
#define DRAM_BNK2_BASE		0x01000000	/* 16 MB */
#define DRAM_BNK3_BASE		0x01800000	/* 24 MB */

#define DRAM_BNK0_MASK		0xFF800000	/* masks for other banks are defined at the end */

#define SDRAM_CR_BS		0xB90500FF | TRCD	/* SDRAM enable */
#define SDRAM_DS_BS		0x390500FF | TRCD	/* SDRAM disable */
#define SDRAM_PC_VAL		0xB90501A0 | TRCD	/* precharge value */
#define SDRAM_RFRSH_CMD		0xB9050090 | TRCD	/* refresh command */
#define SDRAM_MODE_REG		0xB9050080 | TRCD	/* mode register */

#if MEMCFG == SDRAM_N_SRAM
/* leave a gap of one SDRAM bank's worth of space between end of SDRAM and start of SRAM */
#define MBA_REG1		0x04000000  	/* physical mem bas add for CS1 - 32MB*/
#define MBM_REG1		0xFFF00000  	/* mem bas mask for CS1 - SRAM */
#endif 						/* MEMCFG == SDRAM_N_SRAM */

/* =======  32MB or 64 MB SODIMM section ======== */

#elif DRAMSZ == MB32SO

#define DRAM_BNK0_BASE		0x00000000	/* 0 MB */
#define DRAM_BNK1_BASE		0x01000000	/* 8 MB */
#define DRAM_BNK2_BASE		0x02000000	/* 16 MB */
#define DRAM_BNK3_BASE		0x03000000	/* 24 MB */

#define DRAM_BNK0_MASK		0xFF000000	/* masks for other banks are defined at the end */

#define SDRAM_CR_BS		0x890580FF | TRCD	/* SDRAM enable */
#define SDRAM_DS_BS		0x090580FF | TRCD	/* SDRAM disable */
#define SDRAM_PC_VAL		0x890580A0 | TRCD	/* Precharge value */
#define SDRAM_RFRSH_CMD		0x89058090 | TRCD	/* Refresh command */
#define SDRAM_MODE_REG		0x89058080 | TRCD	/* Mode register */

#if MEMCFG == SDRAM_N_SRAM
/* leave a gap of one SDRAM bank's worth of space between end of SDRAM and start of SRAM */
#define MBA_REG1		0x04000000	/* physical mem bas add for CS1 - 32MB*/
#define MBM_REG1		0xFFF00000	/* mem bas mask for CS1 - SRAM */
#endif 						/* MEMCFG == SDRAM_N_SRAM */

#endif /* DRAMSZ == MB32SO */

/***************************************************
*    SRAM_N_SDRAM section (assumes 1 MB SRAM)     *
***************************************************/

#elif MEMCFG == SRAM_N_SDRAM

/* ========= 128MB DIMM section ============ */

#if DRAMSZ == MB128

#define MBA_REG1		0x00000000	/* physical mem bas addr for CS1 */
#define MBM_REG1		0xFFF00000	/* mem nase mask for CS1 */

/* leave a gap of one SDRAM bank's worth of space between end of SRAM and start of SDRAM */
#define DRAM_BNK0_BASE		0x02000000	/* bank 0 at 32 MB */
#define DRAM_BNK1_BASE		0x04000000	/* 64 MB */
#define DRAM_BNK2_BASE		0x06000000	/* 96 MB */
#define DRAM_BNK3_BASE		0x08000000	/* 128 MB */

#define DRAM_BNK0_MASK		0xFE000000	/* masks for other banks are defined at the end */

#define SDRAM_CR_BS		0xB95500FF | TRCD	/* SDRAM enable */
#define SDRAM_DS_BS		0x395500FF | TRCD	/* SDRAM disable */
#define SDRAM_PC_VAL		0xB95501A0 | TRCD	/* precharge value */
#define SDRAM_RFRSH_CMD		0xB9550090 | TRCD	/* refresh command */
#define SDRAM_MODE_REG		0xB9550080 | TRCD	/* mode register */


/* ========= 32MB DIMM section ============ */

#elif DRAMSZ == MB32

#define MBA_REG1		0x00000000	/* physical mem bas addr for CS1 */
#define MBM_REG1		0xFFF00000	/* mem nase mask for CS1 */

/* leave a gap of one SDRAM bank's worth of space between end of SRAM and start of SDRAM */
#define DRAM_BNK0_BASE		0x00800000
#define DRAM_BNK1_BASE		0x01000000
#define DRAM_BNK2_BASE		0x01800000
#define DRAM_BNK3_BASE		0x02000000

#define DRAM_BNK0_MASK		0xFF800000	/* masks for other banks are defined at the end */

#define SDRAM_CR_BS		0xB95500FF | TRCD	/* SDRAM enable */
#define SDRAM_DS_BS		0x395500FF | TRCD	/* SDRAM disable */
#define SDRAM_PC_VAL		0xB95501A0 | TRCD	/* precharge value */
#define SDRAM_RFRSH_CMD		0xB9550090 | TRCD	/* refresh command */
#define SDRAM_MODE_REG		0xB9550080 | TRCD	/* mode register */

/* =======  32MB or 64 MB SODIMM section ======== */

#elif DRAMSZ == MB32SO

#define MBA_REG1		0x00000000	/* physical mem bas addr for CS1 */
#define MBM_REG1		0xFFF00000	/* mem nase mask for CS1 */

/* leave a gap of one SDRAM bank's worth of space between end of SRAM and start of SDRAM */
#define DRAM_BNK0_BASE		0x01000000
#define DRAM_BNK1_BASE		0x02000000
#define DRAM_BNK2_BASE		0x03000000
#define DRAM_BNK3_BASE		0x04000000

#define DRAM_BNK0_MASK		0xFF000000	/* masks for other banks are defined at the end */

#define SDRAM_CR_BS		0x8955C0FF | TRCD	/* SDRAM enable */
#define SDRAM_DS_BS		0x0955C0FF | TRCD	/* SDRAM disable */
#define SDRAM_PC_VAL		0x8955C0A0 | TRCD	/* precharge value */
#define	SDRAM_RFRSH_CMD		0x8955C090 | TRCD	/* refresh command */
#define SDRAM_MODE_REG     	0x8955C080 | TRCD	/* mode register */

#else
#error "unrecognized dram size"
#endif /* DRAMSZ */

#else
#error "unrecogized memory configuration parameter"
#endif /* error */

/* These settings apply to all types of SDRAM modules */
#if MEMCFG != SRAM_ONLY

#define DRAM_BNK1_MASK		DRAM_BNK0_MASK
#define DRAM_BNK2_MASK		DRAM_BNK0_MASK
#define DRAM_BNK3_MASK		DRAM_BNK0_MASK

#define DRAM_RF_CNT_BS		0x00000000   /* Refresh Count Reg setting*/
#define DRAM_RF_CMPR_BS		0x00000040   /* Refresh Compare Reg: fast expiration */

#if MHZ == 50000000
#define DRAM_RF_CMPR_SE_BS	0x000002E8   /* Refresh Compare Reg: standard expiration */
#elif MHZ == 66500000
#define DRAM_RF_CMPR_SE_BS	0x000003E0   /* Refresh Compare Reg: standard expiration */
#elif	MHZ == 75000000
#define DRAM_RF_CMPR_SE_BS	0x00000460   /* Refresh Compare Reg: standard expiration */
#else
#error "MHZ setting in the Makefile must be equal to 50000000, 66500000 or 75000000 "
#endif

#endif
/* parameters for initialising the S134 board EEPROM */
#define DESTRUCTIVE 			1
#define NONDESTRUCTIVE 		0

#endif /* __S334RAM__ */


