/*********************************************************************
 * csu_idt.S
 *
 * Board initialization.
 **************************************************************************
 * Ported from IDT/Sim
 *
 *   28 Oct 2002
 * P. Sadik    Pallathu.Sadik@idt.com
 **************************************************************************/

#include <linux/config.h>
#include <linux/threads.h>

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/offset.h>
#include <asm/cachectl.h>
#include "iregdef.h"
#include "idtcpu.h"
#include "idthdr.h"

#include "mhz.h"
#define  MHZ IDT_BUS_FREQ*1000000

#include "s364.h"

#if defined (S334A)
#include "s334aram.h"
#elif defined (S334)
#include "s334ram.h"
#endif	

#define IndexInvalidate_I       0x00

.extern _binary_zImage_bin_start,4
.extern _binary_zImage_bin_end,4
	
/*--------------------------------------------------------------
** prom entry point table
*-------------------------------------------------------------*/
FRAME(start,sp,0,ra)
	j idtstart

idtstart:
	.set	noreorder

#if defined(CPU_R32364)
	li	t0,PORT_WIDTH_CONTROL
	li	t1,PORT_SETUP
	sw	t1,0x0(t0)
	li	t0,BTA_CONTROL
	li	t1,BTA_SETUP
	sw	t1,0x0(t0)
	li	t0,SYS_BTA_CTRL
	sw	t1,0x0(t0)
#if MHZ > 50000000
	li      t0,SYS_ALT_CTRL
        li      t1,SYS_ALT_SETUP
        sw      t1,0x0(t0)
#endif
        li      v0,0x00
	or	v0,(SR_CU0|SR_BEV|SR_DE)
#endif
	mtc0	v0,C0_SR		# state unknown on reset
	mtc0	zero,C0_CAUSE		# clear software interrupts

#ifdef S334
	/* initialize the PIO Direction for UART RC32334/2*/
#define PIO_BASE_ADDR     0xb8000600
#define PIO_DC_SET        0x00500050
#define PIO_DC_MASK       0xff0fff0f

	li      t0,PIO_BASE_ADDR
	lw      t1,0x4(t0)
	nop
	li      t2,PIO_DC_MASK          #mask the UART bits
	and     t1,t1,t2
	nop
	li      t2,PIO_DC_SET           #rx0=rx1=input, tx0=tx1=output
	or      t1,t1,t2
	nop
	sw      t1,0x4(t0)

	/*  disable the PCI bus error */
        lui     t1,0xb800
	ori     t1,t1,0x10
	nop
	lw      t0,0x0(t1)
	nop
	nop
	ori     t0,t0,0x80
	nop
	sw      t0,0x0(t1)
	nop
	nop
	nop
#endif

#if defined(CPU_R4000) || defined(CPU_R32364)
	mfc0	v1,C0_CONFIG
	/* Set cache mode: write-back */
	li	v0, CFG_C_NCHRNT_WB  /* CFG_C_NCHRNT_WB CFG_C_NCHRNT_WT_NWA CFG_C_UNCACHED */
	and	v1,~(0x7)
	or	v1,v1,v0
	mtc0	v1,C0_CONFIG
	nop
	nop
	li	t0,MEM_BASE_BASE	/* load 2 base address registers' base */

	li	t1,MBA_REG0		/* load into  memory base address register 0 */
	sw	t1,0x0(t0)		/* set the memory base address register for Chip Select 0 - EPROM */

	li	t1,MBM_REG0		/* load into  memory base mask register 0 */
	sw	t1,0x4(t0)		/* set the memory base mask register for Chip Select 0 - EPROM */


	li	t0,MEM_CTL_BASE		/* load all control registers' base address */

	li      t1,MCR_CS0_BS           /* load  memory control register chip select 0 bit settings */
	sw	t1,0x0(t0)		/* set the control register for Chip Select 0 - EPROM */

	nop

	li	t1,MCR_CS1_BS		/* load into upper half memory control register chip select 1 bit settings */
	sw	t1,0x4(t0)		/* set the control register for Chip Select 1 - SRAM */
	nop
#ifdef S334
	li      t1,MCR_CS2_BS           /* initialize CHIP-SELECT2 */
        sw      t1,0x08(t0)
	nop

	li      t1,MCR_CS3_BS           /* initialize CHIP-SELECT3 */
        sw      t1,0x0C(t0)
	nop

	li      t1,MCR_CS4_BS           /* initialize CHIP-SELECT4 for LED */
	sw      t1,0x10(t0)
	nop

#endif
	li	t1,MCR_CS5_BS		/* load into upper half memory control register chip select 5 bit settings */
	sw	t1,0x14(t0)		/* set the control register for Chip Select 5 - External UART */
	nop

/*------------ load all R32 internal registers' base address ----------*/
	li	t0,R32134_IREG_BASE	/* load t0 with all R32134 internal registers' base address */

/* ------------------- Disable WatchDog Timer --------------------------------- */
	li	t1,DISABLE_TIMER
	sw	t1,0x730(t0)

#if MEMCFG == SDRAM_ONLY || MEMCFG == SRAM_N_SDRAM || MEMCFG == SDRAM_N_SRAM
/*--------------- disable EDO Controller ---------------------------*/
	li	t1,0			/* EDO_CR_BS load EDO control register bit settings in t1 */
	sw	t1,0x310(t0)		/* Disable  EDO control register */

#elif MEMCFG == EDO_ONLY || MEMCFG == SRAM_N_EDO || MEMCFG == EDO_N_SRAM
/*------------------------- disable SDRAM Controller --------------------------*/
	li	t1,0
	sw	t1,0x300(t0)
#endif /* MEMCFG == EDO_ONLY || MEMCFG == SRAM_N_EDO || MEMCFG == EDO_N_SRAM */

#if MEMCFG != SRAM_ONLY
/*-------------- Initialize SDRAM or EDO Base and Mask Registers ----------*/

	li	t1,DRAM_BNK0_BASE	/* load DRAM bank 0 physical address in t1 */
	sw	t1,0xC0(t0)		/* set DRAM bank 0 base */
	li	t1,DRAM_BNK1_BASE	/* load DRAM bank 1 physical address in t1 */
	sw	t1,0xC8(t0)		/* set DRAM bank 1 base */
	li	t1,DRAM_BNK2_BASE	/* load DRAM bank 2 physical address in t1 */
	sw	t1,0xD0(t0)		/* set DRAM bank 2 base */
	li	t1,DRAM_BNK3_BASE	/* load DRAM bank 3 physical address in t1 */
	sw	t1,0xD8(t0)		/* set DRAM bank 3 base */

	li	t1,DRAM_BNK0_MASK	/* load DRAM bank 0 size in t1 */
	sw	t1,0xC4(t0)		/* set DRAM bank 0 mask */
	li	t1,DRAM_BNK1_MASK	/* load DRAM bank 1 size in t1 */
	sw	t1,0xCC(t0)		/* set DRAM bank 1 mask */
	li	t1,DRAM_BNK2_MASK	/* load DRAM bank 2 size in t1 */
	sw	t1,0xD4(t0)		/* set DRAM bank 2 mask */
	li	t1,DRAM_BNK3_MASK	/* load DRAM bank 3 size in t1 */
	sw	t1,0xDC(t0)		/* set DRAM bank 3 mask */

#if  MEMCFG == SRAM_N_SDRAM || MEMCFG == SRAM_N_EDO || MEMCFG == SDRAM_N_SRAM || MEMCFG == EDO_N_SRAM
/* ------------------------------- Setup SRAM if in place -----------------------------------------*/
	li	t0,MEM_BASE_BASE	/* load 2 base address registers' base */
	li	t1,MBA_REG1		/* load into memory base address register 1 */
	sw	t1,0x8(t0)		/* set the memory base address register for Chip Select 1 - SRAM */

	li	t1,MBM_REG1		/* load into memory base mask register 1 */
	sw	t1,0xC(t0)		/* set the memory base mask register for Chip Select 1 - SRAM */
#endif /*  MEMCFG == SRAM_N_SDRAM || MEMCFG == SRAM_N_EDO || MEMCFG == SDRAM_N_SRAM || MEMCFG == EDO_N_SRAM*/

#if MEMCFG == EDO_ONLY || MEMCFG == SRAM_N_EDO || MEMCFG == EDO_N_SRAM
/*-------------- Set EDO control register --------------------------*/
	li	t1,EDO_CR_BS		/* load EDO control register bit settings in t1 */
	sw	t1,0x310(t0)		/* set EDO control register */
#endif /* MEMCFG == EDO_ONLY || MEMCFG == SRAM_N_EDO || MEMCFG == EDO_N_SRAM */

/*-------------- Setup and Enable Refresh Timer --------------------*/
	li	t0,TIMER_BASE		/* load timer register set base */

	li	t1,DISABLE_TIMER	/* load diable timer bit settings into t1 */
	sw	t1,0x60(t0)		/* disable timer */
        nop

#if MEMCFG == SDRAM_ONLY || MEMCFG == SRAM_N_SDRAM || MEMCFG == SDRAM_N_SRAM
/*-------------- Enable SDRAM Controller ---------------------------*/
	li	t0,R32134_IREG_BASE
	li	t1,SDRAM_CR_BS
	sw	t1,0x300(t0)
        nop
/*-------------- Delay Loop ----------------------------------------*/
	li	v0,10000	/* 8x256us */
1:	bne	v0,zero,1b
	subu	v0,1		/* BDSLOT  */
	nop
	nop
/*-------------- Setup Precharge Command ---------------------------*/
	li	t2,2
	li	t3,0
1:	li	t1,SDRAM_PC_VAL
	sw	t1,0x300(t0)
	nop
	nop
	lw	t7,0x300(t0)
	nop
	li	t4,APATTERN
#ifdef S334
#if DRAMSZ != MB32SO
	li	t5,0xA0000000 | DRAM_BNK0_BASE
#else
#ifdef S334A
	li	t5,0xA0000000 | DRAM_BNK0_BASE
#else
	li	t5,0xA0000000 | DRAM_BNK3_BASE
#endif
#endif
#else
	li	t5,0xA0000000 | DRAM_BNK0_BASE
#endif
	sw	t4,0x0(t5)
	addu	t3,1
	bne	t3,t2,1b
	nop
#ifdef S334
/*-------------- Setup Refresh Command -----------------------------*/
	li	t2,8
	li	t3,0
1:	li	t1,SDRAM_RFRSH_CMD
	sw	t1,0x300(t0)
	sw	t4,0x0(t5)	/* note: t5 not disturbed */
	addu	t3,1
	bne	t3,t2,1b
	nop
#endif
/*-------------- Setup up to write to Mode Register ----------------*/
	li	t1,SDRAM_MODE_REG
	sw	t1,0x300(t0)
#ifdef S1254
	addu	t5,0xC0		/* CAS Latency of 3 */
#else
	addu	t5,0x80
#endif
	sw	t4,0x0(t5)
#ifdef S334
	ori     t1,t1,0xff
	sw      t1,0x300(t0)
#endif
#endif /* MEMCFG == SDRAM_ONLY || MEMCFG == SRAM_N_SDRAM || MEMCFG == SDRAM_N_SRAM */

/*-------------- Setup and Enable Refresh Timer --------------------*/

	li	t0,TIMER_BASE		/* load timer register set base */

	li	t1,0			/* load DRAM refresh timer count register bit settings in t1 */
	sw	t1,0x64(t0)		/* set DRAM refresh timer count register bit settings */

	li	t1,DRAM_RF_CMPR_BS	/* load DRAM refresh timer compare register bit settings in t1 */
	sw	t1,0x68(t0)		/* set DRAM refresh timer compare register bit settings */

	li	t1,CPU_BERR_BS
	sw	t1,0x48(t0)
	li	t1,IP_BERR_BS
	sw	t1,0x58(t0)

	li	t1,ENABLE_TIMER		/* load timer enable bit */
	sw	t1,0x60(t0)		/* enable refresh timer */
#ifdef S334
	/* the memory system may need  some time to start up... */
	li	v0,10000	/* 8x256us */
1:	bne	v0,zero,1b
	subu	v0,1		/* BDSLOT  */
	nop
	nop

	li	t1,DRAM_RF_CMPR_SE_BS	/* load refresh timer compare value for slower expiration */
	sw	t1,0x68(t0)		/* set compare register again */
#else
#if MEMCFG == EDO_ONLY || MEMCFG == EDO_N_SRAM || MEMCFG == SRAM_N_EDO
	/* the memory system may need up to 120us to start up... */
	li	v0,128		/* ~256us */
1:	bne	v0,zero,1b
	subu	v0,1		/* BDSLOT  */
	nop
	nop

	li	t1,DRAM_RF_CMPR_SE_BS	/* load refresh timer compare value for slower expiration */
	sw	t1,0x68(t0)		/* set compare register again */
#endif /* MEMCFG == EDO_ONLY || MEMCFG == EDO_N_SRAM || MEMCFG == SRAM_N_EDO */
#endif

#endif /* MEMCFG != SRAM_ONLY */
#if MEMCFG == SRAM_ONLY
/* ------------------------------- Setup SRAM if in place -----------------------------------------*/

/*
** write some thing else in DRAM BANK 0 BASE address first since it has 0 by default.
*/
	li	t1,0x01000000	/* load DRAM bank 0 physical address in t1 */
	sw	t1,0xC0(t0)		/* set DRAM bank 0 base */

	li	t0,MEM_BASE_BASE	/* load 2 base address registers' base */
	li	t1,MBA_REG1		/* load into memory base address register 1 */
	sw	t1,0x8(t0)		/* set the memory base address register for Chip Select 1 - SRAM */

	li	t1,MBM_REG1		/* load into memory base mask register 1 */
	sw	t1,0xC(t0)		/* set the memory base mask register for Chip Select 1 - SRAM */
#endif /* MEMCFG == SRAM_ONLY */


#endif /* (CPU_R4000) || defined(CPU_R32364) */

#if defined(S364)

/*
** before doing anything
** initialize the section of memory used by cache initialization
** whenever you boot out of ROM or reset-vector
** This assumed to be 1MB.
** --Sugan (11-22-96)
*/
	li	t0, 0xa0000000
	li	t1, 0xa0100000
1:
        sw      zero,0x00(t0)
        sw      zero,0x04(t0)
        sw      zero,0x08(t0)
        sw      zero,0x0c(t0)
	addiu	t0,16		# DO NOT put this instruction in the
                                # delay slot of "blt t0,t1,1b" since it
                                # will run over the 1M boundary for 16 byte
	                        # more which would cause problem if we have
	                        # exactly 1M memory available on board.
	nop
	blt	t0,t1,1b
        nop
	nop
	nop
3:
	mfc0	t0,C0_SR
	nop
	nop
	and	t0,~SR_BEV
	mtc0	t0,C0_SR
	nop
	nop
4:
#endif

	li	v0,100000		/* large delay */
1:	subu	v0,1			/* BDSLOT  */
	bne	v0,zero,1b
	nop
	nop

/*Copy ROM Into RAM and start execution */
       la      t0,_binary_zImage_bin_start
       la      t1,ZIMAGE_OFFSET
       la      t2,_binary_zImage_bin_end
       addu    t2,4
cpy:
       lw      t3,0(t0)
       sw      t3,0(t1)
       addu    t0,4
       addu    t1,4
       blt     t0,t2,cpy
       nop
       nop

       la      k0, ZIMAGE_OFFSET
       j      k0
       nop
       nop

ENDFRAME(start)
