/*
**  rp35xram.h - this header files contains common definitions used by
**  RP351, RP355, VB52100 SDRAM configuration.
*/


/*
*******************************************************************************
**  Copyright 2001 Integrated Device Technology, Inc.
**  All Rights Reserved
*******************************************************************************
*/

#ifndef __RP35XRAM__
#define __RP35XRAM__

/******************************** D E F I N E S *******************************/

#define RST_CTL_BASE      PHYS_TO_K1(0x18008000)  /* base address of reset controller register */
#define DEV_CTL_BASE      PHYS_TO_K1(0x18010000)  /* base address of device controller Registers */
#define SDRAM_CTL_BASE    PHYS_TO_K1(0x18018000)  /* base address of SDRAM controller Registers */
#define BANYAN_IREG_BASE  PHYS_TO_K1(0x18000000)  /* all Banyan internal registers' base address */
#define GPIO_BASE         PHYS_TO_K1(0x18040000)
#define ERR_CNTL_STATUS   0xb8028030
#define ERR_CNTL_VALUE    0x000000bf 

/********  Chip Select 0 Control Register settings ***********/
#ifdef RP355
#define MCR_CS0_BS    0x0208331C   
#elif defined(VB52100)          /* DEVCS0 should be set in csu_idt.S, default value to slow */
#define MCR_CS0_BS    0x01CA3F3C    /* OED=0xF >= RWS therefore disable OEN */
#else
#define MCR_CS0_BS    0x01CA333D 
#endif

#ifdef RP355
#define MCR_CS0_TC    0x00001133       
#else
#define MCR_CS0_TC    0x00001FFF
#endif

#define MCR_CS1_BS    0x01C73336
#define MCR_CS1_TC    0x00001fff

#define MCR_CS2_BS    0x0ffffff4
#define MCR_CS2_TC    0x00001fff

#define MCR_CS4_BS    0x0ffffff4
#define MCR_CS4_TC    0x00001fff

#define MCR_CS5_BS    0x0ffffff4
#define MCR_CS5_TC    0x00001fff

/*
** physical memory base address register value for Chip Select 0 - EPROM
*/
#define MBA_REG0      0x1FC00000

/*
** memory base mask register value for Chip Select 0 - EPROM - 4MB 
*/
#define MBM_REG0      0xFFC00000

#if defined(RP355) || defined(RP351NEW)
#define MBA_REG2      0x0C000000
#define MBM_REG2      0xFFFF0000
#else
#define MBA_REG2      0x0C000000
#define MBM_REG2      0xFC000000
#endif

#define MBA_REG4      0x14000000
#define MBM_REG4      0xFC000000

#define MBA_REG5      0x1A000000
#define MBM_REG5      0xFC000000

#define CPU_BERR_BS   0xFF
#define IP_BERR_BS    0xFF


#define APATTERN      0xa5a5a5a5

/*
** DRAM BANK 0 BASE. 
*/
#define DRAM_BNK0_BASE  0x00000000  /* 0 MB */
/*
** DRAM BANK 1 BASE.
*/
#if defined(RP355) || defined(RP351NEW)
#define DRAM_BNK1_BASE  0x01000000  /* 16 MB */
#elif   defined(RP351) || defined(VB52100)                             
#define DRAM_BNK1_BASE  0x00800000  /* 8 MB */
#else
#error  file rp355ram.h is designed for RP355,RP351, VB52100 only!
#endif
/*
** DRAM Bank 0 Mask
*/
#if defined(RP355) || defined(RP351NEW)
#define DRAM_BNK0_MASK  0xFF000000
#elif defined(RP351) || defined(VB52100) 
#define DRAM_BNK0_MASK  0xFF800000
#endif
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK  0x00000000

#if defined(RP351NEW)
#if (MHZ == 50000000)
#define SDRAM_CR_BS 0x880410F0 /* SDRAM enable */
#define SDRAM_DS_BS 0x08041080 /* SDRAM disable */
#define SDRAM_PC_VAL  0x080410c3 /* Precharge val */
#define SDRAM_RFRSH_CMD 0x08041093 /* refresh cmd */
#define SDRAM_MODE_REG  0x08041083 /* mode register */
#else
#define SDRAM_CR_BS 0x8A6510F0 /* SDRAM enable */
#define SDRAM_DS_BS 0x0A651080 /* SDRAM disable */
#define SDRAM_PC_VAL  0x0A6510c3 /* Precharge val */
#define SDRAM_RFRSH_CMD 0x0A651093 /* refresh cmd */
#define SDRAM_MODE_REG  0x0A651083 /* mode register */
#endif
#elif defined(RP351) || defined(VB52100)   
#define SDRAM_CR_BS 0x8A6500F0 /* SDRAM enable */
#define SDRAM_DS_BS 0x0A651080 /* SDRAM disable */
#define SDRAM_PC_VAL  0x0A6510c3 /* Precharge val */
#define SDRAM_RFRSH_CMD 0x0A651093 /* refresh cmd */
#define SDRAM_MODE_REG  0x0A651083 /* mode register */
#elif RP355
#define SDRAM_CR_BS 0x8A281080 /* SDRAM enable */
#define SDRAM_DS_BS 0x0a281080 /* SDRAM disable */
#define SDRAM_PC_VAL  0x0a6810c3 /* Precharge val */
#define SDRAM_RFRSH_CMD 0x0a681093 /* refresh cmd */
#define SDRAM_MODE_REG  0x0a681083 /* mode register */
#endif

#define DRAM_RF_CNT_BS  0x00000000 /* refresh count reg */
#define DRAM_RF_CMPR_BS 0x00000040 /* refresh comp reg */
#if defined(RP351NEW) || defined(RP355)  
#define DRAM_RF_CMPR_SE_BS  0x00000271 /* slow expiration */
#else
#define DRAM_RF_CMPR_SE_BS  0x00000400 /* slow expiration */
#endif

#endif /* __RP35XRAM__ */


