/**************************************************************************
 * csu_idt.S
 *
 * Board initialization.
 **************************************************************************
 * Ported from IDT/Sim
 *
 *   28 Oct 2002
 * P. Sadik    Pallathu.Sadik@idt.com
 **************************************************************************/

#include <linux/config.h>
#include <linux/threads.h>

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/offset.h>
#include <asm/cachectl.h>
#include "iregdef.h"
#include "idtcpu.h"
#include "idthdr.h"

#include "mhz.h"
#define  MHZ IDT_BUS_FREQ
#include "s364.h"

#include "rp35Xram.h"

#define IndexInvalidate_I       0x00

.extern _binary_zImage_bin_start,4
.extern _binary_zImage_bin_end,4
	
/*--------------------------------------------------------------
* prom entry point table
*-------------------------------------------------------------*/

FRAME(start,sp,0,ra)

	j idtstart  /* begin monitor from start |00| */
	
idtstart:

	.set  noreorder

	mtc0  zero, C0_CAUSE
	li    v0, 0x0
	or    v0, (SR_CU0 | SR_BEV | SR_DE)
	mtc0  v0, C0_SR

	mfc0  v1, C0_CONFIG
	li    v0, CFG_C_NCHRNT_WB  /* CFG_C_NCHRNT_WB  CFG_C_NCHRNT_WT_NWA CFG_C_UNCACHED */
	and   v1, ~(0x7)
	or    v1, v1, v0
	mtc0  v1, C0_CONFIG
	nop
	nop
	li    t0, ERR_CNTL_STATUS
	lw    t1, 0(t0) 
	li    t2, ERR_CNTL_VALUE
	and   t1, t2  
	sw    t1, 0(t0)  

	li    t0, DEV_CTL_BASE    /* load 2 base address registers' base */

	li    t1, MCR_CS0_BS    /* device0 control parameter */
	sw    t1, 0x8(t0)   /* set the control register for Chip Select 1 - SRAM */
	li    t1, MCR_CS0_TC    /* device0 timing config. parameter */
	sw    t1, 0xC(t0)
	li    t1, 0x0     /* load into  device base mask register 4 */
	sw    t1, 0x44(t0)    /* set the device base mask register for Chip Select 4 - EXT UART */
	li    t1, 0     /* load into  device base mask register 5 */
	sw    t1, 0x54(t0)    /* Disable the Mask - LCD */
	li    t1, 0     /* load into  device base mask register 2 */
	sw    t1, 0x24(t0)    /* set the device base mask register for Chip Select 2 - RTC on S355 board ONLY */
	li    t1, 0     /* load into  device base mask register 3 */
	sw    t1, 0x34(t0)    /* set the device base mask register for Chip Select 3 */

  /* USB fix for RP355 - set GPIO_26 as GPIO output low */
	li    t0, GPIO_BASE
	li    t1, 0xf9ffffff    /* All alternate functions for GPIO pins except GPIO_26*/
	sw    t1, 0x0(t0)

	lw    t1, 0x8(t0)   /* Reset GPIOD bit */
	and   t1, ~0x04000000
	sw    t1, 0x8(t0)

	lw    t2, 0x4(t0)   /* Set as output */
	or    t2, 0x04000000
	sw    t2, 0x4(t0)

	sw    t1, 0x8(t0)   /* Once again reset output */

/*------------ load all R32355 internal registers' base address ----------*/
	li    t0, TIMER_BASE  

/* ------------------- Disable WatchDog Timer --------------------------------- */
	li    t1, DISABLE_TIMER
	sw    t1, 0x40(t0)

/* ------------------- Reduce Bus Timeout Count -----------------------------*/
	li    t1, TIMEOUT_COUNT
	sw    t1, 0x34(t0)

/*-------------- Initialize SDRAM  Base and Mask Registers ----------*/

	li    t0, SDRAM_CTL_BASE
	li    t1, SDRAM_CR_BS
	li    t2, 0x7FFFFFFF
	and   t1, t1, t2
	sw    t1, 0x10(t0)             /* disable SDRAM refresh */

	li    t1, 0x0     /* Disable Bank0 */
	sw    t1, 0x4(t0)
	li    t1, 0x0     /* Disable Bank1 */
	sw    t1, 0xC(t0)   /* set DRAM bank 1 mask */
	
	li    t1, DRAM_BNK0_BASE  /* load DRAM bank 0 physical address in t1 */
	sw    t1, 0x0(t0)   /* set DRAM bank 0 base */
	li    t1, DRAM_BNK0_MASK  /* load DRAM bank 0 size in t1 */
	sw    t1, 0x4(t0)   /* set DRAM bank 0 mask */

/*-------------- Enable SDRAM Controller ---------------------------*/
	li    t0, SDRAM_CTL_BASE

/*-------------- Setup Precharge Command ---------------------------*/
	li    t2, 2
	li    t3, 0
1:  
	li    t1, SDRAM_PC_VAL
	sw    t1, 0x10(t0)
	nop
	nop
	lw    t7, 0x10(t0)
	nop
	li    t4, APATTERN
	li    t5, 0xA0000000 | DRAM_BNK0_BASE
	sw    t4, 0x0(t5)
	addu  t3, 1
	bne   t3, t2, 1b
        nop
/*--------------- Setup Refresh Command ----------------------------*/
	li    t2, 8
	li    t3, 0
	1:      
	li    t1, SDRAM_RFRSH_CMD
	sw    t1, 0x10(t0)
	sw    t4, 0x0(t5)
	addu  t3, 1
	bne   t3, t2, 1b
	nop
/*-------------- Setup up to write to Mode Register ----------------*/
	li    t1, SDRAM_MODE_REG
	sw    t1, 0x10(t0)
	addu  t5, 0x80            /* Kasi addu  t5,0xC0 (CL=3)*/
	sw    t4, 0x0(t5) /* note: same old t5 */

/*-------------- Setup and Enable Refresh Timer --------------------*/

	li    t0, TIMER_BASE    /* load timer register set base */

	li    t1, DISABLE_TIMER /* load diable timer bit settings into t1 */
	sw    t1, 0x2c(t0)    /* disable timer */

	li    t1, 0     /* load DRAM refresh timer count register bit settings in t1 */
	sw    t1, 0x24(t0)    /* set DRAM refresh timer count register bit settings */
	li    t1, DRAM_RF_CMPR_SE_BS  /* load refresh timer compare value for slower expiration */
	sw    t1, 0x28(t0)    /* set compare register again */

	li    t1, ENABLE_TIMER    /* load timer enable bit */
	sw    t1, 0x2c(t0)    /* enable refresh timer */

	li    t0, SDRAM_CTL_BASE
	li    t1, SDRAM_CR_BS
	sw    t1, 0x10(t0)
/* the memory system may need up to 120us to start up... */
	li    v0, 128   /* ~256us */
1:  
	bne   v0, zero, 1b
	subu  v0, 1   /* BDSLOT  */
	nop
	nop
	
/************************************************************************
** before doing anything
** initialize the section of memory used by cache initialization
** whenever you boot out of ROM or reset-vector
** This assumed to be 1MB.
** --Sugan (11-22-96)
************************************************************************/

	li    t0, 0xa0000000
	li    t1, 0xa0100000
1:
	sw    zero, 0x00(t0)
	sw    zero, 0x04(t0)
	sw    zero, 0x08(t0)
	sw    zero, 0x0c(t0)
	addiu t0, 16
	nop
	blt   t0, t1, 1b
	nop
	nop
	nop
3:
	mfc0  t0, C0_SR
	nop
	nop
	and   t0, ~SR_BEV
	mtc0  t0, C0_SR
	nop
	nop
4:

/*Copy ROM Into RAM and start execution */
	la      t0,_binary_zImage_bin_start
	la      t1,ZIMAGE_OFFSET
	la      t2,_binary_zImage_bin_end
	addu    t2,4
cpy:    
	lw      t3,0(t0)
	sw      t3,0(t1)
	addu    t0,4
	addu    t1,4
	blt     t0,t2,cpy
	nop
	nop

	la      k0, ZIMAGE_OFFSET
	j      k0
	nop
	nop
		
ENDFRAME(start)
