/*
**  s438ram.h - this header files contains common definitions used by
**  Acacia SRAM and DDR SDRAM configuration.
*/


/*
*******************************************************************************
**  Copyright 1998 Integrated Device Technology, Inc.
**  All Rights Reserved
*******************************************************************************
*/

#ifndef __S438RAM__
#define __S438RAM__
/******************************** D E F I N E S *******************************/

#define SRAM_ONLY     1
#define SDRAM_ONLY    2
#define SRAM_N_SDRAM  3
#define SDRAM_N_SRAM  4

#define MB32      1
#define MB64      2
#define MB128     3

#define DEV_CTL_BASE        PHYS_TO_K1(0x18010000)  /* device controller regs */
#define DDR_CTL_BASE        PHYS_TO_K1(0x18018010)  /* DDR controller regs */

#define DEV1_BASE           0x08000000
#define DEV_PROM_MASK       0xFFF00000
#define DEV_PROM_CTRL       0x04108324
#define DEV_PROM_TC         0x00000000
#define DEV_FLASH_MASK      0xFFE00000
#define DEV_FLASH_CTRL      0x04108325
#define DEV_FLASH_TC        0x00000000

#define DEV2_BASE           0x0C000000
#define DEV2_MASK           0xFC000000
#define DEV2_CTRL           0x04108324              /* 8-bit devices */
#define DEV2_TC             0x00000000

#if MEMCFG == SRAM_ONLY || MEMCFG == SRAM_N_SDRAM
#define DEV3_BASE           0x00000000
#define DEV3_MASK           0xFC000000
#define DEV3_CTRL           0x04108325              /* 16-bit devices */
#define DEV3_TC             0x00000000
#else
#define DEV3_BASE           0x10000000
#define DEV3_MASK           0xFC000000
#define DEV3_CTRL           0x04108325              /* 16-bit devices */
#define DEV3_TC             0x00000000
#endif

#define DEV4_BASE           0x00000000
#define DEV4_MASK           0x00000000
#define DEV4_CTRL           0x0FFFFFF4              /* ?-bit devices */
#define DEV4_TC             0x00001FFF

#define DEV5_BASE           0x00000000
#define DEV5_MASK           0x00000000
#define DEV5_CTRL           0x0FFFFFF4              /* ?-bit devices */
#define DEV5_TC             0x00001FFF

#define DATA_PATTERN        0xA5A5A5A5
#define RCOUNT              PHYS_TO_K1(0x18028024)

#if DRAMSZ == MB64

#if MEMCFG == SDRAM_ONLY || MEMCFG == SDRAM_N_SRAM
#define DDR0_BASE_VAL       0x00000000
#define DDR0_MASK_VAL       0xFC000000
#define DDR1_BASE_VAL       0x04000000
#define DDR1_MASK_VAL       0x00000000
#define DDR0_ABASE_VAL      0x08000000
#define DDR0_AMASK_VAL      0x00000000
#elif MEMCFG == SRAM_N_SDRAM
#define DDR0_BASE_VAL       0x04000000
#define DDR0_MASK_VAL       0xFC000000
#define DDR1_BASE_VAL       0x08000000
#define DDR1_MASK_VAL       0x00000000
#define DDR0_ABASE_VAL      0x00000000
#define DDR0_AMASK_VAL      0x00000000
#elif MEMCFG == SRAM_ONLY
#define DDR0_BASE_VAL       0x00000000
#define DDR0_MASK_VAL       0x00000000
#define DDR1_BASE_VAL       0x00000000
#define DDR1_MASK_VAL       0x00000000
#define DDR0_ABASE_VAL      0x00000000
#define DDR0_AMASK_VAL      0x00000000
#else
illegal value for MEMCFG
#endif

#define DDRC_VAL_NORMAL       0xA32A4980
#define DDRC_VAL_AT_INIT      0x232A4980

#define DDR_REF_CMP_FAST      0x00000080 /* was 0x00000100 */
#define DDR_REF_CMP_VAL       0x00000080 /* was 0x0000040e */

#define DDR_CUST_NOP          0x0000003F
#define DDR_CUST_PRECHARGE    0x00000033
#define DDR_CUST_REFRESH      0x00000027
#define DDR_LD_MODE_REG       0x00000023
#define DDR_LD_EMODE_REG      0x00000063

/* 
 * All generated addresses for DDR init during custom transactions are shifted
 * by two address lines - see spec for used DDR chip
 */
#define DDR_PRECHARGE_OFFSET  0x00001000  /* 0x0400 - 9-bit page*/
#define DDR_EMODE_VAL         0x00000000  /* 0x0000 */
#define DDR_DLL_RES_MODE_VAL  0x00000584  /* 0x0161 - Reset DLL, CL2.5 */
#define DDR_DLL_MODE_VAL      0x00000184  /* 0x0061 - CL2.5 */

#define DELAY_200USEC         25000       /* not exactly */

#else
#error "unrecognized dram size"
#endif

#endif
