/**************************************************************************
 * csu_idt.S
 *
 * Board initialization.
 **************************************************************************
 * Ported from IDT/Sim
 *
 *   Nov 06 2002
 * P. Sadik    Pallathu.Sadik@idt.com
 **************************************************************************/

#include <linux/config.h>
#include <linux/threads.h>

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/offset.h>
#include <asm/cachectl.h>

#include "idthdr.h"
#include "iregdef.h"
#include "idtcpu.h"
#include "s438ram.h"
#include "s438.h"

#define IndexInvalidate_I       0x00

.extern _binary_zImage_bin_start,4
.extern _binary_zImage_bin_end,4
	
/*--------------------------------------------------------------
** prom entry point table
*-------------------------------------------------------------*/

FRAME(start,sp,0,ra)
  j idtstart        /* begin monitor from start       |00| */

idtstart:

  .set  noreorder
/* ------ Alternate functions for GPIO pins --------------------------------*/
/* Neb: only UART0, UART1 and mem_addr */
      li    t0, GPIO_BASE
      li    t1, 0x00f00303
      sw    t1, 0x0(t0)
      
      mtc0  zero, C0_CAUSE
            nop
      li    v0, 0x0
      or    v0, (SR_CU0 | SR_BEV)
      mtc0  v0, C0_SR
            nop
      mfc0  v1, C0_CONFIG
            nop
      and   v1, ~(0x7)
      ori   v1, 0x3
      mtc0  v1, C0_CONFIG
            nop
            nop
            
/* ------------------- Disable WatchDog Timer ----------------------------- */
      li    t0, TIMER_BASE
      li    t1, 0x0
      sw    t1, 0x3C(t0) /* WTC */

/* ------------------- Setup Device Controller ---------------------------- */
      li    t0, DEV_CTL_BASE      /* load 2 base address registers' base    */
      lui   t2, 0xB800
      lw    t1, 0x8004(t2)        /* get BCV                                */
      li    t2, 0x80              /* check width of boot device 8/16 bit    */
      and   t1, t1, t2
      bnez  t1, 1f                
            nop
    /* 8 bit device - boot from PROM - CS1 is FLASH                         */
      li    t1, DEV_PROM_CTRL     /* device0 control parameter              */
      sw    t1, 0x8(t0)           /* set the control register  CS0          */
      li    t1, DEV_PROM_TC       /* device0 timing config parameter        */
      sw    t1, 0xC(t0)
      li    t1, DEV1_BASE         /* set the device base register for CS1   */
      sw    t1, 0x10(t0)
      li    t1, DEV_FLASH_MASK    /* set the device mask register for CS1   */
      sw    t1, 0x14(t0) 
      li    t1, DEV_FLASH_CTRL    /* set the device control register for CS1*/
      sw    t1, 0x18(t0)
      li    t1, DEV_FLASH_TC      /* set the device timing register for CS1 */
      sw    t1, 0x1C(t0) 
      b     2f                    
            nop
1:
    /* 16 bit device - boot from FLASH - CS1 is PROM                        */
      li    t1, DEV_FLASH_CTRL    /* device0 control parameter              */
      sw    t1, 0x8(t0)           /* set the control register  CS0          */
      li    t1, DEV_FLASH_TC      /* device0 timing config parameter        */
      sw    t1, 0xC(t0)
      li    t1, DEV1_BASE         /* set the device base register for CS1   */
      sw    t1, 0x10(t0)
      li    t1, DEV_PROM_MASK     /* set the device mask register for CS1   */
      sw    t1, 0x14(t0) 
      li    t1, DEV_PROM_CTRL     /* set the device control register for CS1*/
      sw    t1, 0x18(t0)
      li    t1, DEV_PROM_TC       /* set the device timing register for CS1 */
      sw    t1, 0x1C(t0) 
2:
      li    t1, DEV2_BASE         /* set the device base register for CS1   */
      sw    t1, 0x20(t0)
      li    t1, DEV2_MASK         /* set the device mask register for CS1   */
      sw    t1, 0x24(t0) 
      li    t1, DEV2_CTRL         /* set the device control register for CS1*/
      sw    t1, 0x28(t0)
      li    t1, DEV2_TC           /* set the device timing register for CS1 */
      sw    t1, 0x2C(t0) 

      li    t1, DEV3_BASE         /* set the device base register for CS1   */
      sw    t1, 0x30(t0)
      li    t1, DEV3_MASK         /* set the device mask register for CS1   */
      sw    t1, 0x34(t0) 
      li    t1, DEV3_CTRL         /* set the device control register for CS1*/
      sw    t1, 0x38(t0)
      li    t1, DEV3_TC           /* set the device timing register for CS1 */
      sw    t1, 0x3C(t0) 

      li    t1, DEV4_BASE         /* set the device base register for CS1   */
      sw    t1, 0x40(t0)
      li    t1, DEV4_MASK         /* set the device mask register for CS1   */
      sw    t1, 0x44(t0) 
      li    t1, DEV4_CTRL         /* set the device control register for CS1*/
      sw    t1, 0x48(t0)
      li    t1, DEV4_TC           /* set the device timing register for CS1 */
      sw    t1, 0x4C(t0) 

      li    t1, DEV5_BASE         /* set the device base register for CS1   */
      sw    t1, 0x50(t0)
      li    t1, DEV5_MASK         /* set the device mask register for CS1   */
      sw    t1, 0x54(t0) 
      li    t1, DEV5_CTRL         /* set the device control register for CS1*/
      sw    t1, 0x58(t0)
      li    t1, DEV5_TC           /* set the device timing register for CS1 */
      sw    t1, 0x5C(t0) 

#if MEMCFG != SRAM_ONLY

/* ------------- INITIALIZE DDR SDRAM CONTROLLER ---------------------------*/

      li    t1, 0x0               /* Add 200 microseconds of delay */
      li    t2, DELAY_200USEC
1:
      add   t1, 1
      bne   t1, t2, 1b
            nop

/*-------------- Initialize DDR Base and Mask Registers --------------------*/

      li    t0, DDRBASE

/* DDR temporary fix DDRRDC = 1*/
      li    t1, 0x1
      sw    t1, 0x24(t0)

  /* Load the DDRC, reset  Refresh Enable */
      li    t1, DDRC_VAL_AT_INIT
      sw    t1, 0x10(t0)
      
      sw    zero, 0x4(t0)
      sw    zero, 0xc(t0)
      sw    zero, 0x18(t0)

  /* Store DDR0BASE */
      li    t1, DDR0_BASE_VAL
      sw    t1, 0x0(t0)

  /* Store DDR0MASK */
      li    t1, DDR0_MASK_VAL
      sw    t1, 0x4(t0)

  /* Store DDR1BASE */
      li    t1, DDR1_BASE_VAL
      sw    t1, 0x8(t0)

  /* Load DDR1MASK to disable DDR CS1 */
      li    t1, DDR1_MASK_VAL
      sw    t1, 0x0C(t0)

  /* Store DDR0ABASE */
      li    t1, DDR0_BASE_VAL
      sw    t1, 0x14(t0)

  /* Load DDR0AMASK to disable alternate Mapping */
      li    t1, DDR0_AMASK_VAL
      sw    t1, 0x18(t0)

      li    t1, DDR_CUST_NOP      /* Write to DDR Custom transaction register */
      sw    t1, 0x20(t0)

      li    t2, DATA_PATTERN
      li    t1, 0xA0000000 | DDR0_BASE_VAL
      sw    t2, 0x0(t1)

  /* Add 200 microseconds of delay */
      li    t1, 0x0
      li    t2, DELAY_200USEC
1:
      add   t1, 1
      bne   t1, t2, 1b
            nop
            
  /* Register t0 carries pointer to the DDR_BASE: 0xB8018000 */
      li    t1, DDR_CUST_PRECHARGE
      sw    t1, 0x20(t0)    /* Write to DDR Custom transaction register */

  /* Generate A10 high to pre-charge both the banks */
      li    t2, DATA_PATTERN
      li    t1, 0xA0000000 | DDR_PRECHARGE_OFFSET | DDR0_BASE_VAL
      sw    t2, 0x0(t1)

  /* Register t0 carries pointer to the DDR_BASE: 0xB8018000 */
      li    t1, DDR_LD_EMODE_REG
      sw    t1, 0x20(t0)    /* Write to DDR Custom transaction register */

  /* Generate EMODE register contents on A15-A2 */
      li    t2, DATA_PATTERN
      li    t1, 0xA0000000 | DDR_EMODE_VAL | DDR0_BASE_VAL
      sw    t2, 0x0(t1)

  /* Register t0 carries pointer to the DDR_BASE: 0xB8018000 */
      li    t1, DDR_LD_MODE_REG
      sw    t1, 0x20(t0)    /* Write to DDR Custom transaction register */

  /* Generate Mode register contents on the address bus A15-A2  */
      li    t2, DATA_PATTERN
      li    t1, 0xA0000000 | DDR_DLL_RES_MODE_VAL | DDR0_BASE_VAL
      sw    t2, 0x0(t1)

  /* Delay of  1.6 microseconds ~ 300 delay iteration value */
      li    t1, 0x0
      li    t2, 500
1:
      add   t1, 1
      bne   t1, t2, 1b
            nop

  /* Register t0 carries pointer to the DDR_BASE: 0xB8018000 */
      li    t1, DDR_CUST_PRECHARGE
      sw    t1, 0x20(t0)    /* Write to DDR Custom transaction register */

  /* Generate A10 high to pre-charge both the banks */
      li    t2, DATA_PATTERN
      li    t1, 0xA0000000 | DDR_PRECHARGE_OFFSET | DDR0_BASE_VAL
      sw    t2, 0x0(t1)

  /* Implements 9 cycles of Auto refresh allowing 
     sufficient margin for stability*/
      li    t4, 9
      li    t3, 0
1:
      li    t1, DDR_CUST_REFRESH
      sw    t1, 0x20(t0)    /* Write to DDR Custom transaction register */

  /* Read it back to flush CPU write buffers */
      lw    t1, 0x20(t0)

  /* Access DDR */
      li    t2, DATA_PATTERN
      li    t1, 0xA0000000 | DDR0_BASE_VAL
      sw    t2, 0x0(t1)

      add   t3, 1
      bne   t3, t4, 1b
            nop

  /* Register t0 carries pointer to the DDR_BASE: 0xB8018000 */
      li    t1, DDR_LD_MODE_REG
      sw    t1, 0x20(t0)    /* Write to DDR Custom transaction register */

  /* Generate Mode Register contents on the address bus A12-A0 */
      li    t2, DATA_PATTERN
      li    t1, 0xA0000000 | DDR_DLL_MODE_VAL | DDR0_BASE_VAL
      sw    t2, 0x0(t1)

  /* Initialize the refresh timer with fast refresh count */
      li    t0, RCOUNT
      li    t1, DDR_REF_CMP_FAST
      
  /* Set the RCOMPARE register */
      sw    t1, 0x4(t0)

  /* Enable the Refresh timer */
      li    t1, 0x1           /* CE set to enabled the  Refresh counter */
      sw    t1, 0x8(t0)

  /* Enable RE-refresh enable in the DDRC register */
      li    t0, DDRBASE
      li    t1, DDRC_VAL_NORMAL
      sw    t1, 0x10(t0)

  /* Add 200 microseconds of delay */
      li    t1, 0x0
      li    t2, DELAY_200USEC
1:
      add   t1, 1
      bne   t1, t2, 1b
            nop

      li    t0, RCOUNT
  /* Disable the refresh counter before changing the compare value */
      li    t1, 0x0
      sw    t1, 0x8(t0)

  /* Set the RCOMPARE register */
      li    t1, DDR_REF_CMP_VAL
      sw    t1, 0x4(t0)

  /* Enable the Refresh timer */
      li    t1, 0x1           /* CE set to enabled the  Refresh counter */
      sw    t1, 0x8(t0)

  /* Add 200 microseconds of delay */
      li    t1, 0x0
      li    t2, DELAY_200USEC
1:
      add   t1, 1
      bne   t1, t2, 1b
            nop

#endif
	li    t0, 0xa0000000
	li    t1, 0xa0100000
1:
	sw    zero, 0x00(t0)
	sw    zero, 0x04(t0)
	sw    zero, 0x08(t0)
	sw    zero, 0x0c(t0)
	addiu t0, 16
	nop
	blt   t0, t1, 1b
	nop
	nop
	nop
3:
	mfc0  t0, C0_SR
	nop
	nop
	and   t0, ~SR_BEV
	mtc0  t0, C0_SR
	nop
	nop
4:

/*Copy ROM Into RAM and start execution */
	la      t0,_binary_zImage_bin_start
	la      t1,ZIMAGE_OFFSET
	la      t2,_binary_zImage_bin_end
	addu    t2,4
cpy:    
	lw      t3,0(t0)
	sw      t3,0(t1)
	addu    t0,4
	addu    t1,4
	blt     t0,t2,cpy
	nop
	nop

	la      k0, ZIMAGE_OFFSET
	j      k0
	nop
	nop

ENDFRAME(start)
