/*
**  s434ram.h - this header files contains common definitions used by
**  Acacia SRAM and DDR SDRAM configuration.
*/

/*
*******************************************************************************
**  Copyright 1998 Integrated Device Technology, Inc.
**  All Rights Reserved
*******************************************************************************
*/

#ifndef __S434RAM__
#define __S434RAM__
/******************************** D E F I N E S *******************************/

#define MB32      1
#define MB64      2
#define MB128     3

#define DEV_CTL_BASE        PHYS_TO_K1(0x18010000)	/* device controller regs */
#define DDR_CTL_BASE        PHYS_TO_K1(0x18018010)	/* DDR controller regs */

#define DEV0_BASE           0x1FC00000
#define DEV0_MASK           0xFFC00000
#define DEV0_CTRL           0x04108324	/* 8-bit devices */
#define DEV0_TC             0x00000000
#define DEV1_BASE           0x1A000000
#define DEV1_MASK           0xFE000000
#define DEV1_CTRL           0x04108324	/* 8-bit devices */
#define DEV1_TC             0x00000000

#define DEV2_BASE           0x19000000
#define DEV2_MASK           0xFF000000
#define DEV2_CTRL           0x04108324	/* 8-bit devices */
#define DEV2_TC             0x00000000

#define DEV3_BASE           0x00000000
#define DEV3_MASK           0x00000000
#define DEV3_CTRL           0x0FFFFFF4	/* 8-bit devices */
#define DEV3_TC             0x00001FFF

#define DATA_PATTERN        0xA5A5A5A5
#define RCOUNT              PHYS_TO_K1(0x18028030)

#if DRAMSZ == MB32

#define DDR_BASE_VAL          0x00000000
#define DDR_MASK_VAL          0xFE000000
#define DDR_ABASE_VAL         0x08000000
#define DDR_AMASK_VAL         0x00000000

#if MHZ == 100000000
#define DDRC_VAL_NORMAL       0x82984840
#define DDRC_VAL_AT_INIT      0x02984840
#define DDR_REF_CMP_VAL       0x0000030c
#elif MHZ == 133000000
#define DDRC_VAL_NORMAL       0xA32A4840
#define DDRC_VAL_AT_INIT      0x232A4840
#define DDR_REF_CMP_VAL       0x0000040e
#else
#warning illegal value for MHZ
#endif

#define DDR_REF_CMP_FAST      0x00000080

#define DDR_CUST_NOP          0x0000003F
#define DDR_CUST_PRECHARGE    0x00000033
#define DDR_CUST_REFRESH      0x00000027
#define DDR_LD_MODE_REG       0x00000023
#define DDR_LD_EMODE_REG      0x00000063

/* 
 * All generated addresses for DDR init during custom transactions are shifted
 * by two address lines - see spec for used DDR chip
 */
#define DDR_PRECHARGE_OFFSET  0x00001000	/* 0x0400 - 9-bit page */
#define DDR_EMODE_VAL         0x00000000	/* 0x0000 */
#define DDR_DLL_RES_MODE_VAL  0x00000584	/* 0x0161 - Reset DLL, CL2.5 */
#define DDR_DLL_MODE_VAL      0x00000184	/* 0x0061 - CL2.5 */

#define DELAY_200USEC         25000	/* not exactly */

#else
#error "unrecognized dram size"
#endif

#endif
