
/*
**	debugger macros for assembly language routines. Allows the 
**	programmer to easily set up the necessary stack frame info
**	required by debuggers to to stack traces.
*/
#ifndef XDS

#define	FRAME(name,frm_reg,offset,ret_reg)	\
	.globl	name;				\
	.ent	name;				\
name:;						\
	.frame	frm_reg,offset,ret_reg

#define ENDFRAME(name) 	.end name

#else

#define FRAME(name,frm_reg,offset,ret_reg)      \
name:

#define ENDFRAME(name)

#endif
