/*
**  S355ram.h - this header files contains common definitions used by
**  BANYAN SRAM and SDRAM configuration.
*/


/*
*******************************************************************************
**  Copyright 1998 Integrated Device Technology, Inc.
**  All Rights Reserved
*******************************************************************************
*/

#ifndef __S355RAM__
#define __S355RAM__
/******************************** D E F I N E S *******************************/
#define SRAM_ONLY     1
#define SDRAM_ONLY    2
#define SRAM_N_SDRAM  3
#define SDRAM_N_SRAM  4
 
#define MB32    1
#define MB64    2
#define MB128   3
#define MB32SO  4


#define EXTU  1
#define INTU  2

#define RST_CTL_BASE      PHYS_TO_K1(0x18008000)  /* base address of reset controller register */
#define DEV_CTL_BASE      PHYS_TO_K1(0x18010000)  /* base address of device controller Registers */
#define SDRAM_CTL_BASE    PHYS_TO_K1(0x18018000)  /* base address of SDRAM controller Registers */
#define BANYAN_IREG_BASE  PHYS_TO_K1(0x18000000)  /* all Banyan internal registers' base address */
#define GPIO_BASE         PHYS_TO_K1(0x18040000)
#define ERR_CNTL_STATUS   0xb8028030
#define ERR_CNTL_VALUE    0x000000bf

/*
** b14:13=>01=PROM;b12=>1= do not assert CS during writes; b11:10=>00=8 bit port
** b09:05=>0A=10 wait states; b04:00=>0A= 10 wait states
*/


/********  Chip Select 0 Control Register settings ***********/
#if defined(EB355)
#define MCR_CS0_BS    0x028A2204
#define MCR_CS0_TC    0x00000A44
#else
#define MCR_CS0_BS    0x01CA333C
#define MCR_CS0_TC    0x00001FFF
#endif

/*
** b14:13=>00=SRAM;b12=>0= assert CS during writes; b11:10=>10=32 bit port
** b09:05=>FF=31 wait states; b04:00=>FF= 31 wait states.
** NOTE: wait states should be tuned.
*/


/*#define MCR_CS1_BS    0x28e728e7*/
#define MCR_CS1_BS    0x01C73336
#define MCR_CS1_TC    0x00001fff

/*
** b14:13=>01=I Type;b12=>0= assert CS during writes; b11:10=>00=8 bit port
** b09:05=>FF=31 wait states; b04:00=>FF= 31 wait states
*/
#define MCR_CS2_BS    0x0ffffff4
#define MCR_CS2_TC    0x00001fff

#ifdef EB355
#define MCR_CS3_BS    0x0ffffff4
#define MCR_CS3_TC    0x00001fff
#endif

#define MCR_CS4_BS    0x0ffffff4
#define MCR_CS4_TC    0x00001fff

#define MCR_CS5_BS    0x0ffffff4
#define MCR_CS5_TC    0x00001fff

/*
** physical memory base address register value for Chip Select 0 - EPROM
** NOTE: for starters see if you can just set the default value: 0x1FC00000 Banyan
*/
#define MBA_REG0    0x1FC00000

/*
** memory base mask register value for Chip Select 0 - EPROM - 4MB Banyan
*/
#define MBM_REG0    0xFFC00000

#define MBA_REG2    0x0C000000
#define MBM_REG2    0xFC000000

#ifdef EB355
#define MBA_REG3    0x1A000000
#define MBM_REG3    0xFFFF0000
#endif

#define MBA_REG4    0x14000000
#define MBM_REG4    0xFC000000

#define MBA_REG5    0x1A000000
#ifdef EB355
#define MBM_REG5    0xFFFF0000
#else
#define MBM_REG5    0xFC000000
#endif

#define CPU_BERR_BS   0xFF
#define IP_BERR_BS    0xFF



#if MEMCFG == SRAM_ONLY
/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1    0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1    0xFFF00000

#elif MEMCFG == SDRAM_ONLY || MEMCFG == SDRAM_N_SRAM
/*
*************************************
** SDRAM_ONLY or SDRAM_N_SRAM section
*************************************
*/

#define APATTERN 0xa5a5a5a5

#if DRAMSZ == MB64
/*
===============================
== 128MB section
===============================
*/
/*
** DRAM BANK0 BASE.  Starting Bank at 0MB:
*/
#define DRAM_BNK0_BASE    0x00000000
/*
** DRAM BANK1 BASE. 2nd bank at 64MB:
*/
#define DRAM_BNK1_BASE    0x04000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK    0xFFF00000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK    DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS   0xb95500FF  /* old: 0x9EFBOOFF */
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS   0x2AF800FF
/*
** Precharge Value
*/
#define SDRAM_PC_VAL    0xb95501a0
/*
** Refresh Cmd
*/
#define SDRAM_RFRSH_CMD   0xb9550090
/*
** Mode Register
*/
#define SDRAM_MODE_REG    0xAAF80080

#if MEMCFG == SDRAM_N_SRAM
/*
** physical memory base address register value for Chip Select 1 - SRAM
** at 128MB:
*/
#define MBA_REG1    0x08000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1    0xFFF00000

#endif /* #if MEMCFG == SDRAM_N_SRAM */

#elif DRAMSZ == MB32
/*
===============================
== 32MB section
===============================
*/
/*
** DRAM BANK0 BASE.  Starting Bank at 0MB:
*/
#define DRAM_BNK0_BASE    0x00000000
/*
** DRAM BANK1 BASE. 2nd bank at 8MB:
*/
#define DRAM_BNK1_BASE    0x00800000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK    0xFF800000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK    DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS   0xB95500FF  /* 11:18:99 0xBAF800FF */
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS   0x395500FF  /* 11:18:99 0x3AF800FF */
/*
** Precharge Value
*/
#define SDRAM_PC_VAL    0xB95501A0  /* 11:18:99 0xBAF801A0 */
/*
** Refresh Cmd
*/
#define SDRAM_RFRSH_CMD   0xB9550090  /* 11:18:99 0xBAF80090 */
/*
** Mode Register
*/
#define SDRAM_MODE_REG    0xB9550080  /* 11:18:99 0xBAF80080 */
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS    0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS   0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS  0x000002A0

#if MEMCFG == SDRAM_N_SRAM
/*
** physical memory base address register value for Chip Select 1 - SRAM
** at 32MB:
*/
#define MBA_REG1    0x04000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1    0xFFF00000
#endif /* MEMCFG == SDRAM_N_SRAM */
#elif DRAMSZ == MB32SO
/*
===============================
== 32MB SODIMM section
===============================
*/
/*
** DRAM BANK0 BASE.  Starting Bank at 0MB:
*/
#define DRAM_BNK0_BASE    0x00000000
/*
** DRAM BANK1 BASE. 2nd bank at 8MB:
*/
#define DRAM_BNK1_BASE    0x02000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK    0xFE000000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK          0xFE000000
/*
** SDRAM ENABLE Settings
*/
/* for other boards such as S355, EB355
*/
#define SDRAM_CR_BS             0x9a281080
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS   0x1a681080
/*
** Precharge Value
*/
#define SDRAM_PC_VAL    0x1a6810c3
/*
** Refresh Cmd
*/

#define SDRAM_RFRSH_CMD         0x1a681093
/*
** Mode Register
*/
#define SDRAM_MODE_REG          0x1a681083

/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS    0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS   0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS  0x00000271

#if MEMCFG == SDRAM_N_SRAM
/*
** physical memory base address register value for Chip Select 1 - SRAM
** at 32MB:
*/
#define MBA_REG1    0x02000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1    0xFFF00000
#endif /* MEMCFG == SDRAM_N_SRAM */

#endif /* DRAMSZ == MB32SO */

#elif MEMCFG == SRAM_N_SDRAM

#define APATTERN 0xa5a5a5a5

/*
*******************************
** SRAM and SDRAM section
*******************************
*/
#if DRAMSZ == MB128
/*
===============================
== 128MB section
===============================
*/
/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1    0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1    0xFFF00000

/*
** DRAM BANK0 BASE.  Starting Bank at 32MB:
*/
#define DRAM_BNK0_BASE    0x02000000
/*
** DRAM BANK1 BASE. 2nd bank at 64MB:
*/
#define DRAM_BNK1_BASE    0x04000000
/*
** DRAM BANK2 BASE. 3rd bank at 96MB:
*/
#define DRAM_BNK2_BASE    0x06000000
/*
** DRAM BANK3 BASE. 4th bank at 128MB:
*/
#define DRAM_BNK3_BASE    0x08000000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK    0xFE000000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK    DRAM_BNK0_MASK
/*
** DRAM Bank 2 Mask
*/
#define DRAM_BNK2_MASK    DRAM_BNK0_MASK
/*
** DRAM Bank 3 Mask
*/
#define DRAM_BNK3_MASK    DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS   0xAAF800FF  /* old: 0x9EFBOOFF */
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS   0x2AF800FF
/*
** Precharge Value
*/
#define SDRAM_PC_VAL    0xAAF801A0
/*
** Refresh Cmd
*/
#define SDRAM_RFRSH_CMD   0xAAF80090
/*
** Mode Register
*/
#define SDRAM_MODE_REG    0xAAF80080
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS    0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS   0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS  0x000000A0

#elif DRAMSZ == MB32
/*
===============================
== 32MB section
===============================
*/

/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1    0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1    0xFFF00000

/*
** DRAM BANK0 BASE.  Starting Bank at 8MB:
*/
#define DRAM_BNK0_BASE    0x00800000
/*
** DRAM BANK1 BASE. 2nd bank at 16MB:
*/
#define DRAM_BNK1_BASE    0x01000000

/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK    0xFF800000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK    DRAM_BNK0_MASK
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS   0xB95500FF  /* 11:18:99 0xBAF800FF */
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS   0x395500FF  /* 11:18:99 0x3AF800FF */
/*
** Precharge Value
*/
#define SDRAM_PC_VAL    0xB95501A0  /* 11:18:99 0xBAF801A0 */
/*
** Refresh Cmd
*/
#define SDRAM_RFRSH_CMD   0xB9550090  /* 11:18:99 0xBAF80090 */
/*
** Mode Register
*/
#define SDRAM_MODE_REG    0xB9550080  /* 11:18:99 0xBAF80080 */
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS    0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS   0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS  0x000002A0  /* 11:18:99 0x000000A0 */

#elif DRAMSZ == MB32SO
/*
===============================
== 32MB section
===============================
*/

/*
** physical memory base address register value for Chip Select 1 - SRAM
*/
#define MBA_REG1    0x00000000

/*
** memory base mask register value for Chip Select 1 - SRAM - 1MB
*/
#define MBM_REG1    0xFFF00000

/*
** DRAM BANK0 BASE.  Starting Bank at 32MB:
*/
#define DRAM_BNK0_BASE    0x02000000
/*
** DRAM BANK1 BASE. 2nd bank at 16MB:
*/
#define DRAM_BNK1_BASE    0x02100000
/*
** DRAM Bank 0 Mask
*/
#define DRAM_BNK0_MASK    0xFE000000
/*
** DRAM Bank 1 Mask
*/
#define DRAM_BNK1_MASK    0xFE000000
/*
** SDRAM ENABLE Settings
*/
#define SDRAM_CR_BS   0x9a281080
/*
** SDRAM DISABLE Settings
*/
#define SDRAM_DS_BS   0x1a681080
/*
** Precharge Value
*/
#define SDRAM_PC_VAL    0x1a6810c3
/*
** Refresh Cmd
*/

#define SDRAM_RFRSH_CMD         0x1a681093
/*
** Mode Register
*/

#define SDRAM_MODE_REG          0x1a681083
/*
** Refresh Count Register Bit Settings
*/
#define DRAM_RF_CNT_BS    0x00000000
/*
** Refresh Compare Register Bit Settings
*/
#define DRAM_RF_CMPR_BS   0x00000040
/*
** Refresh Compare Register Bit Settings for Slow Expiration
*/
#define DRAM_RF_CMPR_SE_BS  0x00000271  /* 11:18:99 0x000000A0 */


#else
#error "unrecognized dram size"
#endif /* DRAMSZ */

#else
#error "unrecogized memory configuration parameter"
#endif /* error */

#endif /* __S355RAM__ */


