/*
  * arch/mips/vr7701/common/serial.c
  *
  * The serial port setup for VR7701.
  *
  * Author: MontaVista Software, Inc. <source@mvista.com>
  *
  * 2003 (c) MontaVista Software, Inc. This file is licensed under
  * the terms of the GNU General Public License version 2. This program
  * is licensed "as is" without any warranty of any kind, whether express
  * or implied.
  */

#include <linux/config.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/serial.h>
#include <linux/types.h>
#include <linux/string.h>	/* for memset */

#include <asm/reboot.h>
#include <asm/io.h>
#include <asm/time.h>

#include <asm/debug.h>
#include <asm/vr7701.h>

void __init
vr7701_init_serial(void)
{
	/* CSI unit raise the UART interrupt. The following code is to
	   clear CSI interrupt condition */
	/* Reset the CSI unit */
	vr7701_outw(VR7701_CSI_CNT, VR7701_CSI_CNT_CSIRST);
	udelay(1);
	vr7701_outw(VR7701_CSI_CNT, 0);
	while (vr7701_inb(VR7701_CSI_MODE) & VR7701_CSI_MODE_CSOT) ;

	/* Disable CSI unit */
	vr7701_outb(VR7701_CSI_MODE, 0);

	/* Clear CSI interrupts */
	vr7701_outw(VR7701_CSI_INT, VR7701_CSI_INT_END |
		    VR7701_CSI_INT_EMP | VR7701_CSI_INT_OVER);
}
