/*
  * arch/mips/vr7701/common/irq.c 
  *
  * init_IRQ function for NEC VR7701 processor.
  *
  * Author: MontaVista Software, Inc. <source@mvista.com>
  *
  * 2003 (c) MontaVista Software, Inc. This file is licensed under
  * the terms of the GNU General Public License version 2. This program
  * is licensed "as is" without any warranty of any kind, whether express
  * or implied.
  */

#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/signal.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/slab.h>
#include <linux/random.h>
#include <linux/pm.h>

#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/gdb-stub.h>
#include <asm/vr7701.h>

extern void breakpoint(void);
extern int setup_irq(unsigned int irq, struct irqaction *irqaction);

extern asmlinkage void vr7701_handle_irq(void);

extern void mips_cpu_irq_init(int irq_base);
extern void vr7701_irq_init(void);
extern void vr7701_nmi_init(void);
extern void vr7701_nmi_install(void);

static struct irqaction irq_cascade =
    { no_action, 0, 0, "cascade", NULL, NULL };

static struct irqaction nmi_cascade =
    { no_action, 0, 0, "cascade", NULL, NULL };

void __init
init_IRQ(void)
{
	int i;
	int level;

	set_except_vector(0, vr7701_handle_irq);

	mips_cpu_irq_init(VR7701_CPU_IRQ_BASE);
	vr7701_irq_init();
	vr7701_nmi_init();

	setup_irq(VR7701_CPU_INT, &irq_cascade);
	setup_irq(VR7701_IRQ_NMI, &nmi_cascade);

	/* Assign levels in correspondence to the channel numbers */
	for (i = VR7701_INTCH_NMI, level = 0;
	     i < VR7701_INTCH_NMI + VR7701_NUM_SYS_IRQ; i++, level++) {
		vr7701_outw(VR7701_INTC_CH_LEVEL(i), level);
	}

	vr7701_nmi_install();
#ifdef CONFIG_KGDB
	printk("Setting debug traps - please connect the remote debugger.\n");

	set_debug_traps();

	breakpoint();
#endif
}
