/*
  * arch/mips/vr7701/common/int_handler.S
  *
  * First-level interrupt dispatcher for NEC VR7701 processor.
  *
  * Author: MontaVista Software, Inc. <source@mvista.com>
  *
  * 2003 (c) MontaVista Software, Inc. This file is licensed under
  * the terms of the GNU General Public License version 2. This program
  * is licensed "as is" without any warranty of any kind, whether express
  * or implied.
  */

#include <linux/config.h>

#include <asm/asm.h>
#include <asm/mipsregs.h>
#include <asm/addrspace.h>
#include <asm/regdef.h>
#include <asm/stackframe.h>
#include <asm/vr7701.h>

/*
 * first level interrupt dispatcher for VR7701 chip.
 */
        .align  5
        NESTED(vr7701_handle_irq, PT_SIZE, sp)
        SAVE_ALL
        CLI
        .set    at
        .set    noreorder

        mfc0    t0, CP0_CAUSE
        mfc0    t2, CP0_STATUS
	
        and     t0, t2

        andi    t1, t0, STATUSF_IP7     /* cpu timer */
        bnez    t1, ll_cputimer_irq
        andi    t1, t0, STATUSF_IP2
        bnez    t1, ll_cpu_ip2
        andi    t1, t0, STATUSF_IP0     /* software int 0 */
        bnez    t1, ll_cpu_ip0
        andi    t1, t0, STATUSF_IP1     /* software int 1 */
        bnez    t1, ll_cpu_ip1
        nop
        .set    reorder

        /* wrong alarm or masked ... */
        j       spurious_interrupt
        nop
        END(vr7701_handle_irq)

        .align  5

ll_cputimer_irq:
        li      a0, VR7701_CPU_TIMER
        move    a1, sp
        jal     do_IRQ
        j       ret_from_irq


ll_cpu_ip0:
        li      a0, VR7701_CPU_SW1
        move    a1, sp
        jal     do_IRQ
        j       ret_from_irq

ll_cpu_ip1:
        li      a0, VR7701_CPU_SW2
        move    a1, sp
        jal     do_IRQ
        j       ret_from_irq

ll_cpu_ip2:
        move    a0, sp
        jal     vr7701_irq_dispatch
        j       ret_from_irq

